/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Buffer;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Ogg;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Packet;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis.Block;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis.Comment;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis.Info;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;

public class DspState {
    private long m_lNativeHandle;
    private Info m_info;

    public DspState() {
        int nReturn;
        if (TDebug.TraceVorbisNative) {
            TDebug.out("DspState.<init>(): begin");
        }
        if ((nReturn = this.malloc()) < 0) {
            throw new RuntimeException("malloc of vorbis_dsp_state failed");
        }
        if (TDebug.TraceVorbisNative) {
            TDebug.out("DspState.<init>(): end");
        }
    }

    public void finalize() {
    }

    private native int malloc();

    public native void free();

    public int initAnalysis(Info info) {
        this.m_info = info;
        return this.initAnalysis_native(info);
    }

    public native int initAnalysis_native(Info var1);

    private Info getInfo() {
        return this.m_info;
    }

    public int headerOut(Comment comment, Packet infoPacket, Packet commentPacket, Packet codePacket) {
        Buffer buffer = new Buffer();
        buffer.writeInit();
        this.getInfo().pack(buffer);
        infoPacket.setData(buffer.getBuffer(), 0, buffer.bytes());
        infoPacket.setFlags(true, false, 0L);
        buffer.reset();
        comment.pack(buffer);
        commentPacket.setData(buffer.getBuffer(), 0, buffer.bytes());
        commentPacket.setFlags(false, false, 0L);
        int nReturn = this.headerOut_native(codePacket);
        buffer.writeClear();
        buffer.free();
        return nReturn;
    }

    public native int headerOut_native(Packet var1);

    public int write(float[][] values, int nValues) {
        return this.write_native(values, nValues);
    }

    public native int write_native(float[][] var1, int var2);

    public int blockOut(Block block) {
        return this.blockOut_native(block);
    }

    public native int blockOut_native(Block var1);

    public int flushPacket(Packet packet) {
        return this.flushPacket_native(packet);
    }

    public native int flushPacket_native(Packet var1);

    public int initSynthesis(Info info) {
        return this.initSynthesis_native(info);
    }

    public native int initSynthesis_native(Info var1);

    public int blockIn(Block block) {
        return this.blockIn_native(block);
    }

    public native int blockIn_native(Block var1);

    public int pcmOut(float[][] afPcm) {
        return this.pcmOut_native(afPcm);
    }

    public native int pcmOut_native(float[][] var1);

    public int read(int nSamples) {
        return this.read_native(nSamples);
    }

    public native int read_native(int var1);

    public long getSequence() {
        return this.getSequence_native();
    }

    public native long getSequence_native();

    public void clear() {
        this.clear_native();
    }

    public native void clear_native();

    private static native void setTrace(boolean var0);

    static {
        Ogg.loadNativeLibrary();
        if (TDebug.TraceVorbisNative) {
            DspState.setTrace(true);
        }
    }
}

