/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Page;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;

public class SyncState {
    private byte[] m_abData;
    private int m_nFill;
    private int m_nReturned;
    private boolean m_bUnsynced;
    private int m_nHeaderBytes;
    private int m_nBodyBytes;
    private Page m_tmpPage;
    private byte[] m_abChecksum;

    public SyncState() {
        if (TDebug.TraceOggNative) {
            TDebug.out("SyncState.<init>(): begin");
        }
        this.m_tmpPage = new Page();
        this.m_abChecksum = new byte[4];
        if (TDebug.TraceOggNative) {
            TDebug.out("SyncState.<init>(): end");
        }
    }

    public void free() {
    }

    public void init() {
        this.m_abData = null;
        this.m_nFill = 0;
        this.m_nReturned = 0;
        this.m_bUnsynced = false;
        this.m_nHeaderBytes = 0;
        this.m_nBodyBytes = 0;
    }

    public void clear() {
        this.init();
    }

    public void reset() {
        this.m_nFill = 0;
        this.m_nReturned = 0;
        this.m_bUnsynced = false;
        this.m_nHeaderBytes = 0;
        this.m_nBodyBytes = 0;
    }

    public int write(byte[] abBuffer, int nBytes) {
        if (this.m_nReturned > 0) {
            this.m_nFill -= this.m_nReturned;
            if (this.m_nFill > 0) {
                System.arraycopy(this.m_abData, this.m_nReturned, this.m_abData, 0, this.m_nFill);
            }
            this.m_nReturned = 0;
        }
        if (this.m_abData == null || nBytes > this.m_abData.length - this.m_nFill) {
            int nNewSize = nBytes + this.m_nFill + 4096;
            byte[] abOldBuffer = this.m_abData;
            this.m_abData = new byte[nNewSize];
            if (abOldBuffer != null) {
                System.arraycopy(abOldBuffer, 0, this.m_abData, 0, this.m_nFill);
            }
        }
        System.arraycopy(abBuffer, 0, this.m_abData, this.m_nFill, nBytes);
        this.m_nFill += nBytes;
        return 0;
    }

    public int pageseek(Page page) {
        int nPage = this.m_nReturned;
        int nBytes = this.m_nFill - this.m_nReturned;
        if (this.m_nHeaderBytes == 0) {
            if (nBytes < 27) {
                return 0;
            }
            if (this.m_abData[nPage] != 79 || this.m_abData[nPage + 1] != 103 || this.m_abData[nPage + 2] != 103 || this.m_abData[nPage + 3] != 83) {
                TDebug.out("wrong capture pattern");
                return this.syncFailure();
            }
            int nHeaderBytes = (this.m_abData[nPage + 26] & 0xFF) + 27;
            if (nBytes < nHeaderBytes) {
                return 0;
            }
            for (int i = 0; i < (this.m_abData[nPage + 26] & 0xFF); ++i) {
                this.m_nBodyBytes += this.m_abData[nPage + 27 + i] & 0xFF;
            }
            this.m_nHeaderBytes = nHeaderBytes;
        }
        if (this.m_nBodyBytes + this.m_nHeaderBytes > nBytes) {
            return 0;
        }
        System.arraycopy(this.m_abData, nPage + 22, this.m_abChecksum, 0, 4);
        this.m_abData[nPage + 22] = 0;
        this.m_abData[nPage + 23] = 0;
        this.m_abData[nPage + 24] = 0;
        this.m_abData[nPage + 25] = 0;
        this.m_tmpPage.setData(this.m_abData, nPage, this.m_nHeaderBytes, this.m_abData, nPage + this.m_nHeaderBytes, this.m_nBodyBytes);
        this.m_tmpPage.setChecksum();
        byte[] abHeader = this.m_tmpPage.getHeader();
        if (abHeader[22] != this.m_abChecksum[0] || abHeader[23] != this.m_abChecksum[1] || abHeader[24] != this.m_abChecksum[2] || abHeader[25] != this.m_abChecksum[3]) {
            TDebug.out("wrong checksum");
            TDebug.out("" + this.m_abChecksum[0] + " - " + abHeader[22]);
            TDebug.out("" + this.m_abChecksum[1] + " - " + abHeader[23]);
            TDebug.out("" + this.m_abChecksum[2] + " - " + abHeader[24]);
            TDebug.out("" + this.m_abChecksum[3] + " - " + abHeader[25]);
            System.arraycopy(this.m_abChecksum, 0, this.m_abData, nPage + 22, 4);
            return this.syncFailure();
        }
        page.setData(this.m_abData, nPage, this.m_nHeaderBytes, this.m_abData, nPage + this.m_nHeaderBytes, this.m_nBodyBytes);
        this.m_bUnsynced = false;
        nBytes = this.m_nHeaderBytes + this.m_nBodyBytes;
        this.m_nReturned += nBytes;
        this.m_nHeaderBytes = 0;
        this.m_nBodyBytes = 0;
        return nBytes;
    }

    private int syncFailure() {
        int nPage = this.m_nReturned;
        int nBytes = this.m_nFill - this.m_nReturned;
        this.m_nHeaderBytes = 0;
        this.m_nBodyBytes = 0;
        int nNext = -1;
        for (int i = 0; i < nBytes - 1; ++i) {
            if (this.m_abData[nPage + 1 + i] != 79) continue;
            nNext = nPage + 1 + i;
            break;
        }
        if (nNext == -1) {
            nNext = this.m_nFill;
        }
        this.m_nReturned = nNext;
        return -(nNext - nPage);
    }

    public int pageOut(Page page) {
        do {
            int nReturn;
            if ((nReturn = this.pageseek(page)) > 0) {
                return 1;
            }
            if (nReturn != 0) continue;
            return 0;
        } while (this.m_bUnsynced);
        this.m_bUnsynced = true;
        return -1;
    }
}

