/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Packet;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Page;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;

public class StreamState {
    private static final int INITIAL_BODY_DATA_SIZE = 16384;
    private static final int INITIAL_LACING_VALUES_SIZE = 1024;
    private int m_nSerialNo;
    private byte[] m_abBodyData;
    private int m_nBodyFill;
    private int m_nBodyReturned;
    private int[] m_anLacingValues;
    private long[] m_alGranuleValues;
    private int m_nLacingFill;
    private int m_nLacingPacket;
    private int m_nLacingReturned;
    private byte[] m_abHeader;
    private int m_nHeaderFill;
    private boolean m_bBos;
    private boolean m_bEos;
    private int m_nPageNo;
    private long m_lPacketNo;
    private long m_lGranulePos;

    public StreamState() {
        if (TDebug.TraceOggNative) {
            TDebug.out("StreamState.<init>(): begin");
        }
        if (TDebug.TraceOggNative) {
            TDebug.out("StreamState.<init>(): end");
        }
    }

    public void free() {
    }

    public int init(int nSerialNo) {
        int i;
        this.m_nSerialNo = nSerialNo;
        this.m_abBodyData = new byte[16384];
        this.m_nBodyFill = 0;
        this.m_nBodyReturned = 0;
        this.m_anLacingValues = new int[1024];
        this.m_alGranuleValues = new long[1024];
        this.m_nLacingFill = 0;
        this.m_nLacingPacket = 0;
        this.m_nLacingReturned = 0;
        this.m_abHeader = new byte[282];
        this.m_nHeaderFill = 0;
        this.m_bBos = false;
        this.m_bEos = false;
        this.m_nPageNo = 0;
        this.m_lPacketNo = 0L;
        this.m_lGranulePos = 0L;
        for (i = 0; i < this.m_abBodyData.length; ++i) {
            this.m_abBodyData[i] = 0;
        }
        for (i = 0; i < this.m_anLacingValues.length; ++i) {
            this.m_anLacingValues[i] = 0;
        }
        for (i = 0; i < this.m_alGranuleValues.length; ++i) {
            this.m_alGranuleValues[i] = 0L;
        }
        return 0;
    }

    public int clear() {
        this.m_nSerialNo = 0;
        this.m_abBodyData = null;
        this.m_nBodyFill = 0;
        this.m_nBodyReturned = 0;
        this.m_anLacingValues = null;
        this.m_alGranuleValues = null;
        this.m_nLacingFill = 0;
        this.m_nLacingPacket = 0;
        this.m_nLacingReturned = 0;
        this.m_abHeader = null;
        this.m_nHeaderFill = 0;
        this.m_bBos = false;
        this.m_bEos = false;
        this.m_nPageNo = 0;
        this.m_lPacketNo = 0L;
        this.m_lGranulePos = 0L;
        return 0;
    }

    public int reset() {
        this.m_nBodyFill = 0;
        this.m_nBodyReturned = 0;
        this.m_nLacingFill = 0;
        this.m_nLacingPacket = 0;
        this.m_nLacingReturned = 0;
        this.m_nHeaderFill = 0;
        this.m_bBos = false;
        this.m_bEos = false;
        this.m_nPageNo = -1;
        this.m_lPacketNo = 0L;
        this.m_lGranulePos = 0L;
        return 0;
    }

    public boolean isEOSReached() {
        return this.m_bEos;
    }

    public int packetIn(Packet packet) {
        byte[] abPacketData = packet.getData();
        int lacing_vals = abPacketData.length / 255 + 1;
        if (this.m_nBodyReturned > 0) {
            this.m_nBodyFill -= this.m_nBodyReturned;
            if (this.m_nBodyFill > 0) {
                System.arraycopy(this.m_abBodyData, this.m_nBodyReturned, this.m_abBodyData, 0, this.m_nBodyFill);
            }
            this.m_nBodyReturned = 0;
        }
        this.assureBodyDataCapacity(abPacketData.length);
        this.assureLacingValuesCapacity(lacing_vals);
        System.arraycopy(abPacketData, 0, this.m_abBodyData, this.m_nBodyFill, abPacketData.length);
        this.m_nBodyFill += abPacketData.length;
        for (int i = 0; i < lacing_vals - 1; ++i) {
            this.m_anLacingValues[this.m_nLacingFill + i] = 255;
            this.m_alGranuleValues[this.m_nLacingFill + i] = this.m_lGranulePos;
        }
        this.m_anLacingValues[this.m_nLacingFill + i] = abPacketData.length % 255;
        this.m_alGranuleValues[this.m_nLacingFill + i] = packet.getGranulePos();
        this.m_lGranulePos = packet.getGranulePos();
        int n = this.m_nLacingFill;
        this.m_anLacingValues[n] = this.m_anLacingValues[n] | 0x100;
        this.m_nLacingFill += lacing_vals;
        ++this.m_lPacketNo;
        if (packet.isEos()) {
            this.m_bEos = true;
        }
        return 0;
    }

    public int pageOut(Page page) {
        if (this.m_bEos && this.m_nLacingFill > 0 || this.m_nBodyFill - this.m_nBodyReturned > 4096 || this.m_nLacingFill >= 255 || this.m_nLacingFill > 0 && !this.m_bBos) {
            return this.flush(page);
        }
        return 0;
    }

    public int flush(Page page) {
        int i;
        int vals = 0;
        int maxvals = Math.min(this.m_nLacingFill, 255);
        int bytes = 0;
        int acc = 0;
        long granule_pos = this.m_alGranuleValues[0];
        if (maxvals == 0) {
            return 0;
        }
        if (!this.m_bBos) {
            granule_pos = 0L;
            for (vals = 0; vals < maxvals; ++vals) {
                if ((this.m_anLacingValues[vals] & 0xFF) >= 255) continue;
                ++vals;
                break;
            }
        } else {
            for (vals = 0; vals < maxvals && acc <= 4096; acc += this.m_anLacingValues[vals] & 0xFF, ++vals) {
                granule_pos = this.m_alGranuleValues[vals];
            }
        }
        this.m_abHeader[0] = 79;
        this.m_abHeader[1] = 103;
        this.m_abHeader[2] = 103;
        this.m_abHeader[3] = 83;
        this.m_abHeader[4] = 0;
        this.m_abHeader[5] = 0;
        if ((this.m_anLacingValues[0] & 0x100) == 0) {
            this.m_abHeader[5] = (byte)(this.m_abHeader[5] | 1);
        }
        if (!this.m_bBos) {
            this.m_abHeader[5] = (byte)(this.m_abHeader[5] | 2);
        }
        if (this.m_bEos && this.m_nLacingFill == vals) {
            this.m_abHeader[5] = (byte)(this.m_abHeader[5] | 4);
        }
        this.m_bBos = true;
        for (i = 6; i < 14; ++i) {
            this.m_abHeader[i] = (byte)(granule_pos & 0xFFL);
            granule_pos >>>= 8;
        }
        int serialno = this.m_nSerialNo;
        for (i = 14; i < 18; ++i) {
            this.m_abHeader[i] = (byte)(serialno & 0xFF);
            serialno >>>= 8;
        }
        if (this.m_nPageNo == -1) {
            this.m_nPageNo = 0;
        }
        int pageno = this.m_nPageNo++;
        for (i = 18; i < 22; ++i) {
            this.m_abHeader[i] = (byte)(pageno & 0xFF);
            pageno >>>= 8;
        }
        this.m_abHeader[22] = 0;
        this.m_abHeader[23] = 0;
        this.m_abHeader[24] = 0;
        this.m_abHeader[25] = 0;
        this.m_abHeader[26] = (byte)(vals & 0xFF);
        for (i = 0; i < vals; ++i) {
            this.m_abHeader[i + 27] = (byte)(this.m_anLacingValues[i] & 0xFF);
            bytes += this.m_anLacingValues[i] & 0xFF;
        }
        page.setData(this.m_abHeader, 0, vals + 27, this.m_abBodyData, this.m_nBodyReturned, bytes);
        this.m_nHeaderFill = vals + 27;
        this.m_nLacingFill -= vals;
        System.arraycopy(this.m_anLacingValues, vals, this.m_anLacingValues, 0, this.m_nLacingFill);
        System.arraycopy(this.m_alGranuleValues, vals, this.m_alGranuleValues, 0, this.m_nLacingFill);
        this.m_nBodyReturned += bytes;
        page.setChecksum();
        return 1;
    }

    public int pageIn(Page page) {
        int val;
        byte[] header = page.getHeader();
        byte[] body = page.getBody();
        int nBodyOffset = 0;
        int bodysize = body.length;
        int segptr = 0;
        int version = page.getVersion();
        boolean continued = page.isContinued();
        boolean bos = page.isBos();
        boolean eos = page.isEos();
        long granulepos = page.getGranulePos();
        int serialno = page.getSerialNo();
        int pageno = page.getPageNo();
        int segments = header[26] & 0xFF;
        int lr = this.m_nLacingReturned;
        int br = this.m_nBodyReturned;
        if (br > 0) {
            this.m_nBodyFill -= br;
            if (this.m_nBodyFill > 0) {
                System.arraycopy(this.m_abBodyData, br, this.m_abBodyData, 0, this.m_nBodyFill);
            }
            this.m_nBodyReturned = 0;
        }
        if (lr > 0) {
            if (this.m_nLacingFill - lr > 0) {
                System.arraycopy(this.m_anLacingValues, lr, this.m_anLacingValues, 0, this.m_nLacingFill - lr);
                System.arraycopy(this.m_alGranuleValues, lr, this.m_alGranuleValues, 0, this.m_nLacingFill - lr);
            }
            this.m_nLacingFill -= lr;
            this.m_nLacingPacket -= lr;
            this.m_nLacingReturned = 0;
        }
        if (serialno != this.m_nSerialNo) {
            return -1;
        }
        if (version > 0) {
            return -1;
        }
        this.assureLacingValuesCapacity(segments + 1);
        if (pageno != this.m_nPageNo) {
            for (int i = this.m_nLacingPacket; i < this.m_nLacingFill; ++i) {
                this.m_nBodyFill -= this.m_anLacingValues[i] & 0xFF;
            }
            this.m_nLacingFill = this.m_nLacingPacket++;
            if (this.m_nPageNo != -1) {
                this.m_anLacingValues[this.m_nLacingFill] = 1024;
                ++this.m_nLacingFill;
            }
            if (continued) {
                bos = false;
                while (segptr < segments) {
                    val = header[27 + segptr] & 0xFF;
                    nBodyOffset += val;
                    bodysize -= val;
                    if (val < 255) {
                        ++segptr;
                        break;
                    }
                    ++segptr;
                }
            }
        }
        if (bodysize > 0) {
            this.assureBodyDataCapacity(bodysize);
            System.arraycopy(body, nBodyOffset, this.m_abBodyData, this.m_nBodyFill, bodysize);
            this.m_nBodyFill += bodysize;
        }
        int saved = -1;
        while (segptr < segments) {
            this.m_anLacingValues[this.m_nLacingFill] = val = header[27 + segptr] & 0xFF;
            this.m_alGranuleValues[this.m_nLacingFill] = -1L;
            if (bos) {
                int n = this.m_nLacingFill;
                this.m_anLacingValues[n] = this.m_anLacingValues[n] | 0x100;
                bos = false;
            }
            if (val < 255) {
                saved = this.m_nLacingFill;
            }
            ++this.m_nLacingFill;
            ++segptr;
            if (val >= 255) continue;
            this.m_nLacingPacket = this.m_nLacingFill;
        }
        if (saved != -1) {
            this.m_alGranuleValues[saved] = granulepos;
        }
        if (eos) {
            this.m_bEos = true;
            if (this.m_nLacingFill > 0) {
                int n = this.m_nLacingFill - 1;
                this.m_anLacingValues[n] = this.m_anLacingValues[n] | 0x200;
            }
        }
        this.m_nPageNo = pageno + 1;
        return 0;
    }

    public int packetOut(Packet packet) {
        return this.packetOutInternal(packet, true);
    }

    public int packetPeek(Packet packet) {
        return this.packetOutInternal(packet, false);
    }

    private int packetOutInternal(Packet packet, boolean bAdvance) {
        boolean bos;
        int size;
        int ptr;
        if (this.m_nLacingPacket <= (ptr = this.m_nLacingReturned++)) {
            return 0;
        }
        if ((this.m_anLacingValues[ptr] & 0x400) != 0) {
            ++this.m_lPacketNo;
            return -1;
        }
        if (packet == null && !bAdvance) {
            return 1;
        }
        int bytes = size = this.m_anLacingValues[ptr] & 0xFF;
        boolean eos = (this.m_anLacingValues[ptr] & 0x200) != 0;
        boolean bl = bos = (this.m_anLacingValues[ptr] & 0x100) != 0;
        while (size == 255) {
            int val = this.m_anLacingValues[++ptr];
            size = val & 0xFF;
            if ((val & 0x200) != 0) {
                eos = true;
            }
            bytes += size;
        }
        if (packet != null) {
            packet.setData(this.m_abBodyData, this.m_nBodyReturned, bytes);
            packet.setFlags(bos, eos, this.m_alGranuleValues[ptr], this.m_lPacketNo);
        }
        if (bAdvance) {
            this.m_nBodyReturned += bytes;
            this.m_nLacingReturned = ptr + 1;
            ++this.m_lPacketNo;
        }
        return 1;
    }

    private void assureBodyDataCapacity(int needed) {
        if (this.m_abBodyData.length <= this.m_nBodyFill + needed) {
            int nNewSize = this.m_abBodyData.length + needed + 1024;
            byte[] abNewBodyData = new byte[nNewSize];
            System.arraycopy(this.m_abBodyData, 0, abNewBodyData, 0, this.m_abBodyData.length);
            this.m_abBodyData = abNewBodyData;
        }
    }

    private void assureLacingValuesCapacity(int needed) {
        if (this.m_anLacingValues.length <= this.m_nLacingFill + needed) {
            int nNewSize = this.m_anLacingValues.length + needed + 32;
            int[] anNewLacingValues = new int[nNewSize];
            System.arraycopy(this.m_anLacingValues, 0, anNewLacingValues, 0, this.m_anLacingValues.length);
            this.m_anLacingValues = anNewLacingValues;
            long[] alNewGranuleValues = new long[nNewSize];
            System.arraycopy(this.m_alGranuleValues, 0, alNewGranuleValues, 0, this.m_alGranuleValues.length);
            this.m_alGranuleValues = alNewGranuleValues;
        }
    }
}

