/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.lame;

import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lame {
    public static final AudioFormat.Encoding MPEG1L3 = new AudioFormat.Encoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L3 = new AudioFormat.Encoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = new AudioFormat.Encoding("MPEG2DOT5L3");
    public static final String P_ENCODING = "encoding";
    public static final String P_SAMPLERATE = "samplerate";
    public static final String P_VBR = "vbr";
    public static final String P_CHMODE = "chmode";
    public static final String P_BITRATE = "bitrate";
    public static final String P_QUALITY = "quality";
    public static final int MPEG_VERSION_2 = 0;
    public static final int MPEG_VERSION_1 = 1;
    public static final int MPEG_VERSION_2DOT5 = 2;
    public static final int QUALITY_LOWEST = 9;
    public static final int QUALITY_LOW = 7;
    public static final int QUALITY_MIDDLE = 5;
    public static final int QUALITY_HIGH = 2;
    public static final int QUALITY_HIGHEST = 1;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int CHANNEL_MODE_AUTO = -1;
    public static final int BITRATE_AUTO = -1;
    private static final int DEFAULT_PCM_BUFFER_SIZE = 32768;
    private static boolean libAvailable = false;
    private static String linkError = "";
    private static int DEFAULT_QUALITY = 5;
    private static int DEFAULT_BITRATE = -1;
    private static int DEFAULT_CHANNEL_MODE = -1;
    private static boolean DEFAULT_VBR = false;
    private static final int OUT_OF_MEMORY = -300;
    private static final int NOT_INITIALIZED = -301;
    private static final int LAME_ENC_NOT_FOUND = -302;
    private static final String PROPERTY_PREFIX = "tritonus.lame.";
    private long m_lNativeGlobalFlags;
    private int quality = DEFAULT_QUALITY;
    private int bitRate = DEFAULT_BITRATE;
    private boolean vbr = DEFAULT_VBR;
    private int chMode = DEFAULT_CHANNEL_MODE;
    private int effQuality;
    private int effBitRate;
    private int effVbr;
    private int effChMode;
    private int effSampleRate;
    private int effEncoding;
    private boolean hadSystemProps = false;

    private void handleNativeException(int resultCode) {
        this.close();
        if (resultCode == -300) {
            throw new OutOfMemoryError("out of memory");
        }
        if (resultCode == -301) {
            throw new RuntimeException("not initialized");
        }
        if (resultCode == -302) {
            libAvailable = false;
            linkError = "lame_enc.dll not found";
            throw new IllegalArgumentException(linkError);
        }
    }

    public Lame(AudioFormat sourceFormat) {
        this.readParams(sourceFormat, null);
        this.initParams(sourceFormat);
    }

    public Lame(AudioFormat sourceFormat, AudioFormat targetFormat) {
        this.readParams(sourceFormat, targetFormat.properties());
        this.initParams(sourceFormat);
    }

    public Lame(AudioFormat sourceFormat, int bitRate, int channelMode, int quality, boolean VBR) {
        this.bitRate = bitRate;
        this.chMode = channelMode;
        this.quality = quality;
        this.vbr = VBR;
        this.initParams(sourceFormat);
    }

    private void readParams(AudioFormat sourceFormat, Map<String, Object> props) {
        if (props == null || props.size() == 0) {
            this.readSystemProps();
        }
        if (props != null) {
            this.readProps(props);
        }
    }

    private void initParams(AudioFormat sourceFormat) {
        int result;
        if (sourceFormat.getSampleRate() < 32000.0f && this.bitRate > 160) {
            this.bitRate = 160;
        }
        if (TDebug.TraceAudioConverter) {
            String br = this.bitRate < 0 ? "auto" : String.valueOf(this.bitRate) + "KBit/s";
            TDebug.out("LAME parameters: channels=" + sourceFormat.getChannels() + "  sample rate=" + Math.round(sourceFormat.getSampleRate()) + "Hz" + "  bitrate=" + br);
            TDebug.out("                 channelMode=" + this.chmode2string(this.chMode) + "   quality=" + this.quality + " (" + this.quality2string(this.quality) + ")   VBR=" + this.vbr + "  bigEndian=" + sourceFormat.isBigEndian());
        }
        if ((result = this.nInitParams(sourceFormat.getChannels(), Math.round(sourceFormat.getSampleRate()), this.bitRate, this.chMode, this.quality, this.vbr, sourceFormat.isBigEndian())) < 0) {
            this.handleNativeException(result);
            throw new IllegalArgumentException("parameters not supported by LAME (returned " + result + ")");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("LAME effective quality=" + this.effQuality + " (" + this.quality2string(this.effQuality) + ")");
        }
        if (this.hadSystemProps) {
            this.setEffectiveParamsToSystemProps();
        }
    }

    private native int nInitParams(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    private native int nGetEncoderVersion(byte[] var1);

    public String getEncoderVersion() {
        byte[] string = new byte[300];
        int res = this.nGetEncoderVersion(string);
        if (res < 0) {
            if (res == -1) {
                throw new RuntimeException("Unexpected error in Lame.getEncoderVersion()");
            }
            this.handleNativeException(res);
        }
        String sRes = "";
        if (res > 0) {
            try {
                sRes = new String(string, 0, res, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(uee);
                }
                sRes = new String(string, 0, res);
            }
        }
        return sRes;
    }

    private native int nGetPCMBufferSize(int var1);

    public int getPCMBufferSize() {
        int ret = this.nGetPCMBufferSize(32768);
        if (ret < 0) {
            this.handleNativeException(ret);
            throw new RuntimeException("Unknown error in Lame.nGetPCMBufferSize(). Resultcode=" + ret);
        }
        return ret;
    }

    public int getMP3BufferSize() {
        return this.getPCMBufferSize() / 2 + 1024;
    }

    private native int nEncodeBuffer(byte[] var1, int var2, int var3, byte[] var4);

    public int encodeBuffer(byte[] pcm, int offset, int length, byte[] encoded) throws ArrayIndexOutOfBoundsException {
        if (length < 0 || offset + length > pcm.length) {
            throw new IllegalArgumentException("inconsistent parameters");
        }
        int result = this.nEncodeBuffer(pcm, offset, length, encoded);
        if (result < 0) {
            if (result == -1) {
                throw new ArrayIndexOutOfBoundsException("Encode buffer too small");
            }
            this.handleNativeException(result);
            throw new RuntimeException("crucial error in encodeBuffer.");
        }
        return result;
    }

    private native int nEncodeFinish(byte[] var1);

    public int encodeFinish(byte[] encoded) {
        return this.nEncodeFinish(encoded);
    }

    private native void nClose();

    public void close() {
        this.nClose();
    }

    public static boolean isLibAvailable() {
        return libAvailable;
    }

    public static String getLinkError() {
        return linkError;
    }

    private void readProps(Map<String, Object> props) {
        Object q = props.get(P_QUALITY);
        if (q instanceof String) {
            this.quality = this.string2quality(((String)q).toLowerCase(), this.quality);
        } else if (q instanceof Integer) {
            this.quality = (Integer)q;
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of quality property: " + q);
        }
        q = props.get(P_BITRATE);
        if (q instanceof String) {
            this.bitRate = Integer.parseInt((String)q);
        } else if (q instanceof Integer) {
            this.bitRate = (Integer)q;
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of bitrate property: " + q);
        }
        q = props.get(P_CHMODE);
        if (q instanceof String) {
            this.chMode = this.string2chmode(((String)q).toLowerCase(), this.chMode);
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of chmode property: " + q);
        }
        q = props.get(P_VBR);
        if (q instanceof String) {
            this.vbr = Lame.string2bool((String)q);
        } else if (q instanceof Boolean) {
            this.vbr = (Boolean)q;
        } else if (q != null) {
            throw new IllegalArgumentException("illegal type of vbr property: " + q);
        }
    }

    public AudioFormat getEffectiveFormat() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUALITY, this.getEffectiveQuality());
        map.put(P_BITRATE, this.getEffectiveBitRate());
        map.put(P_CHMODE, this.chmode2string(this.getEffectiveChannelMode()));
        map.put(P_VBR, this.getEffectiveVBR());
        map.put("encoder.name", "LAME");
        map.put("encoder.version", this.getEncoderVersion());
        int channels = 2;
        if (this.chMode == 3) {
            channels = 1;
        }
        return new AudioFormat(this.getEffectiveEncoding(), this.getEffectiveSampleRate(), -1, channels, -1, -1.0f, false, map);
    }

    public int getEffectiveQuality() {
        if (this.effQuality >= 9) {
            return 9;
        }
        if (this.effQuality >= 7) {
            return 7;
        }
        if (this.effQuality >= 5) {
            return 5;
        }
        if (this.effQuality >= 2) {
            return 2;
        }
        return 1;
    }

    public int getEffectiveBitRate() {
        return this.effBitRate;
    }

    public int getEffectiveChannelMode() {
        return this.effChMode;
    }

    public boolean getEffectiveVBR() {
        return this.effVbr != 0;
    }

    public int getEffectiveSampleRate() {
        return this.effSampleRate;
    }

    public AudioFormat.Encoding getEffectiveEncoding() {
        if (this.effEncoding == 0) {
            if (this.getEffectiveSampleRate() < 16000) {
                return MPEG2DOT5L3;
            }
            return MPEG2L3;
        }
        if (this.effEncoding == 2) {
            return MPEG2DOT5L3;
        }
        return MPEG1L3;
    }

    private void setEffectiveParamsToSystemProps() {
        block2: {
            try {
                System.setProperty("tritonus.lame.effective.quality", this.quality2string(this.getEffectiveQuality()));
                System.setProperty("tritonus.lame.effective.bitrate", String.valueOf(this.getEffectiveBitRate()));
                System.setProperty("tritonus.lame.effective.chmode", this.chmode2string(this.getEffectiveChannelMode()));
                System.setProperty("tritonus.lame.effective.vbr", String.valueOf(this.getEffectiveVBR()));
                System.setProperty("tritonus.lame.effective.samplerate", String.valueOf(this.getEffectiveSampleRate()));
                System.setProperty("tritonus.lame.effective.encoding", this.getEffectiveEncoding().toString());
                System.setProperty("tritonus.lame.encoder.version", this.getEncoderVersion());
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(t);
            }
        }
    }

    private void readSystemProps() {
        block3: {
            String v = this.getStringProperty(P_QUALITY, this.quality2string(this.quality));
            this.quality = this.string2quality(v.toLowerCase(), this.quality);
            this.bitRate = this.getIntProperty(P_BITRATE, this.bitRate);
            v = this.getStringProperty(P_CHMODE, this.chmode2string(this.chMode));
            this.chMode = this.string2chmode(v.toLowerCase(), this.chMode);
            this.vbr = this.getBooleanProperty(P_VBR, this.vbr);
            if (this.hadSystemProps) {
                try {
                    System.setProperty("tritonus.lame.quality", this.quality2string(DEFAULT_QUALITY));
                    System.setProperty("tritonus.lame.bitrate", String.valueOf(DEFAULT_BITRATE));
                    System.setProperty("tritonus.lame.chmode", this.chmode2string(DEFAULT_CHANNEL_MODE));
                    System.setProperty("tritonus.lame.vbr", String.valueOf(DEFAULT_VBR));
                }
                catch (Throwable t) {
                    if (!TDebug.TraceAllExceptions) break block3;
                    TDebug.out(t);
                }
            }
        }
    }

    private String quality2string(int quality) {
        if (quality >= 9) {
            return "lowest";
        }
        if (quality >= 7) {
            return "low";
        }
        if (quality >= 5) {
            return "middle";
        }
        if (quality >= 2) {
            return "high";
        }
        return "highest";
    }

    private int string2quality(String quality, int def) {
        if (quality.equals("lowest")) {
            return 9;
        }
        if (quality.equals("low")) {
            return 7;
        }
        if (quality.equals("middle")) {
            return 5;
        }
        if (quality.equals("high")) {
            return 2;
        }
        if (quality.equals("highest")) {
            return 1;
        }
        return def;
    }

    private String chmode2string(int chmode) {
        if (chmode == 0) {
            return "stereo";
        }
        if (chmode == 1) {
            return "jointstereo";
        }
        if (chmode == 2) {
            return "dual";
        }
        if (chmode == 3) {
            return "mono";
        }
        if (chmode == -1) {
            return "auto";
        }
        return "auto";
    }

    private int string2chmode(String chmode, int def) {
        if (chmode.equals("stereo")) {
            return 0;
        }
        if (chmode.equals("jointstereo")) {
            return 1;
        }
        if (chmode.equals("dual")) {
            return 2;
        }
        if (chmode.equals("mono")) {
            return 3;
        }
        if (chmode.equals("auto")) {
            return -1;
        }
        return def;
    }

    private static boolean string2bool(String val) {
        if (val.length() > 0) {
            if (val.charAt(0) == 'f' || val.charAt(0) == 'n' || val.equals("off")) {
                return false;
            }
            if (val.charAt(0) == 't' || val.charAt(0) == 'y' || val.equals("on")) {
                return true;
            }
        }
        throw new IllegalArgumentException("wrong string for boolean property: " + val);
    }

    private boolean getBooleanProperty(String strName, boolean def) {
        String strValue;
        block4: {
            String strPropertyName = PROPERTY_PREFIX + strName;
            strValue = def ? "true" : "false";
            try {
                String s = System.getProperty(strPropertyName);
                if (s != null && s.length() > 0) {
                    this.hadSystemProps = true;
                    strValue = s;
                }
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block4;
                TDebug.out(t);
            }
        }
        strValue = strValue.toLowerCase();
        boolean bValue = false;
        if (strValue.length() > 0) {
            bValue = def ? strValue.charAt(0) != 'f' && strValue.charAt(0) != 'n' && !strValue.equals("off") : strValue.charAt(0) == 't' || strValue.charAt(0) == 'y' || strValue.equals("on");
        }
        return bValue;
    }

    private String getStringProperty(String strName, String def) {
        String strValue;
        block3: {
            String strPropertyName = PROPERTY_PREFIX + strName;
            strValue = def;
            try {
                String s = System.getProperty(strPropertyName);
                if (s != null && s.length() > 0) {
                    this.hadSystemProps = true;
                    strValue = s;
                }
            }
            catch (Throwable t) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out(t);
            }
        }
        return strValue;
    }

    private int getIntProperty(String strName, int def) {
        int value;
        block3: {
            String strPropertyName = PROPERTY_PREFIX + strName;
            value = def;
            try {
                String s = System.getProperty(strPropertyName);
                if (s != null && s.length() > 0) {
                    this.hadSystemProps = true;
                    value = new Integer(s);
                }
            }
            catch (Throwable e) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out(e);
            }
        }
        return value;
    }

    static {
        try {
            System.loadLibrary("lametritonus");
            libAvailable = true;
        }
        catch (UnsatisfiedLinkError e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            linkError = e.getMessage();
        }
    }
}

