/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Add;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Gsm_Def;

public class Rpe {
    private short exp_in;
    private short mant_in;
    private short exp_out;
    private short mant_out;
    private int xMp_point = 0;
    private static final int ENCODE = 0;
    private static final int DECODE = 1;
    private short[] x = new short[40];

    public void Gsm_RPE_Encoding(short[] e, short[] xmaxc, short[] Mc, int xmaxc_Mc_index, short[] xMc, int xMc_index) {
        short[] xM = new short[13];
        short[] xMp = new short[13];
        this.Weighting_filter(e);
        this.RPE_grid_selection(xM, Mc, xmaxc_Mc_index);
        this.APCM_quantization(xM, xMc, xMc_index, xmaxc, xmaxc_Mc_index);
        this.APCM_inverse_quantization(xMc, xMp, xMc_index, 0);
        Rpe.RPE_grid_positioning(Mc[xmaxc_Mc_index], xMp, e, 0);
    }

    private void Weighting_filter(short[] e) {
        int L_result = 0;
        for (int k = 0; k <= 39; ++k) {
            L_result = 4096;
            L_result += e[k + 0] * -134 + e[k + 1] * -374 + e[k + 3] * 2054 + e[k + 4] * 5741 + e[k + 5] * 8192 + e[k + 6] * 5741 + e[k + 7] * 2054 + e[k + 9] * -374 + e[k + 10] * -134;
            this.x[k] = (short)((L_result = (int)Add.SASR(L_result, 13)) < Short.MIN_VALUE ? Short.MIN_VALUE : (L_result > Short.MAX_VALUE ? Short.MAX_VALUE : L_result));
        }
    }

    private void RPE_grid_selection(short[] xM, short[] Mc_out, int Mc_index) {
        int L_result = 0;
        int EM = 0;
        int Mc = 0;
        L_result = 0;
        int L_common_0_3 = L_result += this.STEP(0, 1) + this.STEP(0, 2) + this.STEP(0, 3) + this.STEP(0, 4) + this.STEP(0, 5) + this.STEP(0, 6) + this.STEP(0, 7) + this.STEP(0, 8) + this.STEP(0, 9) + this.STEP(0, 10) + this.STEP(0, 11) + this.STEP(0, 12);
        L_result += this.STEP(0, 0);
        EM = L_result <<= 1;
        L_result = 0;
        L_result += this.STEP(1, 0) + this.STEP(1, 1) + this.STEP(1, 2) + this.STEP(1, 3) + this.STEP(1, 4) + this.STEP(1, 5) + this.STEP(1, 6) + this.STEP(1, 7) + this.STEP(1, 8) + this.STEP(1, 9) + this.STEP(1, 10) + this.STEP(1, 11) + this.STEP(1, 12);
        if ((L_result <<= 1) > EM) {
            Mc = 1;
            EM = L_result;
        }
        L_result = 0;
        L_result += this.STEP(2, 0) + this.STEP(2, 1) + this.STEP(2, 2) + this.STEP(2, 3) + this.STEP(2, 4) + this.STEP(2, 5) + this.STEP(2, 6) + this.STEP(2, 7) + this.STEP(2, 8) + this.STEP(2, 9) + this.STEP(2, 10) + this.STEP(2, 11) + this.STEP(2, 12);
        if ((L_result <<= 1) > EM) {
            Mc = 2;
            EM = L_result;
        }
        L_result = L_common_0_3;
        L_result += this.STEP(3, 12);
        if ((L_result <<= 1) > EM) {
            Mc = 3;
            EM = L_result;
        }
        for (int i = 0; i <= 12; ++i) {
            xM[i] = this.x[Mc + 3 * i];
        }
        Mc_out[Mc_index] = Mc;
    }

    private int STEP(int m, int i) {
        short L_temp = Add.SASR(this.x[m + 3 * i], 2);
        return L_temp * L_temp;
    }

    private void APCM_quantization(short[] xM, short[] xMc, int xMc_index, short[] xmaxc_out, int xmaxc_index) throws IllegalArgumentException {
        int i;
        boolean itest = false;
        short xmax = 0;
        short xmaxc = 0;
        short temp = 0;
        short temp1 = 0;
        short temp2 = 0;
        int exp = 0;
        short mant = 0;
        for (i = 0; i <= 12; ++i) {
            temp = xM[i];
            if ((temp = Add.GSM_ABS(temp)) <= xmax) continue;
            xmax = temp;
        }
        exp = 0;
        temp = Add.SASR(xmax, 9);
        itest = false;
        for (i = 0; i <= 5; ++i) {
            itest = temp <= 0 ? (itest |= true) : (itest |= false);
            temp = Add.SASR(temp, 1);
            if (exp > 5) {
                throw new IllegalArgumentException("APCM_quantization: exp = " + exp + " is out of range. Should be <= 5");
            }
            if (itest) continue;
            exp = (short)(exp + 1);
        }
        if (exp > 6 || exp < 0) {
            throw new IllegalArgumentException("APCM_quantization: exp = " + exp + " is out of range. Should be >= -4 and <= 6");
        }
        temp = (short)(exp + 5);
        if (temp > 11 || temp < 0) {
            throw new IllegalArgumentException("APCM_quantization: temp = " + temp + " is out of range. Should be >= 0 and <= 11");
        }
        xmaxc = Add.GSM_ADD(Add.SASR(xmax, temp), (short)(exp << 3));
        this.APCM_quantization_xmaxc_to_exp_mant(xmaxc, 0);
        exp = this.exp_in;
        mant = this.mant_in;
        if (exp > 4096 || exp < -4096) {
            throw new IllegalArgumentException("APCM_quantization: exp = " + exp + " is out of range. Should be >= -4096 and <= 4096");
        }
        if (mant < 0 || mant > 7) {
            throw new IllegalArgumentException("APCM_quantization: mant = " + mant + " is out of range. Should be >= 0 and <= 7");
        }
        temp1 = (short)(6 - exp);
        temp2 = Gsm_Def.gsm_NRFAC[mant];
        for (i = 0; i <= 12; ++i) {
            if (temp1 < 0 || temp1 >= 16) {
                throw new IllegalArgumentException("APCM_quantization: temp = " + temp + " is out of range. Should be >= 0 and < 16");
            }
            temp = (short)(xM[i] << temp1);
            temp = Add.GSM_MULT(temp, temp2);
            temp = Add.SASR(temp, 12);
            xMc[i + xMc_index] = (short)(temp + 4);
        }
        this.mant_in = mant;
        this.exp_in = (short)exp;
        xmaxc_out[xmaxc_index] = xmaxc;
    }

    public void APCM_quantization_xmaxc_to_exp_mant(short xmaxc_elem, int METHOD_ID) throws IllegalArgumentException {
        int exp = 0;
        short mant = 0;
        if (xmaxc_elem > 15) {
            exp = (short)(Add.SASR(xmaxc_elem, 3) - 1);
        }
        if ((mant = (short)(xmaxc_elem - (exp << 3))) == 0) {
            exp = -4;
            mant = (short)7;
        } else {
            while (mant <= 7) {
                mant = (short)(mant << 1 | 1);
                exp = (short)(exp - 1);
            }
            mant = (short)(mant - 8);
        }
        if (exp < -4 || exp > 6) {
            throw new IllegalArgumentException("APCM_quantization_xmaxc_to_exp_mant: exp = " + exp + " is out of range. Should be >= -4 and <= 6");
        }
        if (mant < 0 || mant > 7) {
            throw new IllegalArgumentException("APCM_quantization_xmaxc_to_exp_mant: mant = " + mant + " is out of range. Should be >= 0 and <= 7");
        }
        if (METHOD_ID == 0) {
            this.exp_in = (short)exp;
            this.mant_in = mant;
        } else {
            this.exp_out = (short)exp;
            this.mant_out = mant;
        }
    }

    public void Gsm_RPE_Decoding_java(short xmaxc_elem, short Mc_elem, int xmc_start, short[] xmc, short[] erp) {
        short[] xMp = new short[13];
        this.APCM_quantization_xmaxc_to_exp_mant(xmaxc_elem, 1);
        this.APCM_inverse_quantization(xmc, xMp, xmc_start, 1);
        Rpe.RPE_grid_positioning(Mc_elem, xMp, erp, 1);
    }

    public void APCM_inverse_quantization(short[] xmc, short[] xMp, int xmc_start, int METHOD_ID) throws IllegalArgumentException {
        short temp2;
        short temp1;
        if (METHOD_ID == 0) {
            temp1 = Gsm_Def.gsm_FAC[this.mant_in];
            temp2 = Add.GSM_SUB((short)6, this.exp_in);
        } else {
            temp1 = Gsm_Def.gsm_FAC[this.mant_out];
            temp2 = Add.GSM_SUB((short)6, this.exp_out);
        }
        short temp3 = Add.gsm_asl((short)1, Add.GSM_SUB(temp2, (short)1));
        this.xMp_point = 0;
        for (int i = 0; i < 13; ++i) {
            short temp;
            if ((temp = (short)((xmc[xmc_start++] << 1) - 7)) > 7 || temp < -7) {
                throw new IllegalArgumentException("APCM_inverse_quantization: temp = " + temp + " is out of range. Should be >= -7 and <= 7");
            }
            temp = (short)(temp << 12);
            temp = Add.GSM_MULT_R(temp1, temp);
            temp = Add.GSM_ADD(temp, temp3);
            xMp[this.xMp_point++] = Add.gsm_asr(temp, temp2);
        }
    }

    public static void RPE_grid_positioning(short Mc, short[] xMp, short[] ep, int METHOD_ID) throws IllegalArgumentException {
        int i = 13;
        int xMp_index = 0;
        int ep_index = METHOD_ID == 0 ? 5 : 0;
        if (0 > Mc || Mc > 3) {
            throw new IllegalArgumentException("RPE_grid_positioning: Mc = " + Mc + " is out of range. Should be >= 0 and <= 3");
        }
        switch (Mc) {
            case 3: {
                ep[ep_index++] = 0;
                do {
                    ep[ep_index++] = 0;
                    ep[ep_index++] = 0;
                    ep[ep_index++] = xMp[xMp_index++];
                } while (--i != 0);
                break;
            }
            case 2: {
                do {
                    ep[ep_index++] = 0;
                    ep[ep_index++] = 0;
                    ep[ep_index++] = xMp[xMp_index++];
                } while (--i != 0);
                break;
            }
            case 1: {
                do {
                    ep[ep_index++] = 0;
                    ep[ep_index++] = xMp[xMp_index++];
                    ep[ep_index++] = 0;
                } while (--i != 0);
                break;
            }
            case 0: {
                do {
                    ep[ep_index++] = xMp[xMp_index++];
                    ep[ep_index++] = 0;
                    ep[ep_index++] = 0;
                } while (--i != 0);
            }
        }
        if (METHOD_ID == 0) {
            ep[ep_index++] = 0;
        }
    }
}

