/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Add;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Gsm_State;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Long_term;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Lpc;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Rpe;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.gsm.Short_term;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Encoder {
    private Gsm_State g_s = new Gsm_State();
    private Long_term lg_term_Obj = new Long_term();
    private Lpc lpc_Obj = new Lpc();
    private Rpe rpe_Obj = new Rpe();
    private Short_term sh_term_Obj = new Short_term();
    private short[] LARc = new short[8];
    private short[] Nc = new short[4];
    private short[] Mc = new short[4];
    private short[] bc = new short[4];
    private short[] xmaxc = new short[4];
    private short[] xmc = new short[52];
    private int[] input_signal = new int[160];
    private byte[] frame = new byte[33];
    private static final int[] u2s = new int[]{33280, 34308, 35336, 36364, 37393, 38421, 39449, 40477, 41505, 42534, 43562, 44590, 45618, 46647, 47675, 48703, 49474, 49988, 50503, 51017, 51531, 52045, 52559, 53073, 53587, 54101, 54616, 55130, 55644, 56158, 56672, 57186, 57572, 57829, 58086, 58343, 58600, 58857, 59114, 59371, 59628, 59885, 60142, 60399, 60656, 60913, 61171, 61428, 61620, 61749, 61877, 62006, 62134, 62263, 62392, 62520, 62649, 62777, 62906, 63034, 63163, 63291, 63420, 63548, 63645, 63709, 63773, 63838, 63902, 63966, 64030, 64095, 64159, 64223, 64287, 64352, 64416, 64480, 64544, 64609, 64657, 64689, 64721, 64753, 64785, 64818, 64850, 64882, 64914, 64946, 64978, 65010, 65042, 65075, 65107, 65139, 65163, 65179, 65195, 65211, 65227, 65243, 65259, 65275, 65291, 65308, 65324, 65340, 65356, 65372, 65388, 65404, 65416, 65424, 65432, 65440, 65448, 65456, 65464, 65472, 65480, 65488, 65496, 65504, 65512, 65520, 65528, 0, 32256, 31228, 30200, 29172, 28143, 27115, 26087, 25059, 24031, 23002, 21974, 20946, 19918, 18889, 17861, 16833, 16062, 15548, 15033, 14519, 14005, 13491, 12977, 12463, 11949, 11435, 10920, 10406, 9892, 9378, 8864, 8350, 7964, 7707, 7450, 7193, 6936, 6679, 6422, 6165, 5908, 5651, 5394, 5137, 4880, 4623, 4365, 4108, 3916, 3787, 3659, 3530, 3402, 3273, 3144, 3016, 2887, 2759, 2630, 2502, 2373, 2245, 2116, 1988, 1891, 1827, 1763, 1698, 1634, 1570, 1506, 1441, 1377, 1313, 1249, 1184, 1120, 1056, 992, 927, 879, 847, 815, 783, 751, 718, 686, 654, 622, 590, 558, 526, 494, 461, 429, 397, 373, 357, 341, 325, 309, 293, 277, 261, 245, 228, 212, 196, 180, 164, 148, 132, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0};

    public static void stripAUHeader(InputStream in) throws Exception {
        DataInputStream input = new DataInputStream(in);
        int magic = input.readInt();
        input.readInt();
        input.readInt();
        int dataFormat = input.readInt();
        int sampleRate = input.readInt();
        input.readInt();
        input.readChar();
        input.readChar();
        input.readChar();
        input.readChar();
        if (magic != 779316836 || dataFormat != 1 || sampleRate != 8000) {
            // empty if block
        }
    }

    public void encode(String input_file, String output_file) throws Exception {
        File arg1 = new File(input_file);
        if (!(arg1.exists() && arg1.isFile() && arg1.canRead())) {
            throw new IOException("File : " + input_file + "\ndoes not exist or cannot be read.");
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            from = new FileInputStream(input_file);
            to = new FileOutputStream(output_file);
            Encoder.stripAUHeader(from);
            while (this.ulaw_input(from) > 0) {
                this.gsm_encode();
                this.ulaw_output(to);
            }
        }
        catch (Exception e) {
            throw new Exception("Encoder: " + e.getMessage());
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {
                    throw new IOException("Encoder: " + e.getMessage());
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    throw new IOException("Encoder: " + e.getMessage());
                }
            }
        }
    }

    public void encode(InputStream input, String output_file) throws IOException {
        FileOutputStream to = null;
        try {
            to = new FileOutputStream(output_file);
            while (this.ulaw_input(input) > 0) {
                this.gsm_encode();
                this.ulaw_output(to);
            }
        }
        catch (IOException e) {
            throw new IOException("Encoder: " + e.getMessage());
        }
        finally {
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    throw new IOException("Encoder: " + e.getMessage());
                }
            }
        }
    }

    public void encode(short[] asBuffer, byte[] abFrame) {
        for (int i = 0; i < 160; ++i) {
            this.input_signal[i] = asBuffer[i];
        }
        this.gsm_encode();
        System.arraycopy(this.frame, 0, abFrame, 0, this.frame.length);
    }

    private int ulaw_input(InputStream in) throws IOException {
        int c = 0;
        int i = 0;
        for (i = 0; i < this.input_signal.length && (c = in.read()) != -1; ++i) {
            if (c < 0) {
                throw new IOException("Encoder ulaw_input: Corrupt InputStream.");
            }
            this.input_signal[i] = u2s[c];
        }
        return i;
    }

    private void gsm_encode() {
        int index = 0;
        this.Gsm_Coder_java();
        this.frame[index++] = (byte)(0xD0 | this.LARc[0] >> 2 & 0xF);
        this.frame[index++] = (byte)((this.LARc[0] & 3) << 6 | this.LARc[1] & 0x3F);
        this.frame[index++] = (byte)((this.LARc[2] & 0x1F) << 3 | this.LARc[3] >> 2 & 7);
        this.frame[index++] = (byte)((this.LARc[3] & 3) << 6 | (this.LARc[4] & 0xF) << 2 | this.LARc[5] >> 2 & 3);
        this.frame[index++] = (byte)((this.LARc[5] & 3) << 6 | (this.LARc[6] & 7) << 3 | this.LARc[7] & 7);
        this.frame[index++] = (byte)((this.Nc[0] & 0x7F) << 1 | this.bc[0] >> 1 & 1);
        this.frame[index++] = (byte)((this.bc[0] & 1) << 7 | (this.Mc[0] & 3) << 5 | this.xmaxc[0] >> 1 & 0x1F);
        this.frame[index++] = (byte)((this.xmaxc[0] & 1) << 7 | (this.xmc[0] & 7) << 4 | (this.xmc[1] & 7) << 1 | this.xmc[2] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[2] & 3) << 6 | (this.xmc[3] & 7) << 3 | this.xmc[4] & 7);
        this.frame[index++] = (byte)((this.xmc[5] & 7) << 5 | (this.xmc[6] & 7) << 2 | this.xmc[7] >> 1 & 3);
        this.frame[index++] = (byte)((this.xmc[7] & 1) << 7 | (this.xmc[8] & 7) << 4 | (this.xmc[9] & 7) << 1 | this.xmc[10] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[10] & 3) << 6 | (this.xmc[11] & 7) << 3 | this.xmc[12] & 7);
        this.frame[index++] = (byte)((this.Nc[1] & 0x7F) << 1 | this.bc[1] >> 1 & 1);
        this.frame[index++] = (byte)((this.bc[1] & 1) << 7 | (this.Mc[1] & 3) << 5 | this.xmaxc[1] >> 1 & 0x1F);
        this.frame[index++] = (byte)((this.xmaxc[1] & 1) << 7 | (this.xmc[13] & 7) << 4 | (this.xmc[14] & 7) << 1 | this.xmc[15] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[15] & 3) << 6 | (this.xmc[16] & 7) << 3 | this.xmc[17] & 7);
        this.frame[index++] = (byte)((this.xmc[18] & 7) << 5 | (this.xmc[19] & 7) << 2 | this.xmc[20] >> 1 & 3);
        this.frame[index++] = (byte)((this.xmc[20] & 1) << 7 | (this.xmc[21] & 7) << 4 | (this.xmc[22] & 7) << 1 | this.xmc[23] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[23] & 3) << 6 | (this.xmc[24] & 7) << 3 | this.xmc[25] & 7);
        this.frame[index++] = (byte)((this.Nc[2] & 0x7F) << 1 | this.bc[2] >> 1 & 1);
        this.frame[index++] = (byte)((this.bc[2] & 1) << 7 | (this.Mc[2] & 3) << 5 | this.xmaxc[2] >> 1 & 0x1F);
        this.frame[index++] = (byte)((this.xmaxc[2] & 1) << 7 | (this.xmc[26] & 7) << 4 | (this.xmc[27] & 7) << 1 | this.xmc[28] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[28] & 3) << 6 | (this.xmc[29] & 7) << 3 | this.xmc[30] & 7);
        this.frame[index++] = (byte)((this.xmc[31] & 7) << 5 | (this.xmc[32] & 7) << 2 | this.xmc[33] >> 1 & 3);
        this.frame[index++] = (byte)((this.xmc[33] & 1) << 7 | (this.xmc[34] & 7) << 4 | (this.xmc[35] & 7) << 1 | this.xmc[36] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[36] & 3) << 6 | (this.xmc[37] & 7) << 3 | this.xmc[38] & 7);
        this.frame[index++] = (byte)((this.Nc[3] & 0x7F) << 1 | this.bc[3] >> 1 & 1);
        this.frame[index++] = (byte)((this.bc[3] & 1) << 7 | (this.Mc[3] & 3) << 5 | this.xmaxc[3] >> 1 & 0x1F);
        this.frame[index++] = (byte)((this.xmaxc[3] & 1) << 7 | (this.xmc[39] & 7) << 4 | (this.xmc[40] & 7) << 1 | this.xmc[41] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[41] & 3) << 6 | (this.xmc[42] & 7) << 3 | this.xmc[43] & 7);
        this.frame[index++] = (byte)((this.xmc[44] & 7) << 5 | (this.xmc[45] & 7) << 2 | this.xmc[46] >> 1 & 3);
        this.frame[index++] = (byte)((this.xmc[46] & 1) << 7 | (this.xmc[47] & 7) << 4 | (this.xmc[48] & 7) << 1 | this.xmc[49] >> 2 & 1);
        this.frame[index++] = (byte)((this.xmc[49] & 3) << 6 | (this.xmc[50] & 7) << 3 | this.xmc[51] & 7);
    }

    private void Gsm_Coder_java() {
        short[] dp;
        int xmc_point = 0;
        int Nc_bc_index = 0;
        int xmaxc_Mc_index = 0;
        int dp_dpp_point_dp0 = 120;
        short[] e = new short[50];
        short[] so = new short[160];
        this.Gsm_Preprocess(so);
        this.lpc_Obj.Gsm_LPC_Analysis(so, this.LARc);
        this.sh_term_Obj.Gsm_Short_Term_Analysis_Filter(this.g_s, this.LARc, so);
        short[] dpp = dp = this.g_s.getDp0();
        int k = 0;
        while (k <= 3) {
            this.lg_term_Obj.Gsm_Long_Term_Predictor(so, k * 40, e, dp, dpp, dp_dpp_point_dp0, this.Nc, this.bc, Nc_bc_index++);
            this.rpe_Obj.Gsm_RPE_Encoding(e, this.xmaxc, this.Mc, xmaxc_Mc_index++, this.xmc, xmc_point);
            for (int i = 0; i <= 39; ++i) {
                dp[i + dp_dpp_point_dp0] = Add.GSM_ADD(e[5 + i], dpp[i + dp_dpp_point_dp0]);
            }
            this.g_s.setDp0(dp);
            dp_dpp_point_dp0 += 40;
            ++k;
            xmc_point += 13;
        }
        for (int i = 0; i < 120; ++i) {
            this.g_s.setDp0Indexed(i, this.g_s.getDp0Indexed(160 + i));
        }
    }

    private void Gsm_Preprocess(short[] so) throws IllegalArgumentException {
        int index = 0;
        int so_index = 0;
        short z1 = this.g_s.getZ1();
        int L_z2 = this.g_s.getL_z2();
        int mp = this.g_s.getMp();
        int s1 = 0;
        short msp = 0;
        short lsp = 0;
        short SO = 0;
        int L_s2 = 0;
        int L_temp = 0;
        int k = 160;
        while (k != 0) {
            --k;
            if ((SO = (short)(Add.SASR((short)this.input_signal[index++], 3) << 2)) < -16384) {
                throw new IllegalArgumentException("Gsm_Preprocess: SO = " + SO + " is out of range. Sould be >= -0x4000 ");
            }
            if (SO > 16380) {
                throw new IllegalArgumentException("Gsm_Preprocess: SO = " + SO + " is out of range. Sould be <= 0x3FFC ");
            }
            s1 = SO - z1;
            z1 = SO;
            if (s1 == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Gsm_Preprocess: s1 = " + s1 + " is out of range. ");
            }
            L_s2 = s1;
            L_s2 <<= 15;
            msp = Add.SASR(L_z2, 15);
            lsp = (short)(L_z2 - (msp << 15));
            L_temp = msp * 32735;
            L_z2 = Add.GSM_L_ADD(L_temp, L_s2 += Add.GSM_MULT_R(lsp, (short)32735));
            L_temp = Add.GSM_L_ADD(L_z2, 16384);
            msp = Add.GSM_MULT_R((short)mp, (short)-28180);
            mp = Add.SASR(L_temp, 15);
            so[so_index++] = Add.GSM_ADD((short)mp, msp);
        }
        this.g_s.setZ1(z1);
        this.g_s.setL_z2(L_z2);
        this.g_s.setMp(mp);
    }

    private void ulaw_output(FileOutputStream out) throws IOException {
        int i = 0;
        for (i = 0; i < this.frame.length; ++i) {
            out.write(this.frame[i]);
        }
    }

    private void dump_Gsm_State(Gsm_State state) {
        state.dump_Gsm_State();
    }
}

