/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.dsp;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.dsp.Complex;

public class Util {
    public static double I0(double x) {
        double eps = 1.0E-8;
        int n = 1;
        double S = 1.0;
        double D = 1.0;
        while (D > eps * S) {
            double T = x / (2.0 * (double)n);
            ++n;
            S += (D *= T * T);
        }
        return S;
    }

    public static Complex[] IDFT(Complex[] aFrequencyDomain) {
        int N = aFrequencyDomain.length;
        Complex[] aTimeDomain = new Complex[N];
        double dOneOverN = 1.0 / (double)N;
        for (int n = 0; n < N; ++n) {
            aTimeDomain[n] = new Complex(0.0, 0.0);
            for (int k = 0; k < N; ++k) {
                Complex exponent = new Complex(0.0, Math.PI * 2 * (double)k * (double)n * dOneOverN);
                Complex term = Complex.times(aFrequencyDomain[k], Complex.exp(exponent));
                aTimeDomain[n] = Complex.plus(aTimeDomain[n], term);
            }
            aTimeDomain[n] = Complex.times(aTimeDomain[n], dOneOverN);
        }
        return aTimeDomain;
    }

    public static double[] multiply(double[] ad1, double[] ad2) {
        int nLength = Math.min(ad1.length, ad2.length);
        double[] adResult = new double[nLength];
        for (int i = 0; i < nLength; ++i) {
            adResult[i] = ad1[i] * ad2[i];
        }
        return adResult;
    }

    public static double omega2relative(double dOmega) {
        double dRelative = dOmega / (Math.PI * 2);
        return dRelative;
    }

    public static double relative2omega(double dRelative) {
        double dOmega = dRelative * 2.0 * Math.PI;
        return dOmega;
    }

    public static double omega2absolute(double dOmega, double dSampleRate) {
        double dAbsolute = Util.omega2relative(dOmega) * dSampleRate;
        return dAbsolute;
    }

    public static double absolute2omega(double dAbsolute, double dSampleRate) {
        double dOmega = Util.relative2omega(dAbsolute / dSampleRate);
        return dOmega;
    }

    public static float[] quantizeToFloat(double[] adConstants) {
        float[] afConstants = new float[adConstants.length];
        for (int i = 0; i < adConstants.length; ++i) {
            afConstants[i] = (float)adConstants[i];
        }
        return afConstants;
    }
}

