/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.dsp;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.dsp.Sfun;
import java.io.Serializable;

public class Complex
implements Serializable,
Cloneable {
    private double m_re;
    private double m_im;
    static final long serialVersionUID = -633126172485117692L;
    public static String suffix = "i";
    private static final long negZeroBits = Double.doubleToLongBits(-0.0);

    public Complex(Complex z) {
        this.m_re = z.m_re;
        this.m_im = z.m_im;
    }

    public Complex(double re, double im) {
        this.m_re = re;
        this.m_im = im;
    }

    public Complex(double re) {
        this.m_re = re;
        this.m_im = 0.0;
    }

    public Complex() {
        this.m_re = 0.0;
        this.m_im = 0.0;
    }

    private boolean isNaN() {
        return Double.isNaN(this.m_re) || Double.isNaN(this.m_im);
    }

    public boolean equals(Complex z) {
        if (this.isNaN() && z.isNaN()) {
            return true;
        }
        return this.m_re == z.m_re && this.m_im == z.m_im;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Complex) {
            return this.equals((Complex)obj);
        }
        return false;
    }

    public int hashCode() {
        long re_bits = Double.doubleToLongBits(this.m_re);
        long im_bits = Double.doubleToLongBits(this.m_im);
        return (int)(re_bits ^ im_bits ^ (re_bits ^ im_bits) >> 32);
    }

    public double real() {
        return this.m_re;
    }

    public double imag() {
        return this.m_im;
    }

    public static double real(Complex z) {
        return z.m_re;
    }

    public static double imag(Complex z) {
        return z.m_im;
    }

    public static Complex negative(Complex z) {
        return new Complex(-z.m_re, -z.m_im);
    }

    public static Complex conjugate(Complex z) {
        return new Complex(z.m_re, -z.m_im);
    }

    public static Complex plus(Complex x, Complex y) {
        return new Complex(x.m_re + y.m_re, x.m_im + y.m_im);
    }

    public static Complex plus(Complex x, double y) {
        return new Complex(x.m_re + y, x.m_im);
    }

    public static Complex plus(double x, Complex y) {
        return new Complex(x + y.m_re, y.m_im);
    }

    public Complex plus(Complex y) {
        return new Complex(this.m_re + y.m_re, this.m_im + y.m_im);
    }

    public Complex plus(double y) {
        return new Complex(this.m_re + y, this.m_im);
    }

    public Complex plusReverse(double x) {
        return new Complex(this.m_re + x, this.m_im);
    }

    public static Complex minus(Complex x, Complex y) {
        return new Complex(x.m_re - y.m_re, x.m_im - y.m_im);
    }

    public static Complex minus(Complex x, double y) {
        return new Complex(x.m_re - y, x.m_im);
    }

    public static Complex minus(double x, Complex y) {
        return new Complex(x - y.m_re, -y.m_im);
    }

    public Complex minus(Complex y) {
        return new Complex(this.m_re - y.m_re, this.m_im - y.m_im);
    }

    public Complex minus(double y) {
        return new Complex(this.m_re - y, this.m_im);
    }

    public Complex minusReverse(double x) {
        return new Complex(x - this.m_re, -this.m_im);
    }

    public static Complex times(Complex x, Complex y) {
        Complex t = new Complex(x.m_re * y.m_re - x.m_im * y.m_im, x.m_re * y.m_im + x.m_im * y.m_re);
        if (Double.isNaN(t.m_re) && Double.isNaN(t.m_im)) {
            Complex.timesNaN(x, y, t);
        }
        return t;
    }

    private static double copysign(double a, double b) {
        double abs = Math.abs(a);
        return b < 0.0 ? -abs : abs;
    }

    private static void timesNaN(Complex x, Complex y, Complex t) {
        boolean recalc = false;
        double a = x.m_re;
        double b = x.m_im;
        double c = y.m_re;
        double d = y.m_im;
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            a = Complex.copysign(Double.isInfinite(a) ? 1.0 : 0.0, a);
            b = Complex.copysign(Double.isInfinite(b) ? 1.0 : 0.0, b);
            if (Double.isNaN(c)) {
                c = Complex.copysign(0.0, c);
            }
            if (Double.isNaN(d)) {
                d = Complex.copysign(0.0, d);
            }
            recalc = true;
        }
        if (Double.isInfinite(c) || Double.isInfinite(d)) {
            a = Complex.copysign(Double.isInfinite(c) ? 1.0 : 0.0, c);
            b = Complex.copysign(Double.isInfinite(d) ? 1.0 : 0.0, d);
            if (Double.isNaN(a)) {
                a = Complex.copysign(0.0, a);
            }
            if (Double.isNaN(b)) {
                b = Complex.copysign(0.0, b);
            }
            recalc = true;
        }
        if (!recalc && (Double.isInfinite(a * c) || Double.isInfinite(b * d) || Double.isInfinite(a * d) || Double.isInfinite(b * c))) {
            if (Double.isNaN(a)) {
                a = Complex.copysign(0.0, a);
            }
            if (Double.isNaN(b)) {
                b = Complex.copysign(0.0, b);
            }
            if (Double.isNaN(c)) {
                c = Complex.copysign(0.0, c);
            }
            if (Double.isNaN(d)) {
                d = Complex.copysign(0.0, d);
            }
            recalc = true;
        }
        if (recalc) {
            t.m_re = Double.POSITIVE_INFINITY * (a * c - b * d);
            t.m_im = Double.POSITIVE_INFINITY * (a * d + b * c);
        }
    }

    public static Complex times(Complex x, double y) {
        return new Complex(x.m_re * y, x.m_im * y);
    }

    public static Complex times(double x, Complex y) {
        return new Complex(x * y.m_re, x * y.m_im);
    }

    public Complex times(Complex y) {
        return Complex.times(this, y);
    }

    public Complex times(double y) {
        return new Complex(this.m_re * y, this.m_im * y);
    }

    public Complex timesReverse(double x) {
        return new Complex(x * this.m_re, x * this.m_im);
    }

    private static boolean isFinite(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static Complex over(Complex x, Complex y) {
        double a = x.m_re;
        double b = x.m_im;
        double c = y.m_re;
        double d = y.m_im;
        double scale = Math.max(Math.abs(c), Math.abs(d));
        boolean isScaleFinite = Complex.isFinite(scale);
        if (isScaleFinite) {
            c /= scale;
            d /= scale;
        }
        double den = c * c + d * d;
        Complex z = new Complex((a * c + b * d) / den, (b * c - a * d) / den);
        if (isScaleFinite) {
            z.m_re /= scale;
            z.m_im /= scale;
        }
        if (Double.isNaN(z.m_re) && Double.isNaN(z.m_im)) {
            if (!(den != 0.0 || Double.isNaN(a) && Double.isNaN(b))) {
                double s = Complex.copysign(Double.POSITIVE_INFINITY, c);
                z.m_re = s * a;
                z.m_im = s * b;
            } else if ((Double.isInfinite(a) || Double.isInfinite(b)) && Complex.isFinite(c) && Complex.isFinite(d)) {
                a = Complex.copysign(Double.isInfinite(a) ? 1.0 : 0.0, a);
                b = Complex.copysign(Double.isInfinite(b) ? 1.0 : 0.0, b);
                z.m_re = Double.POSITIVE_INFINITY * (a * c + b * d);
                z.m_im = Double.POSITIVE_INFINITY * (b * c - a * d);
            } else if (Double.isInfinite(scale) && Complex.isFinite(a) && Complex.isFinite(b)) {
                c = Complex.copysign(Double.isInfinite(c) ? 1.0 : 0.0, c);
                d = Complex.copysign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                z.m_re = 0.0 * (a * c + b * d);
                z.m_im = 0.0 * (b * c - a * d);
            }
        }
        return z;
    }

    public static Complex over(Complex x, double y) {
        return new Complex(x.m_re / y, x.m_im / y);
    }

    public static Complex over(double x, Complex y) {
        return y.overReverse(x);
    }

    public Complex over(Complex y) {
        return Complex.over(this, y);
    }

    public Complex over(double y) {
        return Complex.over(this, y);
    }

    public Complex overReverse(double x) {
        Complex z;
        if (Math.abs(this.m_re) > Math.abs(this.m_im)) {
            double t = this.m_im / this.m_re;
            double den = this.m_re + this.m_im * t;
            z = new Complex(x / den, -x * t / den);
        } else {
            double t = this.m_re / this.m_im;
            double den = this.m_im + this.m_re * t;
            z = new Complex(x * t / den, -x / den);
        }
        return z;
    }

    public static double abs(Complex z) {
        double x = Math.abs(z.m_re);
        double y = Math.abs(z.m_im);
        if (Double.isInfinite(x) || Double.isInfinite(y)) {
            return Double.POSITIVE_INFINITY;
        }
        if (x + y == 0.0) {
            return 0.0;
        }
        if (x > y) {
            return x * Math.sqrt(1.0 + (y /= x) * y);
        }
        return y * Math.sqrt((x /= y) * x + 1.0);
    }

    public static double argument(Complex z) {
        return Math.atan2(z.m_im, z.m_re);
    }

    public static Complex sqrt(Complex z) {
        Complex result = new Complex();
        if (Double.isInfinite(z.m_im)) {
            result.m_re = Double.POSITIVE_INFINITY;
            result.m_im = z.m_im;
        } else if (Double.isNaN(z.m_re)) {
            result.m_im = Double.NaN;
            result.m_re = Double.NaN;
        } else if (Double.isNaN(z.m_im)) {
            if (Double.isInfinite(z.m_re)) {
                if (z.m_re > 0.0) {
                    result.m_re = z.m_re;
                    result.m_im = z.m_im;
                } else {
                    result.m_re = z.m_im;
                    result.m_im = Double.POSITIVE_INFINITY;
                }
            } else {
                result.m_im = Double.NaN;
                result.m_re = Double.NaN;
            }
        } else {
            double t = Complex.abs(z);
            if (Math.abs(z.m_re) <= Math.abs(z.m_im)) {
                result.m_re = Math.sqrt(0.5 * (t + z.m_re));
                result.m_im = Math.sqrt(0.5 * (t - z.m_re));
            } else if (z.m_re > 0.0) {
                result.m_re = t + z.m_re;
                result.m_im = Math.abs(z.m_im) * Math.sqrt(0.5 / result.m_re);
                result.m_re = Math.sqrt(0.5 * result.m_re);
            } else {
                result.m_im = t - z.m_re;
                result.m_re = Math.abs(z.m_im) * Math.sqrt(0.5 / result.m_im);
                result.m_im = Math.sqrt(0.5 * result.m_im);
            }
            if (z.m_im < 0.0) {
                result.m_im = -result.m_im;
            }
        }
        return result;
    }

    public static Complex exp(Complex z) {
        Complex result = new Complex();
        double r = Math.exp(z.m_re);
        double cosa = Math.cos(z.m_im);
        double sina = Math.sin(z.m_im);
        if (Double.isInfinite(z.m_im) || Double.isNaN(z.m_im) || Math.abs(cosa) > 1.0) {
            sina = Double.NaN;
            cosa = Double.NaN;
        }
        if (Double.isInfinite(z.m_re) || Double.isInfinite(r)) {
            if (z.m_re < 0.0) {
                r = 0.0;
                if (Double.isInfinite(z.m_im) || Double.isNaN(z.m_im)) {
                    sina = 0.0;
                    cosa = 0.0;
                } else {
                    cosa /= Double.POSITIVE_INFINITY;
                    sina /= Double.POSITIVE_INFINITY;
                }
            } else {
                r = z.m_re;
                if (Double.isNaN(z.m_im)) {
                    cosa = 1.0;
                }
            }
        }
        if (z.m_im == 0.0) {
            result.m_re = r;
            result.m_im = z.m_im;
        } else {
            result.m_re = r * cosa;
            result.m_im = r * sina;
        }
        return result;
    }

    public static Complex log(Complex z) {
        Complex result = new Complex();
        if (Double.isNaN(z.m_re)) {
            result.m_re = result.m_im = z.m_re;
            if (Double.isInfinite(z.m_im)) {
                result.m_re = Double.POSITIVE_INFINITY;
            }
        } else if (Double.isNaN(z.m_im)) {
            result.m_re = result.m_im = z.m_im;
            if (Double.isInfinite(z.m_re)) {
                result.m_re = Double.POSITIVE_INFINITY;
            }
        } else {
            result.m_re = Math.log(Complex.abs(z));
            result.m_im = Complex.argument(z);
        }
        return result;
    }

    public static Complex sin(Complex z) {
        Complex iz = new Complex(-z.m_im, z.m_re);
        Complex s = Complex.sinh(iz);
        double re = s.m_im;
        s.m_im = -s.m_re;
        s.m_re = re;
        return s;
    }

    public static Complex cos(Complex z) {
        return Complex.cosh(new Complex(-z.m_im, z.m_re));
    }

    public static Complex tan(Complex z) {
        Complex iz = new Complex(-z.m_im, z.m_re);
        Complex s = Complex.tanh(iz);
        double re = s.m_im;
        s.m_im = -s.m_re;
        s.m_re = re;
        return s;
    }

    public static Complex asin(Complex z) {
        Complex result = new Complex();
        double r = Complex.abs(z);
        if (Double.isInfinite(r)) {
            boolean infiniteX = Double.isInfinite(z.m_re);
            boolean infiniteY = Double.isInfinite(z.m_im);
            if (infiniteX) {
                double pi2 = 1.5707963267948966;
                double d = result.m_re = z.m_re > 0.0 ? pi2 : -pi2;
                if (infiniteY) {
                    result.m_re /= 2.0;
                }
            } else if (infiniteY) {
                result.m_re = z.m_re / Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(z.m_im)) {
                result.m_im = -z.m_re;
                result.m_re = z.m_im;
            } else {
                result.m_im = z.m_im * Double.POSITIVE_INFINITY;
            }
            return result;
        }
        if (Double.isNaN(r)) {
            result.m_im = Double.NaN;
            result.m_re = Double.NaN;
            if (z.m_re == 0.0) {
                result.m_re = z.m_re;
            }
        } else if (r < 2.58095E-8) {
            result.m_re = z.m_re;
            result.m_im = z.m_im;
        } else if (z.m_re == 0.0) {
            result.m_re = 0.0;
            result.m_im = Sfun.asinh(z.m_im);
        } else if (r <= 0.1) {
            Complex z2 = Complex.times(z, z);
            for (int i = 1; i <= 8; ++i) {
                double twoi = 2 * (8 - i) + 1;
                result = Complex.times(Complex.times(result, z2), twoi / (twoi + 1.0));
                result.m_re += 1.0 / twoi;
            }
            result = result.times(z);
        } else {
            Complex w = z.m_im < 0.0 ? Complex.negative(z) : z;
            Complex sqzp1 = Complex.sqrt(Complex.plus(w, 1.0));
            if (sqzp1.m_im < 0.0) {
                sqzp1 = Complex.negative(sqzp1);
            }
            Complex sqzm1 = Complex.sqrt(Complex.minus(w, 1.0));
            result = Complex.log(Complex.plus(w, Complex.times(sqzp1, sqzm1)));
            double rx = result.m_re;
            result.m_re = 1.5707963267948966 + result.m_im;
            result.m_im = -rx;
        }
        if (result.m_re > 1.5707963267948966) {
            result.m_re = Math.PI - result.m_re;
            result.m_im = -result.m_im;
        }
        if (result.m_re < -1.5707963267948966) {
            result.m_re = -Math.PI - result.m_re;
            result.m_im = -result.m_im;
        }
        if (z.m_im < 0.0) {
            result.m_re = -result.m_re;
            result.m_im = -result.m_im;
        }
        return result;
    }

    public static Complex acos(Complex z) {
        Complex result = new Complex();
        double r = Complex.abs(z);
        if (Double.isInfinite(z.m_re) && Double.isNaN(z.m_im)) {
            result.m_re = Double.NaN;
            result.m_im = Double.NEGATIVE_INFINITY;
        } else if (Double.isInfinite(r)) {
            result.m_re = Math.atan2(Math.abs(z.m_im), z.m_re);
            result.m_im = z.m_im * Double.NEGATIVE_INFINITY;
        } else if (r == 0.0) {
            result.m_re = 1.5707963267948966;
            result.m_im = -z.m_im;
        } else {
            result = Complex.minus(1.5707963267948966, Complex.asin(z));
        }
        return result;
    }

    public static Complex atan(Complex z) {
        Complex result = new Complex();
        double r = Complex.abs(z);
        if (Double.isInfinite(r)) {
            double pi2 = 1.5707963267948966;
            double im = Double.isNaN(z.m_im) ? 0.0 : z.m_im;
            result.m_re = z.m_re < 0.0 ? -pi2 : pi2;
            result.m_im = (double)(im < 0.0 ? -1 : 1) / Double.POSITIVE_INFINITY;
            if (Double.isNaN(z.m_re)) {
                result.m_re = z.m_re;
            }
        } else if (Double.isNaN(r)) {
            result.m_im = Double.NaN;
            result.m_re = Double.NaN;
            if (z.m_im == 0.0) {
                result.m_im = z.m_im;
            }
        } else if (r < 1.82501E-8) {
            result.m_re = z.m_re;
            result.m_im = z.m_im;
        } else if (r < 0.1) {
            Complex z2 = Complex.times(z, z);
            for (int k = 0; k < 17; ++k) {
                Complex temp = Complex.times(z2, result);
                int twoi = 2 * (17 - k) - 1;
                result.m_re = 1.0 / (double)twoi - temp.m_re;
                result.m_im = -temp.m_im;
            }
            result = result.times(z);
        } else if (r < 9.0072E15) {
            double r2 = r * r;
            result.m_re = 0.5 * Math.atan2(2.0 * z.m_re, 1.0 - r2);
            result.m_im = 0.25 * Math.log((r2 + 2.0 * z.m_im + 1.0) / (r2 - 2.0 * z.m_im + 1.0));
        } else {
            result.m_re = z.m_re < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return result;
    }

    public static Complex sinh(Complex z) {
        Complex result;
        double coshx = Sfun.cosh(z.m_re);
        double sinhx = Sfun.sinh(z.m_re);
        double cosy = Math.cos(z.m_im);
        double siny = Math.sin(z.m_im);
        boolean infiniteX = Double.isInfinite(coshx);
        boolean infiniteY = Double.isInfinite(z.m_im);
        if (z.m_im == 0.0) {
            result = new Complex(Sfun.sinh(z.m_re));
        } else {
            result = new Complex(sinhx * cosy, coshx * siny);
            if (infiniteY) {
                result.m_im = Double.NaN;
                if (z.m_re == 0.0) {
                    result.m_re = 0.0;
                }
            }
            if (infiniteX) {
                result.m_re = z.m_re * cosy;
                result.m_im = z.m_re * siny;
                if (z.m_im == 0.0) {
                    result.m_im = 0.0;
                }
                if (infiniteY) {
                    result.m_re = z.m_im;
                }
            }
        }
        return result;
    }

    public static Complex cosh(Complex z) {
        if (z.m_im == 0.0) {
            return new Complex(Sfun.cosh(z.m_re));
        }
        double coshx = Sfun.cosh(z.m_re);
        double sinhx = Sfun.sinh(z.m_re);
        double cosy = Math.cos(z.m_im);
        double siny = Math.sin(z.m_im);
        boolean infiniteX = Double.isInfinite(coshx);
        boolean infiniteY = Double.isInfinite(z.m_im);
        Complex result = new Complex(coshx * cosy, sinhx * siny);
        if (infiniteY) {
            result.m_re = Double.NaN;
        }
        if (z.m_re == 0.0) {
            result.m_im = 0.0;
        } else if (infiniteX) {
            result.m_re = z.m_re * cosy;
            result.m_im = z.m_re * siny;
            if (z.m_im == 0.0) {
                result.m_im = 0.0;
            }
            if (Double.isNaN(z.m_im)) {
                result.m_re = z.m_re;
            } else if (infiniteY) {
                result.m_re = z.m_im;
            }
        }
        return result;
    }

    public static Complex tanh(Complex z) {
        double sinh2x = Sfun.sinh(2.0 * z.m_re);
        if (z.m_im == 0.0) {
            return new Complex(Sfun.tanh(z.m_re));
        }
        if (sinh2x == 0.0) {
            return new Complex(0.0, Math.tan(z.m_im));
        }
        double cosh2x = Sfun.cosh(2.0 * z.m_re);
        double cos2y = Math.cos(2.0 * z.m_im);
        double sin2y = Math.sin(2.0 * z.m_im);
        boolean infiniteX = Double.isInfinite(cosh2x);
        if (Double.isInfinite(z.m_im) || Double.isNaN(z.m_im)) {
            sin2y = Double.NaN;
            cos2y = Double.NaN;
        }
        if (infiniteX) {
            return new Complex(z.m_re > 0.0 ? 1.0 : -1.0);
        }
        double den = cosh2x + cos2y;
        return new Complex(sinh2x / den, sin2y / den);
    }

    public static Complex pow(Complex z, double x) {
        double absz = Complex.abs(z);
        Complex result = new Complex();
        if (absz == 0.0) {
            result = z;
        } else {
            double a = Complex.argument(z);
            double e = Math.pow(absz, x);
            result.m_re = e * Math.cos(x * a);
            result.m_im = e * Math.sin(x * a);
        }
        return result;
    }

    public static Complex asinh(Complex z) {
        Complex miz = new Complex(z.m_im, -z.m_re);
        Complex result = Complex.asin(miz);
        double rx = result.m_im;
        result.m_im = result.m_re;
        result.m_re = -rx;
        return result;
    }

    public static Complex acosh(Complex z) {
        Complex result = Complex.acos(z);
        double rx = -result.m_im;
        result.m_im = result.m_re;
        result.m_re = rx;
        if (result.m_re < 0.0 || Complex.isNegZero(result.m_re)) {
            result.m_re = -result.m_re;
            result.m_im = -result.m_im;
        }
        return result;
    }

    private static boolean isNegZero(double x) {
        return Double.doubleToLongBits(x) == negZeroBits;
    }

    public static Complex atanh(Complex z) {
        Complex miz = new Complex(z.m_im, -z.m_re);
        Complex result = Complex.atan(miz);
        double rx = result.m_im;
        result.m_im = result.m_re;
        result.m_re = -rx;
        return result;
    }

    public static Complex pow(Complex x, Complex y) {
        return Complex.exp(Complex.times(y, Complex.log(x)));
    }

    public String toString() {
        if (this.m_im == 0.0) {
            return String.valueOf(this.m_re);
        }
        if (this.m_re == 0.0) {
            return String.valueOf(this.m_im) + suffix;
        }
        String sign = this.m_im < 0.0 ? "" : "+";
        return String.valueOf(this.m_re) + sign + String.valueOf(this.m_im) + suffix;
    }

    public static Complex valueOf(String s) throws NumberFormatException {
        String input = s.trim();
        int iBeginNumber = 0;
        Complex z = new Complex();
        int state = 0;
        int sign = 1;
        boolean haveRealPart = false;
        block7: for (int k = 0; k < input.length(); ++k) {
            char ch = input.charAt(k);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 0 || state == 1) {
                        state = 2;
                        continue block7;
                    }
                    if (state != 4) continue block7;
                    state = 5;
                    continue block7;
                }
                case '+': 
                case '-': {
                    int n = sign = ch == '+' ? 1 : -1;
                    if (state == 0) {
                        state = 1;
                        continue block7;
                    }
                    if (state == 4) {
                        state = 5;
                        continue block7;
                    }
                    if (!haveRealPart) {
                        z.m_re = Double.valueOf(input.substring(iBeginNumber, k));
                        haveRealPart = true;
                        iBeginNumber = k;
                        state = 1;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                case '.': {
                    if (state == 0 || state == 1 || state == 2) {
                        state = 3;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                case 'I': 
                case 'J': 
                case 'i': 
                case 'j': {
                    if (k + 1 != input.length()) {
                        throw new NumberFormatException(input);
                    }
                    if (state == 0 || state == 1) {
                        z.m_im = sign;
                        return z;
                    }
                    if (state == 2 || state == 3 || state == 5) {
                        z.m_im = Double.valueOf(input.substring(iBeginNumber, k));
                        return z;
                    }
                    throw new NumberFormatException(input);
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    if (state == 2 || state == 3) {
                        state = 4;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                default: {
                    throw new NumberFormatException(input);
                }
            }
        }
        if (!haveRealPart) {
            z.m_re = Double.valueOf(input);
            return z;
        }
        throw new NumberFormatException(input);
    }
}

