/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.dsp.processor;

import io.github.maki99999.biomebeats.org.tritonus.dsp.interfaces.FloatSampleProcessor;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.FloatSampleBuffer;

public class AmplitudeProcessor
implements FloatSampleProcessor {
    private static final float DEFAULT_AMPLITUDE = 1.0f;
    private float m_fAmplitude;

    public AmplitudeProcessor() {
        this.setAmplitudeLinear(1.0f);
    }

    public void setAmplitudeLinear(float fAmplitude) {
        this.m_fAmplitude = fAmplitude;
    }

    public void setAmplitudeLog(float fAmplitude) {
        float fAmplitudeLinear = (float)Math.pow(10.0, (double)fAmplitude / 20.0);
        this.setAmplitudeLinear(fAmplitudeLinear);
    }

    public void process(FloatSampleBuffer buffer) {
        for (int nChannel = 0; nChannel < buffer.getChannelCount(); ++nChannel) {
            float[] afBuffer = buffer.getChannel(nChannel);
            int nSample = 0;
            while (nSample < buffer.getSampleCount()) {
                int n = nSample++;
                afBuffer[n] = afBuffer[n] * this.m_fAmplitude;
            }
        }
    }
}

