/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.dsp.ais;

import io.github.maki99999.biomebeats.org.tritonus.share.sampled.FloatSampleBuffer;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class FloatAudioInputStream
extends TSynchronousFilteredAudioInputStream {
    private AudioFormat intermediateFloatBufferFormat;
    private FloatSampleBuffer m_floatBuffer = null;

    public FloatAudioInputStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
        super(sourceStream, new AudioFormat(targetFormat.getEncoding(), sourceStream.getFormat().getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), targetFormat.getChannels() * targetFormat.getSampleSizeInBits() / 8, sourceStream.getFormat().getFrameRate(), targetFormat.isBigEndian()));
        int floatChannels = targetFormat.getChannels();
        this.intermediateFloatBufferFormat = new AudioFormat(targetFormat.getEncoding(), sourceStream.getFormat().getSampleRate(), targetFormat.getSampleSizeInBits(), floatChannels, floatChannels * targetFormat.getSampleSizeInBits() / 8, sourceStream.getFormat().getFrameRate(), targetFormat.isBigEndian());
    }

    protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
        int sampleCount = inFrameCount * this.getOriginalStream().getFormat().getChannels();
        int byteCount = sampleCount * (this.getOriginalStream().getFormat().getSampleSizeInBits() / 8);
        if (this.m_floatBuffer == null) {
            this.m_floatBuffer = new FloatSampleBuffer();
        }
        this.m_floatBuffer.initFromByteArray(inBuffer, 0, byteCount, this.getOriginalStream().getFormat());
        this.convert(this.m_floatBuffer);
        this.m_floatBuffer.convertToByteArray(outBuffer, outByteOffset, this.intermediateFloatBufferFormat);
        return inFrameCount;
    }

    protected abstract void convert(FloatSampleBuffer var1);
}

