/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectByteBufferUtils {
    public static final Logger LOGGER = Logger.getLogger(DirectByteBufferUtils.class.getName());
    private static ReleaseStrategy releaseStrategy = DirectByteBufferUtils.decideReleaseStrategy();

    private static ReleaseStrategy decideReleaseStrategy() {
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.equals("Sun Microsystems Inc.") || javaVendor.equals("Oracle Corporation")) {
            return OpenJdkReleaseStrategy.INSTANCE;
        }
        if (javaVendor.equals("The Android Project")) {
            return AndroidReleaseStrategy.INSTANCE;
        }
        LOGGER.log(Level.WARNING, "Won't be able to release direct buffers as this JVM is unsupported: " + javaVendor);
        return UnsupportedJvmReleaseStrategy.INSTANCE;
    }

    private static Method loadMethod(String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static void release(Buffer bb) {
        if (bb == null) {
            throw new NullPointerException(ByteBuffer.class.getSimpleName() + " should not be null");
        }
        if (!bb.isDirect()) {
            throw new IllegalArgumentException(bb.getClass().getName() + " is not direct.");
        }
        releaseStrategy.release(bb);
    }

    private static final class UnsupportedJvmReleaseStrategy
    implements ReleaseStrategy {
        private static final ReleaseStrategy INSTANCE = new UnsupportedJvmReleaseStrategy();

        private UnsupportedJvmReleaseStrategy() {
        }

        @Override
        public void release(Buffer bb) {
            LOGGER.log(Level.WARNING, "Can't release direct buffer as this JVM is unsupported.");
        }
    }

    private static final class AndroidReleaseStrategy
    implements ReleaseStrategy {
        private static final ReleaseStrategy INSTANCE = new AndroidReleaseStrategy();
        private static final Method freeMethod = DirectByteBufferUtils.access$000("java.nio.DirectByteBuffer", "free");

        private AndroidReleaseStrategy() {
        }

        @Override
        public void release(Buffer bb) {
            if (freeMethod != null) {
                try {
                    freeMethod.invoke((Object)bb, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Authorisation failed to invoke release on: " + bb, e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.log(Level.WARNING, "Failed to release: " + bb, e);
                }
            } else {
                LOGGER.log(Level.WARNING, "Can't release direct buffer as free method weren't available on: " + bb);
            }
        }
    }

    private static final class OpenJdkReleaseStrategy
    implements ReleaseStrategy {
        private static final ReleaseStrategy INSTANCE = new OpenJdkReleaseStrategy();
        private static final Method cleanerMethod = DirectByteBufferUtils.access$000("sun.nio.ch.DirectBuffer", "cleaner");
        private static final Method cleanMethod = DirectByteBufferUtils.access$000("sun.misc.Cleaner", "clean");
        private static final Method viewedBufferMethod;

        private OpenJdkReleaseStrategy() {
        }

        @Override
        public void release(Buffer bb) {
            try {
                Object cleaner = cleanerMethod.invoke((Object)bb, new Object[0]);
                if (cleaner != null) {
                    cleanMethod.invoke(cleaner, new Object[0]);
                } else {
                    Object viewedBuffer = viewedBufferMethod.invoke((Object)bb, new Object[0]);
                    if (viewedBuffer != null) {
                        this.release((Buffer)viewedBuffer);
                    } else {
                        LOGGER.log(Level.WARNING, "Can't release direct buffer as neither cleaner nor viewedBuffer were available on:" + bb.getClass());
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.WARNING, "Authorisation failed to invoke release on: " + bb, e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Failed to release: " + bb, e);
            }
        }

        static {
            Method vbMethod = DirectByteBufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "viewedBuffer");
            if (vbMethod == null) {
                vbMethod = DirectByteBufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "attachment");
            }
            viewedBufferMethod = vbMethod;
        }
    }

    private static interface ReleaseStrategy {
        public void release(Buffer var1);
    }
}

