/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkSummary;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavOptions;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldDataInvalidException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.KeyNotFoundException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v23Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v24Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.Id3SupportingTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.images.Artwork;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.ID3V2Version;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavInfoTag;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavTag
implements Tag,
Id3SupportingTag {
    private static final Logger logger = Logger.getLogger(WavTag.class.getPackage().getName());
    private static final String NULL = "\u0000";
    private List<ChunkSummary> chunkSummaryList = new ArrayList<ChunkSummary>();
    private boolean isIncorrectlyAlignedTag = false;
    private boolean isExistingId3Tag = false;
    private boolean isExistingInfoTag = false;
    private WavInfoTag infoTag;
    private AbstractID3v2Tag id3Tag;
    private WavOptions wavOptions;

    public void addChunkSummary(ChunkSummary cs) {
        this.chunkSummaryList.add(cs);
    }

    public List<ChunkSummary> getChunkSummaryList() {
        return this.chunkSummaryList;
    }

    public WavTag(WavOptions wavOptions) {
        this.wavOptions = wavOptions;
    }

    public boolean isExistingId3Tag() {
        return this.isExistingId3Tag;
    }

    public boolean isExistingInfoTag() {
        return this.isExistingInfoTag;
    }

    public WavInfoTag getInfoTag() {
        return this.infoTag;
    }

    public void setInfoTag(WavInfoTag infoTag) {
        this.infoTag = infoTag;
    }

    public boolean isInfoTag() {
        return this.infoTag != null;
    }

    @Override
    public AbstractID3v2Tag getID3Tag() {
        return this.id3Tag;
    }

    @Override
    public void setID3Tag(AbstractID3v2Tag t) {
        this.id3Tag = t;
    }

    public boolean isID3Tag() {
        return this.id3Tag != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ChunkSummary cs : this.chunkSummaryList) {
            sb.append(cs.toString() + "\n");
        }
        if (this.id3Tag != null) {
            sb.append("Wav ID3 Tag:\n");
            if (this.isExistingId3Tag()) {
                sb.append("\tstartLocation:" + Hex.asDecAndHex(this.getStartLocationInFileOfId3Chunk()) + "\n");
                sb.append("\tendLocation:" + Hex.asDecAndHex(this.getEndLocationInFileOfId3Chunk()) + "\n");
            }
            sb.append(this.id3Tag.toString().replace(NULL, "") + "\n");
        }
        if (this.infoTag != null) {
            sb.append(this.infoTag.toString() + "\n");
        }
        return sb.toString();
    }

    public Tag getActiveTag() {
        switch (this.wavOptions) {
            case READ_ID3_ONLY: 
            case READ_ID3_ONLY_AND_SYNC: {
                return this.id3Tag;
            }
            case READ_INFO_ONLY: 
            case READ_INFO_ONLY_AND_SYNC: {
                return this.infoTag;
            }
            case READ_ID3_UNLESS_ONLY_INFO: 
            case READ_ID3_UNLESS_ONLY_INFO_AND_SYNC: {
                if (this.isExistingId3Tag() || !this.isExistingInfoTag()) {
                    return this.id3Tag;
                }
                return this.infoTag;
            }
            case READ_INFO_UNLESS_ONLY_ID3: 
            case READ_INFO_UNLESS_ONLY_ID3_AND_SYNC: {
                if (this.isExistingInfoTag() || !this.isExistingId3Tag()) {
                    return this.infoTag;
                }
                return this.id3Tag;
            }
        }
        return this.id3Tag;
    }

    public boolean equals(Object obj) {
        return this.getActiveTag().equals(obj);
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        this.getActiveTag().addField(field);
    }

    @Override
    public List<TagField> getFields(String id) {
        return this.getActiveTag().getFields(id);
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        return this.getActiveTag().getAll(genericKey);
    }

    @Override
    public boolean hasCommonFields() {
        return this.getActiveTag().hasCommonFields();
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveTag() == null || this.getActiveTag().isEmpty();
    }

    @Override
    public void setField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        this.getActiveTag().setField(field);
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.getActiveTag().createField(genericKey, value);
    }

    @Override
    public String getFirst(String id) {
        return this.getActiveTag().getFirst(id);
    }

    @Override
    public String getValue(FieldKey id, int index) throws KeyNotFoundException {
        return this.getActiveTag().getValue(id, index);
    }

    @Override
    public String getFirst(FieldKey id) throws KeyNotFoundException {
        return this.getValue(id, 0);
    }

    @Override
    public TagField getFirstField(String id) {
        return this.getActiveTag().getFirstField(id);
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.getActiveTag().getFirstField(genericKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        this.getActiveTag().deleteField(fieldKey);
    }

    @Override
    public void deleteField(String id) throws KeyNotFoundException {
        this.getActiveTag().deleteField(id);
    }

    @Override
    public Iterator<TagField> getFields() {
        return this.getActiveTag().getFields();
    }

    @Override
    public int getFieldCount() {
        return this.getActiveTag().getFieldCount();
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean setEncoding(Charset enc) throws FieldDataInvalidException {
        return this.getActiveTag().setEncoding(enc);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        return this.getActiveTag().createField(artwork);
    }

    @Override
    public List<TagField> getFields(FieldKey id) throws KeyNotFoundException {
        return this.getActiveTag().getFields(id);
    }

    @Override
    public Artwork getFirstArtwork() {
        return this.getActiveTag().getFirstArtwork();
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.getActiveTag().deleteArtworkField();
    }

    @Override
    public boolean hasField(FieldKey genericKey) {
        return this.getActiveTag().hasField(genericKey);
    }

    @Override
    public boolean hasField(String id) {
        return this.getActiveTag().hasField(id);
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.createField(FieldKey.IS_COMPILATION, String.valueOf(value));
    }

    @Override
    public List<Artwork> getArtworkList() {
        return this.getActiveTag().getArtworkList();
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    public void setExistingId3Tag(boolean isExistingId3Tag) {
        this.isExistingId3Tag = isExistingId3Tag;
    }

    public void setExistingInfoTag(boolean isExistingInfoTag) {
        this.isExistingInfoTag = isExistingInfoTag;
    }

    public long getSizeOfID3TagOnly() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getEndLocationInFile() - this.id3Tag.getStartLocationInFile();
    }

    public long getSizeOfID3TagIncludingChunkHeader() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.getSizeOfID3TagOnly() + 8L;
    }

    public long getStartLocationInFileOfId3Chunk() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getStartLocationInFile() - 8L;
    }

    public long getEndLocationInFileOfId3Chunk() {
        if (!this.isExistingId3Tag()) {
            return 0L;
        }
        return this.id3Tag.getEndLocationInFile();
    }

    public void syncToId3FromInfoIfEmpty() {
        try {
            for (FieldKey fieldKey : WavInfoTag.getSupportedKeys()) {
                String first;
                if (!this.id3Tag.getFirst(fieldKey).isEmpty() || (first = this.infoTag.getFirst(fieldKey)).isEmpty()) continue;
                this.id3Tag.setField(fieldKey, this.stripNullTerminator(first));
            }
        }
        catch (FieldDataInvalidException deie) {
            logger.log(Level.INFO, "Couldn't sync to ID3 because the data to sync was invalid", deie);
        }
    }

    public void syncToInfoFromId3IfEmpty() {
        try {
            for (FieldKey fieldKey : WavInfoTag.getSupportedKeys()) {
                if (!this.infoTag.getFirst(fieldKey).isEmpty() || this.id3Tag.getFirst(fieldKey).isEmpty()) continue;
                this.infoTag.setField(fieldKey, this.addNullTerminatorIfNone(this.id3Tag.getFirst(fieldKey)));
            }
        }
        catch (FieldDataInvalidException deie) {
            logger.log(Level.INFO, "Couldn't sync to INFO because the data to sync was invalid", deie);
        }
    }

    public void syncToId3FromInfoOverwrite() {
        try {
            for (FieldKey fieldKey : WavInfoTag.getSupportedKeys()) {
                if (!this.infoTag.getFirst(fieldKey).isEmpty()) {
                    this.id3Tag.setField(fieldKey, this.stripNullTerminator(this.infoTag.getFirst(fieldKey)));
                    continue;
                }
                this.id3Tag.deleteField(fieldKey);
            }
        }
        catch (FieldDataInvalidException deie) {
            logger.log(Level.INFO, "Couldn't sync to ID3 because the data to sync was invalid", deie);
        }
    }

    public void syncToInfoFromId3Overwrite() {
        try {
            for (FieldKey fieldKey : WavInfoTag.getSupportedKeys()) {
                if (!this.id3Tag.getFirst(fieldKey).isEmpty()) {
                    this.infoTag.setField(fieldKey, this.addNullTerminatorIfNone(this.id3Tag.getFirst(fieldKey)));
                    continue;
                }
                this.infoTag.deleteField(fieldKey);
            }
        }
        catch (FieldDataInvalidException deie) {
            logger.log(Level.INFO, "Couldn't sync to INFO because the data to sync was invalid", deie);
        }
    }

    private String stripNullTerminator(String value) {
        return value.endsWith(NULL) ? value.substring(0, value.length() - 1) : value;
    }

    private String addNullTerminatorIfNone(String value) {
        return value.endsWith(NULL) ? value : value + NULL;
    }

    public void syncTagsAfterRead() {
        if (this.getActiveTag() instanceof WavInfoTag) {
            this.syncToInfoFromId3IfEmpty();
        } else {
            this.syncToId3FromInfoIfEmpty();
        }
    }

    public void syncTagBeforeWrite() {
        if (this.getActiveTag() instanceof WavInfoTag) {
            this.syncToId3FromInfoOverwrite();
        } else {
            this.syncToInfoFromId3Overwrite();
        }
    }

    public boolean isIncorrectlyAlignedTag() {
        return this.isIncorrectlyAlignedTag;
    }

    public void setIncorrectlyAlignedTag(boolean isIncorrectlyAlignedTag) {
        this.isIncorrectlyAlignedTag = isIncorrectlyAlignedTag;
    }

    public static AbstractID3v2Tag createDefaultID3Tag() {
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V24) {
            return new ID3v24Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V23) {
            return new ID3v23Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V22) {
            return new ID3v22Tag();
        }
        return new ID3v23Tag();
    }
}

