/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.vorbiscomment;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AbstractTagCreator;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class VorbisCommentCreator
extends AbstractTagCreator {
    @Override
    public ByteBuffer convert(Tag tag, int padding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String vendorString = ((VorbisCommentTag)tag).getVendor();
            int vendorLength = vendorString.getBytes(StandardCharsets.UTF_8).length;
            baos.write(Utils.getSizeLEInt32(vendorLength));
            baos.write(vendorString.getBytes(StandardCharsets.UTF_8));
            int listLength = tag.getFieldCount() - 1;
            baos.write(Utils.getSizeLEInt32(listLength));
            Iterator<TagField> it = tag.getFields();
            while (it.hasNext()) {
                TagField frame = it.next();
                if (frame.getId().equals(VorbisCommentFieldKey.VENDOR.getFieldName())) continue;
                baos.write(frame.getRawContent());
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

