/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference;

import java.util.EnumSet;
import java.util.HashMap;

public enum MusicalKey {
    NOTE_A("A"),
    NOTE_B("B"),
    NOTE_C("C"),
    NOTE_D("D"),
    NOTE_E("E"),
    NOTE_F("F"),
    NOTE_G("G"),
    FLAT("b"),
    SHARP("#"),
    MINOR("m"),
    OFF_KEY("o");

    private String value;
    private static final int MAX_KEY_LENGTH = 3;
    private static final HashMap<String, MusicalKey> groundKeyMap;
    private static final HashMap<String, MusicalKey> halfKeyMap;

    private MusicalKey(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isValid(String musicalKey) {
        if (musicalKey == null || musicalKey.length() > 3 || musicalKey.length() == 0) {
            return false;
        }
        if (musicalKey.length() == 1 && musicalKey.equals(OFF_KEY.getValue())) {
            return true;
        }
        if (!groundKeyMap.containsKey(musicalKey.substring(0, 1))) {
            return false;
        }
        if (!(musicalKey.length() != 2 && musicalKey.length() != 3 || halfKeyMap.containsKey(musicalKey.substring(1, 2)))) {
            return false;
        }
        return musicalKey.length() != 3 || musicalKey.substring(2, 3).equals(MINOR.getValue());
    }

    static {
        EnumSet<MusicalKey[]> groundKey = EnumSet.of(NOTE_A, new MusicalKey[]{NOTE_B, NOTE_C, NOTE_D, NOTE_E, NOTE_F, NOTE_G});
        groundKeyMap = new HashMap(MusicalKey.values().length);
        for (MusicalKey musicalKey : groundKey) {
            groundKeyMap.put(musicalKey.getValue(), musicalKey);
        }
        EnumSet<MusicalKey> halfKey = EnumSet.of(FLAT, SHARP, MINOR);
        halfKeyMap = new HashMap(MusicalKey.values().length);
        for (MusicalKey curr : halfKey) {
            halfKeyMap.put(curr.getValue(), curr);
        }
    }
}

