/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.field;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;

public class Mp4TagTextNumberField
extends Mp4TagTextField {
    public static final int NUMBER_LENGTH = 2;
    protected List<Short> numbers;

    public Mp4TagTextNumberField(String id, String numberArray) {
        super(id, numberArray);
    }

    public Mp4TagTextNumberField(String id, ByteBuffer data) throws UnsupportedEncodingException {
        super(id, data);
    }

    @Override
    protected byte[] getDataBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Short number : this.numbers) {
            try {
                baos.write(Utils.getSizeBEInt16(number));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public void copyContent(TagField field) {
        if (field instanceof Mp4TagTextNumberField) {
            this.content = ((Mp4TagTextNumberField)field).getContent();
            this.numbers = ((Mp4TagTextNumberField)field).getNumbers();
        }
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.IMPLICIT;
    }

    @Override
    protected void build(ByteBuffer data) throws UnsupportedEncodingException {
        Mp4BoxHeader header = new Mp4BoxHeader(data);
        Mp4DataBox databox = new Mp4DataBox(header, data);
        this.dataSize = header.getDataLength();
        this.content = databox.getContent();
        this.numbers = databox.getNumbers();
    }

    public List<Short> getNumbers() {
        return this.numbers;
    }
}

