/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AbstractTagCreator;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.KeyNotFoundException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.Mp4FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.Mp4TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class Mp4TagCreator
extends AbstractTagCreator {
    @Override
    public ByteBuffer convert(Tag tag, int padding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Iterator<TagField> it = tag.getFields();
            boolean processedArtwork = false;
            while (it.hasNext()) {
                TagField frame = it.next();
                if (frame instanceof Mp4TagCoverField) {
                    if (processedArtwork) continue;
                    processedArtwork = true;
                    ByteArrayOutputStream covrDataBaos = new ByteArrayOutputStream();
                    try {
                        for (TagField artwork : tag.getFields(FieldKey.COVER_ART)) {
                            covrDataBaos.write(((Mp4TagField)artwork).getRawContentDataOnly());
                        }
                    }
                    catch (KeyNotFoundException knfe) {
                        throw new RuntimeException("Unable to find COVERART Key");
                    }
                    byte[] data = covrDataBaos.toByteArray();
                    baos.write(Utils.getSizeBEInt32(8 + data.length));
                    baos.write(Mp4FieldKey.ARTWORK.getFieldName().getBytes(StandardCharsets.ISO_8859_1));
                    baos.write(data);
                    continue;
                }
                baos.write(frame.getRawContent());
            }
            ByteArrayOutputStream ilst = new ByteArrayOutputStream();
            ilst.write(Utils.getSizeBEInt32(8 + baos.size()));
            ilst.write(Mp4AtomIdentifier.ILST.getFieldName().getBytes(StandardCharsets.ISO_8859_1));
            ilst.write(baos.toByteArray());
            ByteBuffer buf = ByteBuffer.wrap(ilst.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

