/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidTagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrame;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyAUT;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAL;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAR;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyETT;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyIMG;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyIND;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyINF;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.FieldFrameBodyUnsupported;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Lyrics3v2Field
extends AbstractTagFrame {
    public Lyrics3v2Field() {
    }

    public Lyrics3v2Field(Lyrics3v2Field copyObject) {
        super(copyObject);
    }

    public Lyrics3v2Field(AbstractLyrics3v2FieldFrameBody body) {
        this.frameBody = body;
    }

    public Lyrics3v2Field(AbstractID3v2Frame frame) throws TagException {
        String frameIdentifier = frame.getIdentifier();
        if (frameIdentifier.startsWith("USLT")) {
            this.frameBody = new FieldFrameBodyLYR("");
            ((FieldFrameBodyLYR)this.frameBody).addLyric((FrameBodyUSLT)frame.getBody());
        } else if (frameIdentifier.startsWith("SYLT")) {
            this.frameBody = new FieldFrameBodyLYR("");
            ((FieldFrameBodyLYR)this.frameBody).addLyric((FrameBodySYLT)frame.getBody());
        } else if (frameIdentifier.startsWith("COMM")) {
            String text = ((FrameBodyCOMM)frame.getBody()).getText();
            this.frameBody = new FieldFrameBodyINF(text);
        } else if (frameIdentifier.equals("TCOM")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            this.frameBody = new FieldFrameBodyAUT("");
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyAUT(textFrame.getText());
            }
        } else if (frameIdentifier.equals("TALB")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyEAL(textFrame.getText());
            }
        } else if (frameIdentifier.equals("TPE1")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyEAR(textFrame.getText());
            }
        } else if (frameIdentifier.equals("TIT2")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyETT(textFrame.getText());
            }
        } else {
            throw new TagException("Cannot createField Lyrics3v2 field from given ID3v2 frame");
        }
    }

    public Lyrics3v2Field(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    @Override
    public String getIdentifier() {
        if (this.frameBody == null) {
            return "";
        }
        return this.frameBody.getIdentifier();
    }

    @Override
    public int getSize() {
        return this.frameBody.getSize() + 5 + this.getIdentifier().length();
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte b;
        byte[] buffer = new byte[6];
        while ((b = byteBuffer.get()) == 0) {
        }
        byteBuffer.position(byteBuffer.position() - 1);
        byteBuffer.get(buffer, 0, 3);
        String identifier = new String(buffer, 0, 3);
        if (!Lyrics3v2Fields.isLyrics3v2FieldIdentifier(identifier)) {
            throw new InvalidTagException(identifier + " is not a valid ID3v2.4 frame");
        }
        this.frameBody = this.readBody(identifier, byteBuffer);
    }

    @Override
    public String toString() {
        if (this.frameBody == null) {
            return "";
        }
        return this.frameBody.toString();
    }

    public void write(RandomAccessFile file) throws IOException {
        if (this.frameBody.getSize() > 0 || TagOptionSingleton.getInstance().isLyrics3SaveEmptyField()) {
            byte[] buffer = new byte[3];
            String str = this.getIdentifier();
            for (int i = 0; i < str.length(); ++i) {
                buffer[i] = (byte)str.charAt(i);
            }
            file.write(buffer, 0, str.length());
        }
    }

    private AbstractLyrics3v2FieldFrameBody readBody(String identifier, ByteBuffer byteBuffer) throws InvalidTagException {
        AbstractLyrics3v2FieldFrameBody newBody = identifier.equals("AUT") ? new FieldFrameBodyAUT(byteBuffer) : (identifier.equals("EAL") ? new FieldFrameBodyEAL(byteBuffer) : (identifier.equals("EAR") ? new FieldFrameBodyEAR(byteBuffer) : (identifier.equals("ETT") ? new FieldFrameBodyETT(byteBuffer) : (identifier.equals("IMG") ? new FieldFrameBodyIMG(byteBuffer) : (identifier.equals("IND") ? new FieldFrameBodyIND(byteBuffer) : (identifier.equals("INF") ? new FieldFrameBodyINF(byteBuffer) : (identifier.equals("LYR") ? new FieldFrameBodyLYR(byteBuffer) : new FieldFrameBodyUnsupported(byteBuffer))))))));
        return newBody;
    }
}

