/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidTagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.ID3v2LyricLine;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.Lyrics3Line;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.Lyrics3TimeStamp;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class FieldFrameBodyLYR
extends AbstractLyrics3v2FieldFrameBody {
    private ArrayList<Lyrics3Line> lines = new ArrayList();

    public FieldFrameBodyLYR() {
    }

    public FieldFrameBodyLYR(FieldFrameBodyLYR copyObject) {
        super(copyObject);
        for (int i = 0; i < copyObject.lines.size(); ++i) {
            Lyrics3Line old = copyObject.lines.get(i);
            this.lines.add(new Lyrics3Line(old));
        }
    }

    public FieldFrameBodyLYR(String line) {
        this.readString(line);
    }

    public FieldFrameBodyLYR(FrameBodySYLT sync) {
        this.addLyric(sync);
    }

    public FieldFrameBodyLYR(FrameBodyUSLT unsync) {
        this.addLyric(unsync);
    }

    public FieldFrameBodyLYR(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    @Override
    public String getIdentifier() {
        return "LYR";
    }

    public void setLyric(String str) {
        this.readString(str);
    }

    public String getLyric() {
        return this.writeString();
    }

    @Override
    public int getSize() {
        int size = 0;
        Iterator<Lyrics3Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Lyrics3Line line1;
            Lyrics3Line line = line1 = iterator.next();
            size += line.getSize() + 2;
        }
        return size;
    }

    @Override
    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof FieldFrameBodyLYR)) {
            return false;
        }
        ArrayList<Lyrics3Line> superset = ((FieldFrameBodyLYR)obj).lines;
        for (Lyrics3Line line : this.lines) {
            if (superset.contains(line)) continue;
            return false;
        }
        return super.isSubsetOf(obj);
    }

    public void addLyric(FrameBodySYLT sync) {
        Iterator iterator = sync.iterator();
        HashMap<String, Lyrics3Line> lineMap = new HashMap<String, Lyrics3Line>();
        while (iterator.hasNext()) {
            Lyrics3Line newLine;
            ID3v2LyricLine currentLine = (ID3v2LyricLine)iterator.next();
            currentLine = new ID3v2LyricLine(currentLine);
            Lyrics3TimeStamp timeStamp = new Lyrics3TimeStamp("Time Stamp", this);
            timeStamp.setTimeStamp(currentLine.getTimeStamp(), (byte)sync.getTimeStampFormat());
            if (lineMap.containsKey(currentLine.getText())) {
                newLine = (Lyrics3Line)lineMap.get(currentLine.getText());
                newLine.addTimeStamp(timeStamp);
                continue;
            }
            newLine = new Lyrics3Line("Lyric Line", this);
            newLine.setLyric(currentLine);
            newLine.setTimeStamp(timeStamp);
            lineMap.put(currentLine.getText(), newLine);
            this.lines.add(newLine);
        }
    }

    public void addLyric(FrameBodyUSLT unsync) {
        Lyrics3Line line = new Lyrics3Line("Lyric Line", this);
        line.setLyric(unsync.getLyric());
        this.lines.add(line);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FieldFrameBodyLYR)) {
            return false;
        }
        FieldFrameBodyLYR object = (FieldFrameBodyLYR)obj;
        return this.lines.equals(object.lines) && super.equals(obj);
    }

    public boolean hasTimeStamp() {
        boolean present = false;
        for (Lyrics3Line line : this.lines) {
            if (!line.hasTimeStamp()) continue;
            present = true;
        }
        return present;
    }

    @Override
    public Iterator<Lyrics3Line> iterator() {
        return this.lines.iterator();
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte[] buffer = new byte[5];
        byteBuffer.get(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        buffer = new byte[size];
        byteBuffer.get(buffer);
        String lineString = new String(buffer);
        this.readString(lineString);
    }

    @Override
    public String toString() {
        String str = this.getIdentifier() + " : ";
        for (Lyrics3Line line : this.lines) {
            str = str + ((Object)line).toString();
        }
        return str;
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
        int i;
        int offset = 0;
        byte[] buffer = new byte[5];
        int size = this.getSize();
        String str = Integer.toString(size);
        for (i = 0; i < 5 - str.length(); ++i) {
            buffer[i] = 48;
        }
        offset += 5 - str.length();
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        file.write(buffer, 0, 5);
        if (size > 0) {
            str = this.writeString();
            buffer = new byte[str.length()];
            for (i = 0; i < str.length(); ++i) {
                buffer[i] = (byte)str.charAt(i);
            }
            file.write(buffer);
        }
    }

    private void readString(String lineString) {
        Lyrics3Line line;
        String token;
        int offset = 0;
        int delim = lineString.indexOf(Lyrics3v2Fields.CRLF);
        this.lines = new ArrayList();
        while (delim >= 0) {
            token = lineString.substring(offset, delim);
            line = new Lyrics3Line("Lyric Line", this);
            line.setLyric(token);
            this.lines.add(line);
            offset = delim + Lyrics3v2Fields.CRLF.length();
            delim = lineString.indexOf(Lyrics3v2Fields.CRLF, offset);
        }
        if (offset < lineString.length()) {
            token = lineString.substring(offset);
            line = new Lyrics3Line("Lyric Line", this);
            line.setLyric(token);
            this.lines.add(line);
        }
    }

    private String writeString() {
        String str = "";
        Iterator<Lyrics3Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Lyrics3Line line1;
            Lyrics3Line line = line1 = iterator.next();
            str = str + line.writeString() + Lyrics3v2Fields.CRLF;
        }
        return str;
    }

    @Override
    protected void setupObjectList() {
    }
}

