/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidTagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.AbstractDataType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ListIterator;

public abstract class AbstractLyrics3v2FieldFrameBody
extends AbstractTagFrameBody {
    public AbstractLyrics3v2FieldFrameBody() {
    }

    public AbstractLyrics3v2FieldFrameBody(AbstractLyrics3v2FieldFrameBody copyObject) {
        super(copyObject);
    }

    protected int readHeader(RandomAccessFile file) throws InvalidTagException, IOException {
        byte[] buffer = new byte[5];
        file.read(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        return size;
    }

    protected void writeHeader(RandomAccessFile file, int size) throws IOException {
        int i;
        int offset = 0;
        byte[] buffer = new byte[5];
        String str = Integer.toString(this.getSize());
        for (i = 0; i < 5 - str.length(); ++i) {
            buffer[i] = 48;
        }
        offset += 5 - str.length();
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        file.write(buffer);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        int size = this.getSize();
        byte[] buffer = new byte[size];
        byteBuffer.get(buffer);
        int offset = 0;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            if (offset > size - 1) {
                throw new InvalidTagException("Invalid size for Frame Body");
            }
            AbstractDataType object = (AbstractDataType)iterator.next();
            object.readByteArray(buffer, offset);
            offset += object.getSize();
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            byte[] buffer = object.writeByteArray();
            file.write(buffer);
        }
    }
}

