/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.images;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.images.Artwork;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.PictureTypes;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class AndroidArtwork
implements Artwork {
    private byte[] binaryData;
    private String mimeType = "";
    private String description = "";
    private boolean isLinked = false;
    private String imageUrl = "";
    private int pictureType = -1;
    private int width;
    private int height;

    @Override
    public byte[] getBinaryData() {
        return this.binaryData;
    }

    @Override
    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean setImageFromData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getImage() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLinked() {
        return this.isLinked;
    }

    @Override
    public void setLinked(boolean linked) {
        this.isLinked = linked;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public int getPictureType() {
        return this.pictureType;
    }

    @Override
    public void setPictureType(int pictureType) {
        this.pictureType = pictureType;
    }

    @Override
    public void setFromFile(File file) throws IOException {
        RandomAccessFile imageFile = new RandomAccessFile(file, "r");
        byte[] imagedata = new byte[(int)imageFile.length()];
        imageFile.read(imagedata);
        imageFile.close();
        this.setBinaryData(imagedata);
        this.setMimeType(ImageFormats.getMimeTypeForBinarySignature(imagedata));
        this.setDescription("");
        this.setPictureType(PictureTypes.DEFAULT_ID);
    }

    public static AndroidArtwork createArtworkFromFile(File file) throws IOException {
        AndroidArtwork artwork = new AndroidArtwork();
        artwork.setFromFile(file);
        return artwork;
    }

    public static AndroidArtwork createLinkedArtworkFromURL(String url) throws IOException {
        AndroidArtwork artwork = new AndroidArtwork();
        artwork.setLinkedFromURL(url);
        return artwork;
    }

    public void setLinkedFromURL(String url) throws IOException {
        this.setLinked(true);
        this.setImageUrl(url);
    }

    @Override
    public void setFromMetadataBlockDataPicture(MetadataBlockDataPicture coverArt) {
        this.setMimeType(coverArt.getMimeType());
        this.setDescription(coverArt.getDescription());
        this.setPictureType(coverArt.getPictureType());
        if (coverArt.isImageUrl()) {
            this.setLinked(coverArt.isImageUrl());
            this.setImageUrl(coverArt.getImageUrl());
        } else {
            this.setBinaryData(coverArt.getImageData());
        }
        this.setWidth(coverArt.getWidth());
        this.setHeight(coverArt.getHeight());
    }

    public static AndroidArtwork createArtworkFromMetadataBlockDataPicture(MetadataBlockDataPicture coverArt) {
        AndroidArtwork artwork = new AndroidArtwork();
        artwork.setFromMetadataBlockDataPicture(coverArt);
        return artwork;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }
}

