/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.MP3File;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidDataTypeException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidTagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.AbstractDataType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractID3v2FrameBody
extends AbstractTagFrameBody {
    protected static final String TYPE_BODY = "body";
    private int size;

    protected AbstractID3v2FrameBody() {
    }

    protected AbstractID3v2FrameBody(AbstractID3v2FrameBody copyObject) {
        super(copyObject);
    }

    protected AbstractID3v2FrameBody(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        this.setSize(frameSize);
        this.read(byteBuffer);
    }

    @Override
    public abstract String getIdentifier();

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSize() {
        this.size = 0;
        for (AbstractDataType object : this.objectList) {
            this.size += object.getSize();
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AbstractID3v2FrameBody && super.equals(obj);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        int size = this.getSize();
        logger.config("Reading body for" + this.getIdentifier() + ":" + size);
        byte[] buffer = new byte[size];
        byteBuffer.get(buffer);
        int offset = 0;
        for (AbstractDataType object : this.objectList) {
            logger.finest("offset:" + offset);
            if (offset > size) {
                logger.warning("Invalid Size for FrameBody");
                throw new InvalidFrameException("Invalid size for Frame Body");
            }
            try {
                object.readByteArray(buffer, offset);
            }
            catch (InvalidDataTypeException e) {
                logger.warning("Problem reading datatype within Frame Body:" + e.getMessage());
                throw e;
            }
            offset += object.getSize();
        }
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        logger.config("Writing frame body for" + this.getIdentifier() + ":Est Size:" + this.size);
        for (AbstractDataType object : this.objectList) {
            byte[] objectData = object.writeByteArray();
            if (objectData == null) continue;
            try {
                tagBuffer.write(objectData);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        this.setSize();
        logger.config("Written frame body for" + this.getIdentifier() + ":Real Size:" + this.size);
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_BODY, "");
        for (AbstractDataType nextObject : this.objectList) {
            nextObject.createStructure();
        }
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_BODY);
    }
}

