/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidTagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.NumberHashMap;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.Pair;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public abstract class AbstractFrameBodyPairs
extends AbstractID3v2FrameBody
implements ID3v24FrameBody {
    public AbstractFrameBodyPairs() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public AbstractFrameBodyPairs(byte textEncoding, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setText(text);
    }

    public AbstractFrameBodyPairs(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    @Override
    public abstract String getIdentifier();

    public void setText(String text) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = new PairedTextEncodedStringNullTerminated.ValuePairs();
        StringTokenizer stz = new StringTokenizer(text, "\u0000");
        while (stz.hasMoreTokens()) {
            String key = stz.nextToken();
            if (!stz.hasMoreTokens()) continue;
            value.add(key, stz.nextToken());
        }
        this.setObjectValue("Text", value);
    }

    public void addPair(String text) {
        StringTokenizer stz = new StringTokenizer(text, "\u0000");
        if (stz.countTokens() == 2) {
            this.addPair(stz.nextToken(), stz.nextToken());
        } else {
            this.addPair("", text);
        }
    }

    public void addPair(String function, String name) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        value.add(function, name);
    }

    public void resetPairs() {
        PairedTextEncodedStringNullTerminated.ValuePairs value = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        value.getMapping().clear();
    }

    @Override
    public void write(ByteArrayOutputStream tagBuffer) {
        if (!((PairedTextEncodedStringNullTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(tagBuffer);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PairedTextEncodedStringNullTerminated("Text", this));
    }

    public PairedTextEncodedStringNullTerminated.ValuePairs getPairing() {
        return (PairedTextEncodedStringNullTerminated.ValuePairs)this.getObject("Text").getValue();
    }

    public String getKeyAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getMapping().get(index).getKey();
    }

    public String getValueAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getMapping().get(index).getValue();
    }

    public int getNumberOfPairs() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getNumberOfPairs();
    }

    public String getText() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (Pair entry : text.getValue().getMapping()) {
            sb.append(entry.getKey() + '\u0000' + entry.getValue());
            if (count != this.getNumberOfPairs()) {
                sb.append('\u0000');
            }
            ++count;
        }
        return sb.toString();
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getText();
    }
}

