/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.MP3File;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.EmptyFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldDataInvalidException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidDataTypeException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidFrameIdentifierException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.KeyNotFoundException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.PaddingException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagNotFoundException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3Frames;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3Unsynchronization;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22Frame;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22Frames;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22PreferredFrameOrderComparator;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v23Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v24Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.images.Artwork;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.images.ArtworkFactory;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.PictureTypes;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;

public class ID3v22Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_COMPRESSION = "compression";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    public static final int MASK_V22_UNSYNCHRONIZATION = 128;
    public static final int MASK_V22_COMPRESSION = 64;
    protected boolean compression = false;
    protected boolean unsynchronization = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 2;
    public static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 2;
    }

    @Override
    public byte getMajorVersion() {
        return 2;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v22Tag() {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
    }

    @Override
    protected void copyPrimitives(AbstractID3v2Tag copyObj) {
        logger.config("Copying primitives");
        super.copyPrimitives(copyObj);
        if (copyObj instanceof ID3v22Tag) {
            ID3v22Tag copyObject = (ID3v22Tag)copyObj;
            this.compression = copyObject.compression;
            this.unsynchronization = copyObject.unsynchronization;
        } else if (copyObj instanceof ID3v23Tag) {
            ID3v23Tag copyObject = (ID3v23Tag)copyObj;
            this.compression = copyObject.compression;
            this.unsynchronization = copyObject.unsynchronization;
        } else if (copyObj instanceof ID3v24Tag) {
            ID3v24Tag copyObject = (ID3v24Tag)copyObj;
            this.compression = false;
            this.unsynchronization = copyObject.unsynchronization;
        }
    }

    public ID3v22Tag(ID3v22Tag copyObject) {
        super(copyObject);
        logger.config("Creating tag from another tag of same type");
        this.copyPrimitives(copyObject);
        this.copyFrames(copyObject);
    }

    public ID3v22Tag(AbstractTag mp3tag) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        logger.config("Creating tag from a tag of a different version");
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v23Tag) && mp3tag instanceof ID3v22Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag convertedTag = mp3tag instanceof ID3v24Tag ? (ID3v24Tag)mp3tag : new ID3v24Tag(mp3tag);
            this.setLoggingFilename(convertedTag.getLoggingFilename());
            this.copyPrimitives(convertedTag);
            this.copyFrames(convertedTag);
            logger.config("Created tag from a tag of a different version");
        }
    }

    public ID3v22Tag(ByteBuffer buffer, String loggingFilename) throws TagException {
        this.setLoggingFilename(loggingFilename);
        this.read(buffer);
    }

    public ID3v22Tag(ByteBuffer buffer) throws TagException {
        this(buffer, "");
    }

    @Override
    public String getIdentifier() {
        return "ID3v2_2.20";
    }

    @Override
    public int getSize() {
        int size = 10;
        return size += super.getSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v22Tag)) {
            return false;
        }
        ID3v22Tag object = (ID3v22Tag)obj;
        if (this.compression != object.compression) {
            return false;
        }
        return this.unsynchronization == object.unsynchronization && super.equals(obj);
    }

    @Override
    protected List<AbstractID3v2Frame> convertFrame(AbstractID3v2Frame frame) throws InvalidFrameException {
        ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
        if (frame.getIdentifier().equals("TDRC") && frame.getBody() instanceof FrameBodyTDRC) {
            ID3v22Frame newFrame;
            FrameBodyTDRC tmpBody = (FrameBodyTDRC)frame.getBody();
            if (tmpBody.getYear().length() != 0) {
                newFrame = new ID3v22Frame("TYE");
                ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getYear());
                frames.add(newFrame);
            }
            if (tmpBody.getTime().length() != 0) {
                newFrame = new ID3v22Frame("TIM");
                ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getTime());
                frames.add(newFrame);
            }
        } else {
            frames.add(new ID3v22Frame(frame));
        }
        return frames;
    }

    @Override
    public void addFrame(AbstractID3v2Frame frame) {
        try {
            if (frame instanceof ID3v22Frame) {
                this.copyFrameIntoMap(frame.getIdentifier(), frame);
            } else {
                List<AbstractID3v2Frame> frames = this.convertFrame(frame);
                for (AbstractID3v2Frame next : frames) {
                    this.copyFrameIntoMap(next.getIdentifier(), next);
                }
            }
        }
        catch (InvalidFrameException ife) {
            logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier());
        }
    }

    private void readHeaderFlags(ByteBuffer byteBuffer) throws TagException {
        byte flags = byteBuffer.get();
        this.unsynchronization = (flags & 0x80) != 0;
        boolean bl = this.compression = (flags & 0x40) != 0;
        if (this.unsynchronization) {
            logger.config(ErrorMessage.ID3_TAG_UNSYNCHRONIZED.getMsg(this.getLoggingFilename()));
        }
        if (this.compression) {
            logger.config(ErrorMessage.ID3_TAG_COMPRESSED.getMsg(this.getLoggingFilename()));
        }
        if ((flags & 0x20) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 32));
        }
        if ((flags & 0x10) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 16));
        }
        if ((flags & 8) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
        if ((flags & 4) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 4));
        }
        if ((flags & 2) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 2));
        }
        if ((flags & 1) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v2.20 tag not found");
        }
        logger.config(this.getLoggingFilename() + ":Reading tag from file");
        this.readHeaderFlags(byteBuffer);
        int size = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        ByteBuffer bufferWithoutHeader = byteBuffer.slice();
        if (this.unsynchronization) {
            bufferWithoutHeader = ID3Unsynchronization.synchronize(bufferWithoutHeader);
        }
        this.readFrames(bufferWithoutHeader, size);
        logger.config(this.getLoggingFilename() + ":Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int size) {
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.fileReadSize = size;
        logger.finest(this.getLoggingFilename() + ":Start of frame body at:" + byteBuffer.position() + ",frames sizes and padding is:" + size);
        while (byteBuffer.position() < size) {
            try {
                logger.config(this.getLoggingFilename() + ":looking for next frame at:" + byteBuffer.position());
                ID3v22Frame next = new ID3v22Frame(byteBuffer, this.getLoggingFilename());
                String id = next.getIdentifier();
                this.loadFrameIntoMap(id, next);
            }
            catch (PaddingException ex) {
                logger.config(this.getLoggingFilename() + ":Found padding starting at:" + byteBuffer.position());
                break;
            }
            catch (EmptyFrameException ex) {
                logger.warning(this.getLoggingFilename() + ":Empty Frame:" + ex.getMessage());
                this.emptyFrameBytes += 6;
            }
            catch (InvalidFrameIdentifierException ifie) {
                logger.config(this.getLoggingFilename() + ":Invalid Frame Identifier:" + ifie.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidFrameException ife) {
                logger.warning(this.getLoggingFilename() + ":Invalid Frame:" + ife.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidDataTypeException idete) {
                logger.warning(this.getLoggingFilename() + ":Corrupt Frame:" + idete.getMessage());
                ++this.invalidFrames;
            }
        }
    }

    protected void translateFrame(AbstractID3v2Frame frame) {
        ID3v22Frame newFrame;
        FrameBodyTDRC tmpBody = (FrameBodyTDRC)frame.getBody();
        if (tmpBody.getYear().length() != 0) {
            newFrame = new ID3v22Frame("TYE");
            ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getYear());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
        if (tmpBody.getTime().length() != 0) {
            newFrame = new ID3v22Frame("TIM");
            ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getTime());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    private ByteBuffer writeHeaderToBuffer(int padding, int size) throws IOException {
        this.compression = false;
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        headerBuffer.put(TAG_ID);
        headerBuffer.put(this.getMajorVersion());
        headerBuffer.put(this.getRevision());
        byte flags = 0;
        if (this.unsynchronization) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        if (this.compression) {
            flags = (byte)(flags | 0x40);
        }
        headerBuffer.put(flags);
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(padding + size));
        headerBuffer.flip();
        return headerBuffer;
    }

    @Override
    public long write(File file, long audioStartLocation) throws IOException {
        this.setLoggingFilename(file.getName());
        logger.config("Writing tag to file:" + this.getLoggingFilename());
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer);
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, (int)audioStartLocation);
        int padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        logger.config(this.getLoggingFilename() + ":Current audiostart:" + audioStartLocation);
        logger.config(this.getLoggingFilename() + ":Size including padding:" + sizeIncPadding);
        logger.config(this.getLoggingFilename() + ":Padding:" + padding);
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        this.writeBufferToFile(file, headerBuffer, bodyByteBuffer, padding, sizeIncPadding, audioStartLocation);
        return sizeIncPadding;
    }

    @Override
    public void write(WritableByteChannel channel, int currentTagSize) throws IOException {
        logger.config(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        boolean bl = this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer);
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.config(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int padding = 0;
        if (currentTagSize > 0) {
            int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, currentTagSize);
            padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        }
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        channel.write(headerBuffer);
        channel.write(ByteBuffer.wrap(bodyByteBuffer));
        this.writePadding(channel, padding);
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.compression);
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.unsynchronization);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    public boolean isCompression() {
        return this.compression;
    }

    @Override
    public ID3v22Frame createFrame(String id) {
        return new ID3v22Frame(id);
    }

    public TagField createField(ID3v22FieldKey id3Key, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (id3Key == null) {
            throw new KeyNotFoundException();
        }
        return this.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(null, id3Key.getFrameId(), id3Key.getSubId()), value);
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (values == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        String value = values[0];
        if (genericKey == FieldKey.GENRE) {
            if (value == null) {
                throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
            }
            AbstractID3v2Tag.FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
            ID3v22Frame frame = this.createFrame(formatKey.getFrameId());
            FrameBodyTCON framebody = (FrameBodyTCON)frame.getBody();
            framebody.setV23Format();
            framebody.setText(FrameBodyTCON.convertGenericToID3v22Genre(value));
            return frame;
        }
        return super.createField(genericKey, values);
    }

    public String getFirst(ID3v22FieldKey id3v22FieldKey) throws KeyNotFoundException {
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        FieldKey genericKey = ID3v22Frames.getInstanceOf().getGenericKeyFromId3(id3v22FieldKey);
        if (genericKey != null) {
            return super.getFirst(genericKey);
        }
        AbstractID3v2Tag.FrameAndSubId frameAndSubId = new AbstractID3v2Tag.FrameAndSubId(null, id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId());
        return super.doGetValueAtIndex(frameAndSubId, 0);
    }

    public void deleteField(ID3v22FieldKey id3v22FieldKey) throws KeyNotFoundException {
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(null, id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId()));
    }

    @Override
    public void deleteField(String id) {
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(null, id, null));
    }

    @Override
    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey genericKey) {
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v22FieldKey id3v22FieldKey = ID3v22Frames.getInstanceOf().getId3KeyFromGenericKey(genericKey);
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException(genericKey.name());
        }
        return new AbstractID3v2Tag.FrameAndSubId(genericKey, id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId());
    }

    @Override
    protected ID3Frames getID3Frames() {
        return ID3v22Frames.getInstanceOf();
    }

    @Override
    public Comparator getPreferredFrameOrderComparator() {
        return ID3v22PreferredFrameOrderComparator.getInstanceof();
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            FrameBodyPIC coverArt = (FrameBodyPIC)((AbstractID3v2Frame)next).getBody();
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setMimeType(ImageFormats.getMimeTypeForFormat(coverArt.getFormatType()));
            artwork.setPictureType(coverArt.getPictureType());
            if (coverArt.isImageUrl()) {
                artwork.setLinked(true);
                artwork.setImageUrl(coverArt.getImageUrl());
            } else {
                artwork.setBinaryData(coverArt.getImageData());
            }
            artworkList.add(artwork);
        }
        return artworkList;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        ID3v22Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
        if (!artwork.isLinked()) {
            body.setObjectValue("PictureData", artwork.getBinaryData());
            body.setObjectValue("PictureType", artwork.getPictureType());
            body.setObjectValue("ImageType", ImageFormats.getFormatForMimeType(artwork.getMimeType()));
            body.setObjectValue("Description", "");
            return frame;
        }
        try {
            body.setObjectValue("PictureData", artwork.getImageUrl().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException uoe) {
            throw new RuntimeException(uoe.getMessage());
        }
        body.setObjectValue("PictureType", artwork.getPictureType());
        body.setObjectValue("ImageType", "-->");
        body.setObjectValue("Description", "");
        return frame;
    }

    public TagField createArtworkField(byte[] data, String mimeType) {
        ID3v22Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
        body.setObjectValue("PictureData", data);
        body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
        body.setObjectValue("ImageType", ImageFormats.getFormatForMimeType(mimeType));
        body.setObjectValue("Description", "");
        return frame;
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == FieldKey.GENRE) {
            List<TagField> fields = this.getFields(genericKey);
            ArrayList<String> convertedGenres = new ArrayList<String>();
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                FrameBodyTCON body = (FrameBodyTCON)frame.getBody();
                for (String next : body.getValues()) {
                    convertedGenres.add(FrameBodyTCON.convertID3v22GenreToGeneric(next));
                }
            }
            return convertedGenres;
        }
        return super.getAll(genericKey);
    }

    @Override
    public String getValue(FieldKey genericKey, int index) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (genericKey == FieldKey.GENRE) {
            List<TagField> fields = this.getFields(genericKey);
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                FrameBodyTCON body = (FrameBodyTCON)frame.getBody();
                return FrameBodyTCON.convertID3v22GenreToGeneric(body.getValues().get(index));
            }
            return "";
        }
        return super.getValue(genericKey, index);
    }

    @Override
    protected void loadFrameIntoMap(String frameId, AbstractID3v2Frame next) {
        if (next.getBody() instanceof FrameBodyTCON) {
            ((FrameBodyTCON)next.getBody()).setV23Format();
        }
        super.loadFrameIntoMap(frameId, next);
    }
}

