/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagTextField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v1FieldKey;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ID3v1TagField
implements TagTextField {
    private boolean common;
    private String content;
    private String id;

    public ID3v1TagField(byte[] raw) throws UnsupportedEncodingException {
        String field = new String(raw, StandardCharsets.ISO_8859_1);
        int i = field.indexOf(61);
        if (i == -1) {
            this.id = "ERRONEOUS";
            this.content = field;
        } else {
            this.id = field.substring(0, i).toUpperCase();
            this.content = field.length() > i ? field.substring(i + 1) : "";
        }
        this.checkCommon();
    }

    public ID3v1TagField(String fieldId, String fieldContent) {
        this.id = fieldId.toUpperCase();
        this.content = fieldContent;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals(ID3v1FieldKey.TITLE.name()) || this.id.equals(ID3v1FieldKey.ALBUM.name()) || this.id.equals(ID3v1FieldKey.ARTIST.name()) || this.id.equals(ID3v1FieldKey.GENRE.name()) || this.id.equals(ID3v1FieldKey.YEAR.name()) || this.id.equals(ID3v1FieldKey.COMMENT.name()) || this.id.equals(ID3v1FieldKey.TRACK.name());
    }

    protected void copy(byte[] src, byte[] dst, int dstOffset) {
        System.arraycopy(src, 0, dst, dstOffset, src.length);
    }

    @Override
    public void copyContent(TagField field) {
        if (field instanceof TagTextField) {
            this.content = ((TagTextField)field).getContent();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Charset getEncoding() {
        return StandardCharsets.ISO_8859_1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] size = new byte[4];
        byte[] idBytes = this.id.getBytes(StandardCharsets.ISO_8859_1);
        byte[] contentBytes = this.content.getBytes(StandardCharsets.ISO_8859_1);
        byte[] b = new byte[4 + idBytes.length + 1 + contentBytes.length];
        int length = idBytes.length + 1 + contentBytes.length;
        size[3] = (byte)((length & 0xFF000000) >> 24);
        size[2] = (byte)((length & 0xFF0000) >> 16);
        size[1] = (byte)((length & 0xFF00) >> 8);
        size[0] = (byte)(length & 0xFF);
        int offset = 0;
        this.copy(size, b, offset);
        this.copy(idBytes, b, offset += 4);
        b[offset += idBytes.length] = 61;
        this.copy(contentBytes, b, ++offset);
        return b;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void isBinary(boolean b) {
    }

    @Override
    public boolean isCommon() {
        return this.common;
    }

    @Override
    public boolean isEmpty() {
        return "".equals(this.content);
    }

    @Override
    public void setContent(String s) {
        this.content = s;
    }

    @Override
    public void setEncoding(Charset s) {
    }

    @Override
    public String toString() {
        return this.getContent();
    }
}

