/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v11Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v1Tag;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ID3v1Iterator
implements Iterator {
    private static final int TITLE = 1;
    private static final int ARTIST = 2;
    private static final int ALBUM = 3;
    private static final int COMMENT = 4;
    private static final int YEAR = 5;
    private static final int GENRE = 6;
    private static final int TRACK = 7;
    private ID3v1Tag id3v1tag;
    private int lastIndex = 0;

    public ID3v1Iterator(ID3v1Tag id3v1tag) {
        this.id3v1tag = id3v1tag;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(this.lastIndex);
    }

    public Object next() {
        return this.next(this.lastIndex);
    }

    @Override
    public void remove() {
        switch (this.lastIndex) {
            case 1: {
                this.id3v1tag.title = "";
            }
            case 2: {
                this.id3v1tag.artist = "";
            }
            case 3: {
                this.id3v1tag.album = "";
            }
            case 4: {
                this.id3v1tag.comment = "";
            }
            case 5: {
                this.id3v1tag.year = "";
            }
            case 6: {
                this.id3v1tag.genre = (byte)-1;
            }
            case 7: {
                if (!(this.id3v1tag instanceof ID3v11Tag)) break;
                ((ID3v11Tag)this.id3v1tag).track = (byte)-1;
            }
        }
    }

    private boolean hasNext(int index) {
        switch (index) {
            case 1: {
                return this.id3v1tag.title.length() > 0 || this.hasNext(index + 1);
            }
            case 2: {
                return this.id3v1tag.artist.length() > 0 || this.hasNext(index + 1);
            }
            case 3: {
                return this.id3v1tag.album.length() > 0 || this.hasNext(index + 1);
            }
            case 4: {
                return this.id3v1tag.comment.length() > 0 || this.hasNext(index + 1);
            }
            case 5: {
                return this.id3v1tag.year.length() > 0 || this.hasNext(index + 1);
            }
            case 6: {
                return this.id3v1tag.genre >= 0 || this.hasNext(index + 1);
            }
            case 7: {
                if (!(this.id3v1tag instanceof ID3v11Tag)) break;
                return ((ID3v11Tag)this.id3v1tag).track >= 0 || this.hasNext(index + 1);
            }
        }
        return false;
    }

    private Object next(int index) {
        switch (this.lastIndex) {
            case 0: {
                return this.id3v1tag.title.length() > 0 ? this.id3v1tag.title : this.next(index + 1);
            }
            case 1: {
                return this.id3v1tag.artist.length() > 0 ? this.id3v1tag.artist : this.next(index + 1);
            }
            case 2: {
                return this.id3v1tag.album.length() > 0 ? this.id3v1tag.album : this.next(index + 1);
            }
            case 3: {
                return this.id3v1tag.comment.length() > 0 ? this.id3v1tag.comment : this.next(index + 1);
            }
            case 4: {
                return this.id3v1tag.year.length() > 0 ? this.id3v1tag.year : this.next(index + 1);
            }
            case 5: {
                return this.id3v1tag.genre >= 0 ? Byte.valueOf(this.id3v1tag.genre) : this.next(index + 1);
            }
            case 6: {
                return this.id3v1tag instanceof ID3v11Tag && ((ID3v11Tag)this.id3v1tag).track >= 0 ? Byte.valueOf(((ID3v11Tag)this.id3v1tag).track) : null;
            }
        }
        throw new NoSuchElementException("Iteration has no more elements.");
    }
}

