/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype;

import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidDataTypeException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.HashMapInterface;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.NumberFixedLength;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.ChannelTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.EventTimingTimestampTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.EventTimingTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.InterpolationTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.ReceivedAsTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.SynchronisedLyricsContentType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.GenreTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.PictureTypes;
import io.github.maki99999.biomebeats.org.jaudiotagger.utils.EqualsUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class NumberHashMap
extends NumberFixedLength
implements HashMapInterface<Integer, String> {
    private Map<Integer, String> keyToValue = null;
    private Map<String, Integer> valueToKey = null;
    private boolean hasEmptyValue = false;

    public NumberHashMap(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody, size);
        if (identifier.equals("Genre")) {
            this.valueToKey = GenreTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = GenreTypes.getInstanceOf().getIdToValueMap();
            this.hasEmptyValue = true;
        } else if (identifier.equals("TextEncoding")) {
            this.valueToKey = TextEncoding.getInstanceOf().getValueToIdMap();
            this.keyToValue = TextEncoding.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("InterpolationMethod")) {
            this.valueToKey = InterpolationTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = InterpolationTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("PictureType")) {
            this.valueToKey = PictureTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = PictureTypes.getInstanceOf().getIdToValueMap();
            this.hasEmptyValue = true;
        } else if (identifier.equals("TypeOfEvent")) {
            this.valueToKey = EventTimingTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = EventTimingTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("TimeStampFormat")) {
            this.valueToKey = EventTimingTimestampTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = EventTimingTimestampTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("TypeOfChannel")) {
            this.valueToKey = ChannelTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = ChannelTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("RecievedAs")) {
            this.valueToKey = ReceivedAsTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = ReceivedAsTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("contentType")) {
            this.valueToKey = SynchronisedLyricsContentType.getInstanceOf().getValueToIdMap();
            this.keyToValue = SynchronisedLyricsContentType.getInstanceOf().getIdToValueMap();
        } else {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + identifier);
        }
    }

    public NumberHashMap(NumberHashMap copyObject) {
        super(copyObject);
        this.hasEmptyValue = copyObject.hasEmptyValue;
        this.keyToValue = copyObject.keyToValue;
        this.valueToKey = copyObject.valueToKey;
    }

    @Override
    public Map<Integer, String> getKeyToValue() {
        return this.keyToValue;
    }

    @Override
    public Map<String, Integer> getValueToKey() {
        return this.valueToKey;
    }

    @Override
    public void setValue(Object value) {
        this.value = value instanceof Byte ? Long.valueOf(((Byte)value).byteValue()) : (value instanceof Short ? Long.valueOf(((Short)value).shortValue()) : (value instanceof Integer ? Long.valueOf(((Integer)value).intValue()) : value));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberHashMap)) {
            return false;
        }
        NumberHashMap that = (NumberHashMap)obj;
        return EqualsUtil.areEqual(this.hasEmptyValue, that.hasEmptyValue) && EqualsUtil.areEqual(this.keyToValue, that.keyToValue) && EqualsUtil.areEqual(this.valueToKey, that.valueToKey) && super.equals(that);
    }

    @Override
    public Iterator<String> iterator() {
        if (this.keyToValue == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.keyToValue.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        super.readByteArray(arr, offset);
        Integer intValue = ((Long)this.value).intValue();
        if (!this.keyToValue.containsKey(intValue)) {
            if (!this.hasEmptyValue) {
                throw new InvalidDataTypeException(ErrorMessage.MP3_REFERENCE_KEY_INVALID.getMsg(this.identifier, intValue));
            }
            if (this.identifier.equals("PictureType")) {
                logger.warning(ErrorMessage.MP3_PICTURE_TYPE_INVALID.getMsg(this.value));
            }
        }
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.keyToValue.get(this.value) == null) {
            return "";
        }
        return this.keyToValue.get(this.value);
    }
}

