/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidDataTypeException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.AbstractDataType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import java.nio.charset.StandardCharsets;

public class Lyrics3TimeStamp
extends AbstractDataType {
    private long minute = 0L;
    private long second = 0L;

    public void readString(String s) {
    }

    public Lyrics3TimeStamp(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public Lyrics3TimeStamp(String identifier) {
        super(identifier, null);
    }

    public Lyrics3TimeStamp(Lyrics3TimeStamp copy) {
        super(copy);
        this.minute = copy.minute;
        this.second = copy.second;
    }

    public void setMinute(long minute) {
        this.minute = minute;
    }

    public long getMinute() {
        return this.minute;
    }

    public void setSecond(long second) {
        this.second = second;
    }

    public long getSecond() {
        return this.second;
    }

    @Override
    public int getSize() {
        return 7;
    }

    public void setTimeStamp(long timeStamp, byte timeStampFormat) {
        this.minute = (timeStamp /= 1000L) / 60L;
        this.second = timeStamp % 60L;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3TimeStamp)) {
            return false;
        }
        Lyrics3TimeStamp object = (Lyrics3TimeStamp)obj;
        if (this.minute != object.minute) {
            return false;
        }
        return this.second == object.second && super.equals(obj);
    }

    public void readString(String timeStamp, int offset) {
        if (timeStamp == null) {
            throw new NullPointerException("Image is null");
        }
        if (offset < 0 || offset >= timeStamp.length()) {
            throw new IndexOutOfBoundsException("Offset to timeStamp is out of bounds: offset = " + offset + ", timeStamp.length()" + timeStamp.length());
        }
        if ((timeStamp = timeStamp.substring(offset)).length() == 7) {
            this.minute = Integer.parseInt(timeStamp.substring(1, 3));
            this.second = Integer.parseInt(timeStamp.substring(4, 6));
        } else {
            this.minute = 0L;
            this.second = 0L;
        }
    }

    public String toString() {
        return this.writeString();
    }

    public String writeString() {
        String str = "[";
        if (this.minute < 0L) {
            str = str + "00";
        } else {
            if (this.minute < 10L) {
                str = str + '0';
            }
            str = str + Long.toString(this.minute);
        }
        str = str + ':';
        if (this.second < 0L) {
            str = str + "00";
        } else {
            if (this.second < 10L) {
                str = str + '0';
            }
            str = str + Long.toString(this.second);
        }
        str = str + ']';
        return str;
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        this.readString(arr.toString(), offset);
    }

    @Override
    public byte[] writeByteArray() {
        return this.writeString().getBytes(StandardCharsets.ISO_8859_1);
    }
}

