/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidDataTypeException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.AbstractDataType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.NumberFixedLength;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.NumberHashMap;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.valuepair.EventTimingTypes;

public class EventTimingCode
extends AbstractDataType
implements Cloneable {
    private static final int SIZE = 5;
    private NumberHashMap type = new NumberHashMap("TypeOfEvent", null, 1);
    private NumberFixedLength timestamp = new NumberFixedLength("DateTime", null, 4);

    public EventTimingCode(EventTimingCode copy) {
        super(copy);
        this.type.setValue(copy.type.getValue());
        this.timestamp.setValue(copy.timestamp.getValue());
    }

    public EventTimingCode(String identifier, AbstractTagFrameBody frameBody) {
        this(identifier, frameBody, 0, 0L);
    }

    public EventTimingCode(String identifier, AbstractTagFrameBody frameBody, int type, long timestamp) {
        super(identifier, frameBody);
        this.setBody(frameBody);
        this.type.setValue(type);
        this.timestamp.setValue(timestamp);
    }

    @Override
    public void setBody(AbstractTagFrameBody frameBody) {
        super.setBody(frameBody);
        this.type.setBody(frameBody);
        this.timestamp.setBody(frameBody);
    }

    public long getTimestamp() {
        return ((Number)this.timestamp.getValue()).longValue();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp.setValue(timestamp);
    }

    public int getType() {
        return ((Number)this.type.getValue()).intValue();
    }

    public void setType(int type) {
        this.type.setValue(type);
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public void readByteArray(byte[] buffer, int originalOffset) throws InvalidDataTypeException {
        int localOffset = originalOffset;
        int size = this.getSize();
        logger.finest("offset:" + localOffset);
        if (originalOffset > buffer.length - size) {
            logger.warning("Invalid size for FrameBody");
            throw new InvalidDataTypeException("Invalid size for FrameBody");
        }
        this.type.readByteArray(buffer, localOffset);
        this.timestamp.readByteArray(buffer, localOffset += this.type.getSize());
        localOffset += this.timestamp.getSize();
    }

    @Override
    public byte[] writeByteArray() {
        byte[] typeData = this.type.writeByteArray();
        byte[] timeData = this.timestamp.writeByteArray();
        if (typeData == null || timeData == null) {
            return null;
        }
        byte[] objectData = new byte[typeData.length + timeData.length];
        System.arraycopy(typeData, 0, objectData, 0, typeData.length);
        System.arraycopy(timeData, 0, objectData, typeData.length, timeData.length);
        return objectData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventTimingCode that = (EventTimingCode)o;
        return this.getType() == that.getType() && this.getTimestamp() == that.getTimestamp();
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "" + this.getType() + " (\"" + EventTimingTypes.getInstanceOf().getValueForId(this.getType()) + "\"), " + this.getTimestamp();
    }

    public Object clone() throws CloneNotSupportedException {
        return new EventTimingCode(this);
    }
}

