/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.InvalidDataTypeException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.datatype.AbstractDataType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class ByteArraySizeTerminated
extends AbstractDataType {
    public ByteArraySizeTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public ByteArraySizeTerminated(ByteArraySizeTerminated object) {
        super(object);
    }

    @Override
    public int getSize() {
        int len = 0;
        if (this.value != null) {
            len = ((byte[])this.value).length;
        }
        return len;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ByteArraySizeTerminated && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        if (offset >= arr.length) {
            this.value = null;
            return;
        }
        int len = arr.length - offset;
        this.value = new byte[len];
        System.arraycopy(arr, offset, this.value, 0, len);
    }

    public String toString() {
        return this.getSize() + " bytes";
    }

    @Override
    public byte[] writeByteArray() {
        logger.config("Writing byte array" + this.getIdentifier());
        return (byte[])this.value;
    }
}

