/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.logging;

import io.github.maki99999.biomebeats.org.jaudiotagger.logging.AbstractTagDisplayFormatter;
import java.text.StringCharacterIterator;

public class XMLTagDisplayFormatter
extends AbstractTagDisplayFormatter {
    private static XMLTagDisplayFormatter formatter;
    protected static final String xmlOpenStart = "<";
    protected static final String xmlOpenEnd = ">";
    protected static final String xmlCloseStart = "</";
    protected static final String xmlCloseEnd = ">";
    protected static final String xmlSingleTagClose = " />";
    protected static final String xmlCDataTagOpen = "<![CDATA[";
    protected static final String xmlCDataTagClose = "]]>";
    StringBuffer sb = new StringBuffer();

    public static String xmlOpen(String xmlName) {
        return xmlOpenStart + xmlName + ">";
    }

    public static String xmlOpenHeading(String name, String data) {
        return XMLTagDisplayFormatter.xmlOpen(name + " id=\"" + data + "\"");
    }

    public static String xmlCData(String xmlData) {
        StringBuffer replacedString = new StringBuffer();
        for (int i = 0; i < xmlData.length(); ++i) {
            char tempChar = xmlData.charAt(i);
            if (Character.isLetterOrDigit(tempChar) || Character.isSpaceChar(tempChar)) {
                replacedString.append(tempChar);
                continue;
            }
            replacedString.append("&#x").append(Integer.toString(Character.codePointAt(xmlData, i), 16));
        }
        return xmlCDataTagOpen + replacedString + xmlCDataTagClose;
    }

    public static String xmlClose(String xmlName) {
        return xmlCloseStart + xmlName + ">";
    }

    public static String xmlSingleTag(String data) {
        return xmlOpenStart + data + xmlSingleTagClose;
    }

    public static String xmlFullTag(String xmlName, String data) {
        return XMLTagDisplayFormatter.xmlOpen(xmlName) + XMLTagDisplayFormatter.xmlCData(data) + XMLTagDisplayFormatter.xmlClose(xmlName);
    }

    @Override
    public void openHeadingElement(String type, String value) {
        if (value.length() == 0) {
            this.sb.append(XMLTagDisplayFormatter.xmlOpen(type));
        } else {
            this.sb.append(XMLTagDisplayFormatter.xmlOpenHeading(type, XMLTagDisplayFormatter.replaceXMLCharacters(value)));
        }
    }

    @Override
    public void openHeadingElement(String type, boolean value) {
        this.openHeadingElement(type, String.valueOf(value));
    }

    @Override
    public void openHeadingElement(String type, int value) {
        this.openHeadingElement(type, String.valueOf(value));
    }

    @Override
    public void closeHeadingElement(String type) {
        this.sb.append(XMLTagDisplayFormatter.xmlClose(type));
    }

    @Override
    public void addElement(String type, String value) {
        this.sb.append(XMLTagDisplayFormatter.xmlFullTag(type, XMLTagDisplayFormatter.replaceXMLCharacters(value)));
    }

    @Override
    public void addElement(String type, int value) {
        this.addElement(type, String.valueOf(value));
    }

    @Override
    public void addElement(String type, boolean value) {
        this.addElement(type, String.valueOf(value));
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public static String replaceXMLCharacters(String xmlData) {
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator sCI = new StringCharacterIterator(xmlData);
        char c = sCI.first();
        while (c != '\uffff') {
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            c = sCI.next();
        }
        return sb.toString();
    }
}

