/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavInfoChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavTag;
import java.io.IOException;
import java.nio.ByteBuffer;

public class WavListChunk
extends Chunk {
    private boolean isValid = false;
    private WavTag tag;
    private String loggingName;

    public WavListChunk(String loggingName, ByteBuffer chunkData, ChunkHeader chunkHeader, WavTag tag) throws IOException {
        super(chunkData, chunkHeader);
        this.tag = tag;
        this.loggingName = loggingName;
    }

    @Override
    public boolean readChunk() throws IOException {
        boolean result = false;
        String subIdentifier = Utils.readFourBytesAsChars(this.chunkData);
        if (subIdentifier.equals(WavChunkType.INFO.getCode())) {
            WavInfoChunk chunk = new WavInfoChunk(this.tag, this.loggingName);
            result = chunk.readChunks(this.chunkData);
            this.tag.getInfoTag().setStartLocationInFile(this.chunkHeader.getStartLocationInFile());
            this.tag.getInfoTag().setEndLocationInFile(this.chunkHeader.getStartLocationInFile() + 8L + this.chunkHeader.getSize());
            this.tag.setExistingInfoTag(true);
        }
        return result;
    }

    public String toString() {
        String out = "RIFF-WAVE Header:\n";
        out = out + "Is valid?: " + this.isValid;
        return out;
    }
}

