/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk;

import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import java.util.HashMap;
import java.util.Map;

public enum WavInfoIdentifier {
    ARTIST("IART", FieldKey.ARTIST, 1),
    ALBUM("IPRD", FieldKey.ALBUM, 2),
    TITLE("INAM", FieldKey.TITLE, 3),
    TRACKNO("ITRK", FieldKey.TRACK, 4),
    YEAR("ICRD", FieldKey.YEAR, 5),
    GENRE("IGNR", FieldKey.GENRE, 6),
    ALBUM_ARTIST("iaar", FieldKey.ALBUM_ARTIST, 7),
    COMMENTS("ICMT", FieldKey.COMMENT, 8),
    COMPOSER("IMUS", FieldKey.COMPOSER, 9),
    CONDUCTOR("ITCH", FieldKey.CONDUCTOR, 10),
    LYRICIST("IWRI", FieldKey.LYRICIST, 11),
    ENCODER("ISFT", FieldKey.ENCODER, 12),
    RATING("IRTD", FieldKey.RATING, 13),
    ISRC("ISRC", FieldKey.ISRC, 14),
    LABEL("ICMS", FieldKey.RECORD_LABEL, 15),
    TRACK_GAIN("ITGL", null, 16),
    ALBUM_GAIN("IAGL", null, 17),
    COPYRIGHT("ICOP", null, 18),
    TWONKY_TRACKNO("itrk", null, 1);

    private static final Map<String, WavInfoIdentifier> CODE_TYPE_MAP;
    private static final Map<FieldKey, WavInfoIdentifier> FIELDKEY_TYPE_MAP;
    private String code;
    private FieldKey fieldKey;
    private int preferredWriteOrder;

    private WavInfoIdentifier(String code, FieldKey fieldKey, int preferredWriteOrder) {
        this.code = code;
        this.fieldKey = fieldKey;
        this.preferredWriteOrder = preferredWriteOrder;
    }

    public String getCode() {
        return this.code;
    }

    public FieldKey getFieldKey() {
        return this.fieldKey;
    }

    public int getPreferredWriteOrder() {
        return this.preferredWriteOrder;
    }

    public static synchronized WavInfoIdentifier getByCode(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (WavInfoIdentifier type : WavInfoIdentifier.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    public static synchronized WavInfoIdentifier getByByFieldKey(FieldKey fieldKey) {
        if (FIELDKEY_TYPE_MAP.isEmpty()) {
            for (WavInfoIdentifier type : WavInfoIdentifier.values()) {
                if (type.getFieldKey() == null) continue;
                FIELDKEY_TYPE_MAP.put(type.getFieldKey(), type);
            }
        }
        return FIELDKEY_TYPE_MAP.get((Object)fieldKey);
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, WavInfoIdentifier>();
        FIELDKEY_TYPE_MAP = new HashMap<FieldKey, WavInfoIdentifier>();
    }
}

