/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkSummary;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavTag;
import java.util.logging.Logger;

public class WavChunkSummary {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk");

    public static long getStartLocationOfFirstMetadataChunk(WavTag tag) {
        long startLocationOfMetadatTag = -1L;
        if (tag.getInfoTag() != null) {
            startLocationOfMetadatTag = tag.getInfoTag().getStartLocationInFile();
            if (tag.getID3Tag() != null && tag.getStartLocationInFileOfId3Chunk() < startLocationOfMetadatTag) {
                startLocationOfMetadatTag = tag.getStartLocationInFileOfId3Chunk();
            }
        } else if (tag.getID3Tag() != null) {
            startLocationOfMetadatTag = tag.getStartLocationInFileOfId3Chunk();
        }
        return startLocationOfMetadatTag;
    }

    public static boolean isOnlyMetadataTagsAfterStartingMetadataTag(WavTag tag) {
        long startLocationOfMetadatTag = WavChunkSummary.getStartLocationOfFirstMetadataChunk(tag);
        if (startLocationOfMetadatTag == -1L) {
            logger.severe("Unable to find any metadata tags !");
            return false;
        }
        boolean firstMetadataTag = false;
        for (ChunkSummary cs : tag.getChunkSummaryList()) {
            if (firstMetadataTag) {
                if (cs.getChunkId().equals(WavChunkType.ID3.getCode()) || cs.getChunkId().equals(WavChunkType.LIST.getCode()) || cs.getChunkId().equals(WavChunkType.INFO.getCode())) continue;
                return false;
            }
            if (cs.getFileStartLocation() != startLocationOfMetadatTag) continue;
            firstMetadataTag = true;
        }
        return firstMetadataTag;
    }

    public static ChunkSummary getChunkBeforeFirstMetadataTag(WavTag tag) {
        long startLocationOfMetadatTag = WavChunkSummary.getStartLocationOfFirstMetadataChunk(tag);
        for (int i = 0; i < tag.getChunkSummaryList().size(); ++i) {
            ChunkSummary cs = tag.getChunkSummaryList().get(i);
            if (cs.getFileStartLocation() != startLocationOfMetadatTag) continue;
            return tag.getChunkSummaryList().get(i - 1);
        }
        return null;
    }
}

