/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkSummary;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavSaveOptions;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavSaveOrder;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavTagReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavChunkSummary;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavInfoIdentifier;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagTextField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavInfoTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavTag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class WavTagWriter {
    private String loggingName;
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav");

    public WavTagWriter(String loggingName) {
        this.loggingName = loggingName;
    }

    private WavTag getExistingMetadata(Path path) throws IOException, CannotWriteException {
        try {
            WavTagReader im = new WavTagReader(this.loggingName);
            return im.read(path);
        }
        catch (CannotReadException ex) {
            throw new CannotWriteException("Failed to read file " + path);
        }
    }

    private ChunkHeader seekToStartOfListInfoMetadata(FileChannel fc, WavTag existingTag) throws IOException, CannotWriteException {
        fc.position(existingTag.getInfoTag().getStartLocationInFile());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!WavChunkType.LIST.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(this.loggingName + " Unable to find List chunk at original location has file been modified externally");
        }
        return chunkHeader;
    }

    private ChunkHeader seekToStartOfId3Metadata(FileChannel fc, WavTag existingTag) throws IOException, CannotWriteException {
        fc.position(existingTag.getStartLocationInFileOfId3Chunk());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!WavChunkType.ID3.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(this.loggingName + " Unable to find ID3 chunk at original location has file been modified externally");
        }
        return chunkHeader;
    }

    public void delete(Tag tag, Path file) throws CannotWriteException {
        logger.info(this.loggingName + " Deleting metadata from file");
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            WavTag existingTag = this.getExistingMetadata(file);
            if (existingTag.isExistingId3Tag() && existingTag.isExistingInfoTag()) {
                BothTagsFileStructure fs = this.checkExistingLocations(existingTag, fc);
                if (fs.isContiguous) {
                    if (fs.isAtEnd) {
                        if (fs.isInfoTagFirst) {
                            logger.info(this.loggingName + ":Setting new length to:" + existingTag.getInfoTag().getStartLocationInFile());
                            fc.truncate(existingTag.getInfoTag().getStartLocationInFile());
                        } else {
                            logger.info(this.loggingName + ":Setting new length to:" + existingTag.getStartLocationInFileOfId3Chunk());
                            fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                        }
                    } else if (fs.isInfoTagFirst) {
                        int lengthTagChunk = (int)(existingTag.getEndLocationInFileOfId3Chunk() - existingTag.getInfoTag().getStartLocationInFile());
                        this.deleteTagChunk(fc, (int)existingTag.getEndLocationInFileOfId3Chunk(), lengthTagChunk);
                    } else {
                        int lengthTagChunk = (int)((long)existingTag.getInfoTag().getEndLocationInFile().intValue() - existingTag.getStartLocationInFileOfId3Chunk());
                        this.deleteTagChunk(fc, existingTag.getInfoTag().getEndLocationInFile().intValue(), lengthTagChunk);
                    }
                } else {
                    WavInfoTag existingInfoTag = existingTag.getInfoTag();
                    ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                    ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(fc, existingTag);
                    if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        fc.truncate(existingInfoTag.getStartLocationInFile());
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                    } else if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    } else {
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                        existingTag = this.getExistingMetadata(file);
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    }
                }
            } else if (existingTag.isExistingInfoTag()) {
                WavInfoTag existingInfoTag = existingTag.getInfoTag();
                ChunkHeader chunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                if (existingInfoTag.getEndLocationInFile().longValue() == fc.size()) {
                    logger.info(this.loggingName + ":Setting new length to:" + existingInfoTag.getStartLocationInFile());
                    fc.truncate(existingInfoTag.getStartLocationInFile());
                } else {
                    this.deleteInfoTagChunk(fc, existingTag, chunkHeader);
                }
            } else if (existingTag.isExistingId3Tag()) {
                ChunkHeader chunkHeader = this.seekToStartOfId3Metadata(fc, existingTag);
                if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                    logger.info(this.loggingName + ":Setting new length to:" + existingTag.getStartLocationInFileOfId3Chunk());
                    fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                } else {
                    this.deleteId3TagChunk(fc, existingTag, chunkHeader);
                }
            }
            this.rewriteRiffHeaderSize(fc);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void deleteInfoTagChunk(FileChannel fc, WavTag existingTag, ChunkHeader chunkHeader) throws IOException {
        WavInfoTag existingInfoTag = existingTag.getInfoTag();
        int lengthTagChunk = (int)chunkHeader.getSize() + 8;
        this.deleteTagChunk(fc, existingInfoTag.getEndLocationInFile().intValue(), lengthTagChunk);
    }

    private void deleteId3TagChunk(FileChannel fc, WavTag existingTag, ChunkHeader chunkHeader) throws IOException {
        int lengthTagChunk = (int)chunkHeader.getSize() + 8;
        this.deleteTagChunk(fc, (int)existingTag.getEndLocationInFileOfId3Chunk(), lengthTagChunk);
    }

    private void deleteTagChunk(FileChannel fc, int endOfExistingChunk, int lengthTagChunk) throws IOException {
        fc.position(endOfExistingChunk);
        ByteBuffer buffer = ByteBuffer.allocate((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (fc.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = fc.position();
            fc.position(readPosition - (long)lengthTagChunk - (long)buffer.limit());
            fc.write(buffer);
            fc.position(readPosition);
            buffer.compact();
        }
        long newLength = fc.size() - (long)lengthTagChunk;
        logger.config(this.loggingName + " Setting new length to:" + newLength);
        fc.truncate(newLength);
    }

    public void write(Tag tag, Path file) throws CannotWriteException {
        logger.config(this.loggingName + " Writing tag to file:start");
        WavSaveOptions wso = TagOptionSingleton.getInstance().getWavSaveOptions();
        WavTag existingTag = null;
        try {
            existingTag = this.getExistingMetadata(file);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            WavTag wavTag = (WavTag)tag;
            if (wso == WavSaveOptions.SAVE_BOTH) {
                this.saveBoth(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_ACTIVE) {
                this.saveActive(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_EXISTING_AND_ACTIVE) {
                this.saveActiveExisting(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_BOTH_AND_SYNC) {
                wavTag.syncTagBeforeWrite();
                this.saveBoth(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_EXISTING_AND_ACTIVE_AND_SYNC) {
                wavTag.syncTagBeforeWrite();
                this.saveActiveExisting(wavTag, fc, existingTag);
            } else {
                throw new RuntimeException(this.loggingName + " No setting for:WavSaveOptions");
            }
            this.rewriteRiffHeaderSize(fc);
        }
        catch (AccessDeniedException ade) {
            throw new NoWritePermissionsException(file + ":" + ade.getMessage());
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void rewriteRiffHeaderSize(FileChannel fc) throws IOException {
        fc.position(IffHeaderChunk.SIGNATURE_LENGTH);
        ByteBuffer bb = ByteBuffer.allocateDirect(IffHeaderChunk.SIZE_LENGTH);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int size = (int)fc.size() - IffHeaderChunk.SIGNATURE_LENGTH - IffHeaderChunk.SIZE_LENGTH;
        bb.putInt(size);
        bb.flip();
        fc.write(bb);
    }

    private void writeInfoDataToFile(FileChannel fc, ByteBuffer bb, long chunkSize) throws IOException {
        if (Utils.isOddLength(fc.position())) {
            this.writePaddingToFile(fc, 1);
        }
        ByteBuffer listHeaderBuffer = ByteBuffer.allocate(8);
        listHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
        listHeaderBuffer.put(WavChunkType.LIST.getCode().getBytes(StandardCharsets.US_ASCII));
        listHeaderBuffer.putInt((int)chunkSize);
        listHeaderBuffer.flip();
        fc.write(listHeaderBuffer);
        fc.write(bb);
        this.writeExtraByteIfChunkOddSize(fc, chunkSize);
    }

    private void writeInfoDataToFile(FileChannel fc, ByteBuffer bb) throws IOException {
        this.writeInfoDataToFile(fc, bb, bb.limit());
    }

    private void writeID3DataToFile(FileChannel fc, ByteBuffer bb) throws IOException {
        if (Utils.isOddLength(fc.position())) {
            this.writePaddingToFile(fc, 1);
        }
        ByteBuffer listBuffer = ByteBuffer.allocate(8);
        listBuffer.order(ByteOrder.LITTLE_ENDIAN);
        listBuffer.put(WavChunkType.ID3.getCode().getBytes(StandardCharsets.US_ASCII));
        listBuffer.putInt(bb.limit());
        listBuffer.flip();
        fc.write(listBuffer);
        fc.write(bb);
    }

    private void writePaddingToFile(FileChannel fc, int paddingSize) throws IOException {
        fc.write(ByteBuffer.allocateDirect(paddingSize));
    }

    public ByteBuffer convertInfoChunk(WavTag tag) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WavInfoTag wif = tag.getInfoTag();
            List<TagField> fields = wif.getAll();
            Collections.sort(fields, new InfoFieldWriterOrderComparator());
            boolean isTrackRewritten = false;
            for (TagField nextField : fields) {
                TagTextField next = (TagTextField)nextField;
                WavInfoIdentifier wii = WavInfoIdentifier.getByByFieldKey(FieldKey.valueOf(next.getId()));
                baos.write(wii.getCode().getBytes(StandardCharsets.US_ASCII));
                logger.config(this.loggingName + " Writing:" + wii.getCode() + ":" + next.getContent());
                byte[] contentConvertedToBytes = next.getContent().getBytes(StandardCharsets.UTF_8);
                baos.write(Utils.getSizeLEInt32(contentConvertedToBytes.length));
                baos.write(contentConvertedToBytes);
                if (Utils.isOddLength(contentConvertedToBytes.length)) {
                    baos.write(0);
                }
                if (wii != WavInfoIdentifier.TRACKNO) continue;
                isTrackRewritten = true;
                if (!TagOptionSingleton.getInstance().isWriteWavForTwonky()) continue;
                baos.write(WavInfoIdentifier.TWONKY_TRACKNO.getCode().getBytes(StandardCharsets.US_ASCII));
                logger.config(this.loggingName + " Writing:" + WavInfoIdentifier.TWONKY_TRACKNO.getCode() + ":" + next.getContent());
                baos.write(Utils.getSizeLEInt32(contentConvertedToBytes.length));
                baos.write(contentConvertedToBytes);
                if (!Utils.isOddLength(contentConvertedToBytes.length)) continue;
                baos.write(0);
            }
            for (TagTextField next : wif.getUnrecognisedFields()) {
                if (next.getId().equals(WavInfoIdentifier.TWONKY_TRACKNO.getCode()) && (isTrackRewritten || !TagOptionSingleton.getInstance().isWriteWavForTwonky())) continue;
                baos.write(next.getId().getBytes(StandardCharsets.US_ASCII));
                logger.config(this.loggingName + " Writing:" + next.getId() + ":" + next.getContent());
                byte[] contentConvertedToBytes = next.getContent().getBytes(StandardCharsets.UTF_8);
                baos.write(Utils.getSizeLEInt32(contentConvertedToBytes.length));
                baos.write(contentConvertedToBytes);
                if (!Utils.isOddLength(contentConvertedToBytes.length)) continue;
                baos.write(0);
            }
            ByteBuffer infoBuffer = ByteBuffer.wrap(baos.toByteArray());
            infoBuffer.rewind();
            ByteBuffer infoHeaderBuffer = ByteBuffer.allocate(IffHeaderChunk.SIGNATURE_LENGTH);
            infoHeaderBuffer.put(WavChunkType.INFO.getCode().getBytes(StandardCharsets.US_ASCII));
            infoHeaderBuffer.flip();
            ByteBuffer listInfoBuffer = ByteBuffer.allocateDirect(infoHeaderBuffer.limit() + infoBuffer.limit());
            listInfoBuffer.put(infoHeaderBuffer);
            listInfoBuffer.put(infoBuffer);
            listInfoBuffer.flip();
            return listInfoBuffer;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public ByteBuffer convertID3Chunk(WavTag tag, WavTag existingTag) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long existingTagSize = existingTag.getSizeOfID3TagOnly();
            if (existingTagSize > 0L && (existingTagSize & 1L) != 0L) {
                ++existingTagSize;
            }
            tag.getID3Tag().write(baos, (int)existingTagSize);
            if ((baos.toByteArray().length & 1) != 0) {
                int newSize = baos.toByteArray().length + 1;
                baos = new ByteArrayOutputStream();
                tag.getID3Tag().write(baos, newSize);
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private BothTagsFileStructure checkExistingLocations(WavTag wavTag, FileChannel fc) throws IOException {
        BothTagsFileStructure fs = new BothTagsFileStructure();
        if (wavTag.getInfoTag().getStartLocationInFile() < wavTag.getID3Tag().getStartLocationInFile()) {
            fs.isInfoTagFirst = true;
            if (Math.abs(wavTag.getInfoTag().getEndLocationInFile() - wavTag.getStartLocationInFileOfId3Chunk()) <= 1L) {
                fs.isContiguous = true;
                if (this.isID3TagAtEndOfFileAllowingForPaddingByte(wavTag, fc)) {
                    fs.isAtEnd = true;
                }
            }
        } else if (Math.abs(wavTag.getID3Tag().getEndLocationInFile() - wavTag.getInfoTag().getStartLocationInFile()) <= 1L) {
            fs.isContiguous = true;
            if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(wavTag, fc)) {
                fs.isAtEnd = true;
            }
        }
        return fs;
    }

    private void writeInfoChunk(FileChannel fc, WavInfoTag existingInfoTag, ByteBuffer newTagBuffer) throws CannotWriteException, IOException {
        long newInfoTagSize = newTagBuffer.limit();
        if (existingInfoTag.getSizeOfTag() >= newInfoTagSize) {
            this.writeInfoDataToFile(fc, newTagBuffer, existingInfoTag.getSizeOfTag());
            if (existingInfoTag.getSizeOfTag() > newInfoTagSize) {
                this.writePaddingToFile(fc, (int)(existingInfoTag.getSizeOfTag() - newInfoTagSize));
            }
        } else {
            this.writeInfoDataToFile(fc, newTagBuffer, newInfoTagSize);
        }
    }

    private void writeExtraByteIfChunkOddSize(FileChannel fc, long size) throws IOException {
        if (Utils.isOddLength(size)) {
            this.writePaddingToFile(fc, 1);
        }
    }

    private boolean isID3TagAtEndOfFileAllowingForPaddingByte(WavTag existingTag, FileChannel fc) throws IOException {
        return existingTag.getID3Tag().getEndLocationInFile().longValue() == fc.size() || (existingTag.getID3Tag().getEndLocationInFile() & 1L) != 0L && existingTag.getID3Tag().getEndLocationInFile() + 1L == fc.size();
    }

    private boolean isInfoTagAtEndOfFileAllowingForPaddingByte(WavTag existingTag, FileChannel fc) throws IOException {
        return existingTag.getInfoTag().getEndLocationInFile().longValue() == fc.size() || (existingTag.getInfoTag().getEndLocationInFile() & 1L) != 0L && existingTag.getInfoTag().getEndLocationInFile() + 1L == fc.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveBoth(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        ByteBuffer infoTagBuffer = this.convertInfoChunk(wavTag);
        ByteBuffer id3TagBuffer = this.convertID3Chunk(wavTag, existingTag);
        if (existingTag.isExistingInfoTag() && existingTag.isExistingId3Tag()) {
            if (!existingTag.isIncorrectlyAlignedTag()) {
                BothTagsFileStructure fs = this.checkExistingLocations(existingTag, fc);
                if (fs.isContiguous && fs.isAtEnd) {
                    if (fs.isInfoTagFirst) {
                        this.seekToStartOfListInfoMetadata(fc, existingTag);
                        this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                        fc.truncate(fc.position());
                        return;
                    } else {
                        this.seekToStartOfId3Metadata(fc, existingTag);
                        this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                        fc.truncate(fc.position());
                    }
                    return;
                } else {
                    ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                    ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(fc, existingTag);
                    this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                    fc.position(fc.size());
                    this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                }
                return;
            } else {
                if (!WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
                this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
                fc.position(fc.size());
                this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
            }
            return;
        } else if (existingTag.isExistingInfoTag() && !existingTag.isExistingId3Tag()) {
            if (!existingTag.isIncorrectlyAlignedTag()) {
                ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                    this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                    fc.truncate(fc.position());
                    return;
                } else {
                    this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    fc.position(fc.size());
                    this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                }
                return;
            } else {
                if (!WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
                this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
                fc.position(fc.size());
                this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
            }
            return;
        } else if (existingTag.isExistingId3Tag() && !existingTag.isExistingInfoTag()) {
            if (!existingTag.isIncorrectlyAlignedTag()) {
                ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(fc, existingTag);
                if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                    this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                    fc.truncate(fc.position());
                    return;
                } else {
                    this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                    fc.position(fc.size());
                    this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
                }
                return;
            } else {
                if (!WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
                this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
                fc.position(fc.size());
                this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
            }
            return;
        } else {
            fc.position(fc.size());
            this.writeBothTags(fc, infoTagBuffer, id3TagBuffer);
        }
    }

    private void writeBothTags(FileChannel fc, ByteBuffer infoTagBuffer, ByteBuffer id3TagBuffer) throws IOException {
        if (TagOptionSingleton.getInstance().getWavSaveOrder() == WavSaveOrder.INFO_THEN_ID3) {
            this.writeInfoDataToFile(fc, infoTagBuffer);
            this.writeID3DataToFile(fc, id3TagBuffer);
        } else {
            this.writeID3DataToFile(fc, id3TagBuffer);
            this.writeInfoDataToFile(fc, infoTagBuffer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveActive(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        if (wavTag.getActiveTag() instanceof WavInfoTag) {
            ByteBuffer infoTagBuffer = this.convertInfoChunk(wavTag);
            long newInfoTagSize = infoTagBuffer.limit();
            if (!existingTag.isIncorrectlyAlignedTag()) {
                if (existingTag.isExistingId3Tag()) {
                    if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                    } else {
                        ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(fc, existingTag);
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                    }
                }
                if (existingTag.isExistingInfoTag()) {
                    ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                    if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        this.writeInfoChunk(fc, existingTag.getInfoTag(), infoTagBuffer);
                        return;
                    } else {
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                        fc.position(fc.size());
                        this.writeInfoDataToFile(fc, infoTagBuffer, infoTagBuffer.limit());
                    }
                    return;
                } else {
                    fc.position(fc.size());
                    this.writeInfoDataToFile(fc, infoTagBuffer, newInfoTagSize);
                }
                return;
            } else {
                if (!WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
                this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
                fc.position(fc.size());
                this.writeInfoDataToFile(fc, infoTagBuffer, newInfoTagSize);
            }
            return;
        } else {
            ByteBuffer id3TagBuffer = this.convertID3Chunk(wavTag, existingTag);
            if (!existingTag.isIncorrectlyAlignedTag()) {
                if (existingTag.isExistingInfoTag()) {
                    ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                    if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        fc.truncate(existingTag.getInfoTag().getStartLocationInFile());
                    } else {
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    }
                }
                if (existingTag.isExistingId3Tag()) {
                    ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(fc, existingTag);
                    if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        this.writeID3DataToFile(fc, id3TagBuffer);
                        return;
                    } else {
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                        fc.position(fc.size());
                        this.writeID3DataToFile(fc, id3TagBuffer);
                    }
                    return;
                } else {
                    fc.position(fc.size());
                    this.writeID3DataToFile(fc, id3TagBuffer);
                }
                return;
            } else {
                if (!WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
                this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
                fc.position(fc.size());
                this.writeID3DataToFile(fc, id3TagBuffer);
            }
        }
    }

    private void saveActiveExisting(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        if (wavTag.getActiveTag() instanceof WavInfoTag) {
            if (existingTag.isExistingId3Tag()) {
                this.saveBoth(wavTag, fc, existingTag);
            } else {
                this.saveActive(wavTag, fc, existingTag);
            }
        } else if (existingTag.isExistingInfoTag()) {
            this.saveBoth(wavTag, fc, existingTag);
        } else {
            this.saveActive(wavTag, fc, existingTag);
        }
    }

    private void deleteExistingMetadataTagsToEndOfFile(FileChannel fc, WavTag existingTag) throws IOException {
        ChunkSummary precedingChunk = WavChunkSummary.getChunkBeforeFirstMetadataTag(existingTag);
        if (!Utils.isOddLength(precedingChunk.getEndLocation())) {
            logger.severe(this.loggingName + " Truncating corrupted metadata tags from:" + (existingTag.getInfoTag().getStartLocationInFile() - 1L));
            fc.truncate(existingTag.getInfoTag().getStartLocationInFile() - 1L);
        } else {
            logger.severe(this.loggingName + " Truncating corrupted metadata tags from:" + existingTag.getInfoTag().getStartLocationInFile());
            fc.truncate(existingTag.getInfoTag().getStartLocationInFile());
        }
    }

    class BothTagsFileStructure {
        boolean isInfoTagFirst = false;
        boolean isContiguous = false;
        boolean isAtEnd = false;

        BothTagsFileStructure() {
        }

        public String toString() {
            return "IsInfoTagFirst:" + this.isInfoTagFirst + ":isContiguous:" + this.isContiguous + ":isAtEnd:" + this.isAtEnd;
        }
    }

    class InfoFieldWriterOrderComparator
    implements Comparator<TagField> {
        InfoFieldWriterOrderComparator() {
        }

        @Override
        public int compare(TagField field1, TagField field2) {
            WavInfoIdentifier code1 = WavInfoIdentifier.getByByFieldKey(FieldKey.valueOf(field1.getId()));
            WavInfoIdentifier code2 = WavInfoIdentifier.getByByFieldKey(FieldKey.valueOf(field2.getId()));
            int order1 = Integer.MAX_VALUE;
            int order2 = Integer.MAX_VALUE;
            if (code1 != null) {
                order1 = code1.getPreferredWriteOrder();
            }
            if (code2 != null) {
                order2 = code2.getPreferredWriteOrder();
            }
            return order1 - order2;
        }
    }
}

