/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkSummary;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavRIFFHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavCorruptChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavId3Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavListChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavInfoTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavTag;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

public class WavTagReader {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav");
    private String loggingName;

    public WavTagReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public WavTag read(Path path) throws CannotReadException, IOException {
        WavTag tag;
        block14: {
            logger.config(this.loggingName + " Read Tag:start");
            tag = new WavTag(TagOptionSingleton.getInstance().getWavOptions());
            try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                if (WavRIFFHeader.isValidHeader(this.loggingName, fc)) {
                    while (fc.position() < fc.size()) {
                        if (this.readChunk(fc, tag)) continue;
                        break block14;
                    }
                    break block14;
                }
                throw new CannotReadException(this.loggingName + " Wav RIFF Header not valid");
            }
        }
        this.createDefaultMetadataTagsIfMissing(tag);
        logger.config(this.loggingName + " Read Tag:end");
        return tag;
    }

    private void createDefaultMetadataTagsIfMissing(WavTag tag) {
        if (!tag.isExistingId3Tag()) {
            tag.setID3Tag(WavTag.createDefaultID3Tag());
        }
        if (!tag.isExistingInfoTag()) {
            tag.setInfoTag(new WavInfoTag());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean readChunk(FileChannel fc, WavTag tag) throws IOException, CannotReadException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        String id = chunkHeader.getID();
        logger.config(this.loggingName + " Next Id is:" + id + ":FileLocation:" + fc.position() + ":Size:" + chunkHeader.getSize());
        WavChunkType chunkType = WavChunkType.get(id);
        if (chunkType != null) {
            switch (chunkType) {
                case LIST: {
                    tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                    if (tag.getInfoTag() == null) {
                        WavListChunk chunk = new WavListChunk(this.loggingName, Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag);
                        if (((Chunk)chunk).readChunk()) break;
                        return false;
                    }
                    logger.warning(this.loggingName + " Ignoring LIST chunk because already have one:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile() - 1L) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                    break;
                }
                case ID3: {
                    tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                    if (tag.getID3Tag() == null) {
                        WavId3Chunk chunk = new WavId3Chunk(Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize()), chunkHeader, tag, this.loggingName);
                        if (((Chunk)chunk).readChunk()) break;
                        return false;
                    }
                    logger.warning(this.loggingName + " Ignoring id3 chunk because already have one:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                    break;
                }
                case CORRUPT_ID3_EARLY: {
                    logger.severe(this.loggingName + " Found Corrupt id3 chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                    if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                        tag.setIncorrectlyAlignedTag(true);
                    }
                    fc.position(fc.position() - 7L);
                    return true;
                }
                case CORRUPT_ID3_LATE: {
                    logger.severe(this.loggingName + " Found Corrupt id3 chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                    if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                        tag.setIncorrectlyAlignedTag(true);
                    }
                    fc.position(fc.position() - 7L);
                    return true;
                }
                default: {
                    tag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
                    fc.position(fc.position() + chunkHeader.getSize());
                    break;
                }
            }
        } else {
            if (id.substring(1, 4).equals(WavCorruptChunkType.CORRUPT_LIST_EARLY.getCode())) {
                logger.severe(this.loggingName + " Found Corrupt LIST Chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 7L);
                return true;
            }
            if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_LIST_LATE.getCode())) {
                logger.severe(this.loggingName + " Found Corrupt LIST Chunk (2), starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                if (tag.getInfoTag() == null && tag.getID3Tag() == null) {
                    tag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 9L);
                return true;
            }
            if (chunkHeader.getSize() < 0L) {
                String msg = this.loggingName + " Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
            logger.config(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize() + "for" + chunkHeader.getID());
            fc.position(fc.position() + chunkHeader.getSize());
            if (fc.position() > fc.size()) {
                String msg = this.loggingName + " Failed to move to invalid position to " + fc.position() + " because file length is only " + fc.size() + " indicates invalid chunk";
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

