/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class WavRIFFHeader {
    public static final String RIFF_SIGNATURE = "RIFF";
    public static final String WAVE_SIGNATURE = "WAVE";

    public static boolean isValidHeader(String loggingName, FileChannel fc) throws IOException, CannotReadException {
        if (fc.size() - fc.position() < (long)IffHeaderChunk.HEADER_LENGTH) {
            throw new CannotReadException("This is not a WAV File (<12 bytes)");
        }
        ByteBuffer headerBuffer = Utils.readFileDataIntoBufferLE(fc, IffHeaderChunk.HEADER_LENGTH);
        if (Utils.readFourBytesAsChars(headerBuffer).equals(RIFF_SIGNATURE)) {
            IffHeaderChunk.logger.finer(loggingName + ":Header:File:Size:" + headerBuffer.getInt());
            if (Utils.readFourBytesAsChars(headerBuffer).equals(WAVE_SIGNATURE)) {
                return true;
            }
        }
        return false;
    }
}

