/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.WavRIFFHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavCorruptChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavFactChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav.chunk.WavFormatChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

public class WavInfoReader {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.wav");
    private String loggingName;

    public WavInfoReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public GenericAudioHeader read(Path path) throws CannotReadException, IOException {
        GenericAudioHeader info;
        block14: {
            info = new GenericAudioHeader();
            try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                if (WavRIFFHeader.isValidHeader(this.loggingName, fc)) {
                    while (fc.position() < fc.size()) {
                        if (this.readChunk(fc, info)) continue;
                        break block14;
                    }
                    break block14;
                }
                throw new CannotReadException(this.loggingName + " Wav RIFF Header not valid");
            }
        }
        this.calculateTrackLength(info);
        return info;
    }

    private void calculateTrackLength(GenericAudioHeader info) throws CannotReadException {
        if (info.getNoOfSamples() != null) {
            if (info.getSampleRateAsNumber() > 0) {
                info.setPreciseLength((float)info.getNoOfSamples().longValue() / (float)info.getSampleRateAsNumber());
            }
        } else if (info.getAudioDataLength() > 0L) {
            info.setPreciseLength((float)info.getAudioDataLength().longValue() / (float)info.getByteRate().intValue());
        } else {
            throw new CannotReadException(this.loggingName + " Wav Data Header Missing");
        }
    }

    protected boolean readChunk(FileChannel fc, GenericAudioHeader info) throws IOException, CannotReadException {
        ChunkHeader chunkHeader;
        block13: {
            String id;
            block12: {
                chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
                if (!chunkHeader.readHeader(fc)) {
                    return false;
                }
                id = chunkHeader.getID();
                logger.finer(this.loggingName + " Reading Chunk:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                WavChunkType chunkType = WavChunkType.get(id);
                if (chunkType == null) break block12;
                switch (chunkType) {
                    case FACT: {
                        ByteBuffer fmtChunkData = Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize());
                        WavFactChunk chunk = new WavFactChunk(fmtChunkData, chunkHeader, info);
                        if (!((Chunk)chunk).readChunk()) {
                            return false;
                        }
                        break block13;
                    }
                    case DATA: {
                        info.setAudioDataLength(chunkHeader.getSize());
                        info.setAudioDataStartPosition(fc.position());
                        info.setAudioDataEndPosition(fc.position() + chunkHeader.getSize());
                        fc.position(fc.position() + chunkHeader.getSize());
                        break;
                    }
                    case FORMAT: {
                        ByteBuffer fmtChunkData = Utils.readFileDataIntoBufferLE(fc, (int)chunkHeader.getSize());
                        WavFormatChunk chunk = new WavFormatChunk(fmtChunkData, chunkHeader, info);
                        if (!((Chunk)chunk).readChunk()) {
                            return false;
                        }
                        break block13;
                    }
                    default: {
                        logger.config(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize());
                        fc.position(fc.position() + chunkHeader.getSize());
                        break;
                    }
                }
                break block13;
            }
            if (id.substring(1, 4).equals(WavCorruptChunkType.CORRUPT_LIST_EARLY.getCode())) {
                logger.severe(this.loggingName + " Found Corrupt LIST Chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                fc.position(fc.position() - 7L);
                return true;
            }
            if (id.substring(0, 3).equals(WavCorruptChunkType.CORRUPT_LIST_LATE.getCode())) {
                logger.severe(this.loggingName + " Found Corrupt LIST Chunk (2), starting at Odd Location:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
                fc.position(fc.position() - 9L);
                return true;
            }
            if (chunkHeader.getSize() < 0L) {
                String msg = this.loggingName + " Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
            logger.config(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize() + " for " + chunkHeader.getID());
            fc.position(fc.position() + chunkHeader.getSize());
            if (fc.position() > fc.size()) {
                String msg = this.loggingName + " Failed to move to invalid position to " + fc.position() + " because file length is only " + fc.size() + " indicates invalid chunk:" + id;
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

