/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.real;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.real.RealChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.real.RealTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldDataInvalidException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RealFileReader
extends AudioFileReader {
    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        GenericAudioHeader rv = new GenericAudioHeader();
        RealChunk prop = this.findPropChunk(raf);
        DataInputStream dis = prop.getDataInputStream();
        int objVersion = Utils.readUint16(dis);
        if (objVersion == 0) {
            long maxBitRate = Utils.readUint32(dis) / 1000L;
            long avgBitRate = Utils.readUint32(dis) / 1000L;
            long maxPacketSize = Utils.readUint32(dis);
            long avgPacketSize = Utils.readUint32(dis);
            long packetCnt = Utils.readUint32(dis);
            int duration = (int)Utils.readUint32(dis) / 1000;
            long preroll = Utils.readUint32(dis);
            long indexOffset = Utils.readUint32(dis);
            long dataOffset = Utils.readUint32(dis);
            int numStreams = Utils.readUint16(dis);
            int flags = Utils.readUint16(dis);
            rv.setBitRate((int)avgBitRate);
            rv.setPreciseLength(duration);
            rv.setVariableBitRate(maxBitRate != avgBitRate);
        }
        return rv;
    }

    private RealChunk findPropChunk(RandomAccessFile raf) throws IOException, CannotReadException {
        RealChunk rmf = RealChunk.readChunk(raf);
        RealChunk prop = RealChunk.readChunk(raf);
        return prop;
    }

    private RealChunk findContChunk(RandomAccessFile raf) throws IOException, CannotReadException {
        RealChunk rmf = RealChunk.readChunk(raf);
        RealChunk prop = RealChunk.readChunk(raf);
        RealChunk rv = RealChunk.readChunk(raf);
        while (!rv.isCONT()) {
            rv = RealChunk.readChunk(raf);
        }
        return rv;
    }

    @Override
    protected Tag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        RealChunk cont = this.findContChunk(raf);
        DataInputStream dis = cont.getDataInputStream();
        String title = Utils.readString(dis, Utils.readUint16(dis));
        String author = Utils.readString(dis, Utils.readUint16(dis));
        String copyright = Utils.readString(dis, Utils.readUint16(dis));
        String comment = Utils.readString(dis, Utils.readUint16(dis));
        RealTag rv = new RealTag();
        try {
            rv.addField(FieldKey.TITLE, title.length() == 0 ? author : title);
            rv.addField(FieldKey.ARTIST, title.length() == 0 ? copyright : author);
            rv.addField(FieldKey.COMMENT, comment);
        }
        catch (FieldDataInvalidException fdie) {
            throw new RuntimeException(fdie);
        }
        return rv;
    }
}

