/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.real;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RealChunk {
    protected static final String RMF = ".RMF";
    protected static final String PROP = "PROP";
    protected static final String MDPR = "MDPR";
    protected static final String CONT = "CONT";
    protected static final String DATA = "DATA";
    protected static final String INDX = "INDX";
    private final String id;
    private final int size;
    private final byte[] bytes;

    public static RealChunk readChunk(RandomAccessFile raf) throws CannotReadException, IOException {
        String id = Utils.readString(raf, 4);
        int size = (int)Utils.readUint32(raf);
        if (size < 8) {
            throw new CannotReadException("Corrupt file: RealAudio chunk length at position " + (raf.getFilePointer() - 4L) + " cannot be less than 8");
        }
        if ((long)size > raf.length() - raf.getFilePointer() + 8L) {
            throw new CannotReadException("Corrupt file: RealAudio chunk length of " + size + " at position " + (raf.getFilePointer() - 4L) + " extends beyond the end of the file");
        }
        byte[] bytes = new byte[size - 8];
        raf.readFully(bytes);
        return new RealChunk(id, size, bytes);
    }

    public RealChunk(String id, int size, byte[] bytes) {
        this.id = id;
        this.size = size;
        this.bytes = bytes;
    }

    public DataInputStream getDataInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.getBytes()));
    }

    public boolean isCONT() {
        return CONT.equals(this.id);
    }

    public boolean isPROP() {
        return PROP.equals(this.id);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return this.id + "\t" + this.size;
    }
}

