/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.AbstractTagDisplayFormatter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class MPEGFrameHeader {
    private static final int BYTE_1 = 0;
    private static final int BYTE_2 = 1;
    private static final int BYTE_3 = 2;
    private static final int BYTE_4 = 3;
    public static final int HEADER_SIZE = 4;
    public static final int SYNC_SIZE = 2;
    public static final int SYNC_BYTE1 = 255;
    public static final int SYNC_BYTE2 = 224;
    public static final int SYNC_BIT_ANDSAMPING_BYTE3 = 252;
    private static final byte[] header = new byte[4];
    public static final Map<Integer, String> mpegVersionMap = new HashMap<Integer, String>();
    public static final int VERSION_2_5 = 0;
    public static final int VERSION_2 = 2;
    public static final int VERSION_1 = 3;
    public static final Map<Integer, String> mpegLayerMap;
    public static final int LAYER_I = 3;
    public static final int LAYER_II = 2;
    public static final int LAYER_III = 1;
    public static final int LAYER_I_SLOT_SIZE = 4;
    public static final int LAYER_II_SLOT_SIZE = 1;
    public static final int LAYER_III_SLOT_SIZE = 1;
    private static final Map<Integer, Integer> bitrateMap;
    public static final Map<Integer, String> modeMap;
    public static final int MODE_STEREO = 0;
    public static final int MODE_JOINT_STEREO = 1;
    public static final int MODE_DUAL_CHANNEL = 2;
    public static final int MODE_MONO = 3;
    private static final Map<Integer, String> emphasisMap;
    public static final int EMPHASIS_NONE = 0;
    public static final int EMPHASIS_5015MS = 1;
    public static final int EMPHASIS_RESERVED = 2;
    public static final int EMPHASIS_CCITT = 3;
    private static final Map<Integer, String> modeExtensionMap;
    private static final int MODE_EXTENSION_NONE = 0;
    private static final int MODE_EXTENSION_ONE = 1;
    private static final int MODE_EXTENSION_TWO = 2;
    private static final int MODE_EXTENSION_THREE = 3;
    private static final Map<Integer, String> modeExtensionLayerIIIMap;
    private static final int MODE_EXTENSION_OFF_OFF = 0;
    private static final int MODE_EXTENSION_ON_OFF = 1;
    private static final int MODE_EXTENSION_OFF_ON = 2;
    private static final int MODE_EXTENSION_ON_ON = 3;
    private static final Map<Integer, Map<Integer, Integer>> samplingRateMap;
    private static final Map<Integer, Integer> samplingV1Map;
    private static final Map<Integer, Integer> samplingV2Map;
    private static final Map<Integer, Integer> samplingV25Map;
    private static final Map<Integer, Map<Integer, Integer>> samplesPerFrameMap;
    private static final Map<Integer, Integer> samplesPerFrameV1Map;
    private static final Map<Integer, Integer> samplesPerFrameV2Map;
    private static final Map<Integer, Integer> samplesPerFrameV25Map;
    private static final int SCALE_BY_THOUSAND = 1000;
    private static final int LAYER_I_FRAME_SIZE_COEFFICIENT = 12;
    private static final int LAYER_II_FRAME_SIZE_COEFFICIENT = 144;
    private static final int LAYER_III_FRAME_SIZE_COEFFICIENT = 144;
    private static final int MASK_MP3_ID = 8;
    private static final int MASK_MP3_VERSION = 24;
    private static final int MASK_MP3_LAYER = 6;
    private static final int MASK_MP3_PROTECTION = 1;
    private static final int MASK_MP3_BITRATE = 240;
    private static final int MASK_MP3_FREQUENCY = 12;
    private static final int MASK_MP3_PADDING = 2;
    private static final int MASK_MP3_PRIVACY = 1;
    private static final int MASK_MP3_MODE = 192;
    private static final int MASK_MP3_MODE_EXTENSION = 48;
    private static final int MASK_MP3_COPY = 8;
    private static final int MASK_MP3_HOME = 4;
    private static final int MASK_MP3_EMPHASIS = 3;
    private byte[] mpegBytes;
    private int version;
    private String versionAsString;
    private int layer;
    private String layerAsString;
    private Integer bitRate;
    private int channelMode;
    private String channelModeAsString;
    private int emphasis;
    private String emphasisAsString;
    private String modeExtension;
    private boolean isPadding;
    private boolean isCopyrighted;
    private boolean isOriginal;
    private boolean isProtected;
    private boolean isPrivate;
    private Integer samplingRate;

    public int getLayer() {
        return this.layer;
    }

    public String getLayerAsString() {
        return this.layerAsString;
    }

    private void setCopyrighted() {
        this.isCopyrighted = (this.mpegBytes[3] & 8) != 0;
    }

    private void setVersion() throws InvalidAudioFrameException {
        this.version = (byte)((this.mpegBytes[1] & 0x18) >> 3);
        this.versionAsString = mpegVersionMap.get(this.version);
        if (this.versionAsString == null) {
            throw new InvalidAudioFrameException("Invalid mpeg version");
        }
    }

    private void setOriginal() {
        this.isOriginal = (this.mpegBytes[3] & 4) != 0;
    }

    private void setProtected() {
        this.isProtected = (this.mpegBytes[1] & 1) == 0;
    }

    private void setPrivate() {
        this.isPrivate = (this.mpegBytes[2] & 1) != 0;
    }

    private void setBitrate() throws InvalidAudioFrameException {
        int bitRateIndex = this.mpegBytes[2] & 0xF0 | this.mpegBytes[1] & 8 | this.mpegBytes[1] & 6;
        this.bitRate = bitrateMap.get(bitRateIndex);
        if (this.bitRate == null) {
            throw new InvalidAudioFrameException("Invalid bitrate");
        }
    }

    private void setChannelMode() throws InvalidAudioFrameException {
        this.channelMode = (this.mpegBytes[3] & 0xC0) >>> 6;
        this.channelModeAsString = modeMap.get(this.channelMode);
        if (this.channelModeAsString == null) {
            throw new InvalidAudioFrameException("Invalid channel mode");
        }
    }

    private void setEmphasis() throws InvalidAudioFrameException {
        this.emphasis = this.mpegBytes[3] & 3;
        this.emphasisAsString = emphasisMap.get(this.emphasis);
        if (this.getEmphasisAsString() == null) {
            throw new InvalidAudioFrameException("Invalid emphasis");
        }
    }

    private void setPadding() {
        this.isPadding = (this.mpegBytes[2] & 2) != 0;
    }

    private void setLayer() throws InvalidAudioFrameException {
        this.layer = (this.mpegBytes[1] & 6) >>> 1;
        this.layerAsString = mpegLayerMap.get(this.layer);
        if (this.layerAsString == null) {
            throw new InvalidAudioFrameException("Invalid Layer");
        }
    }

    private void setModeExtension() throws InvalidAudioFrameException {
        int index = (this.mpegBytes[3] & 0x30) >> 4;
        if (this.layer == 1) {
            this.modeExtension = modeExtensionLayerIIIMap.get(index);
            if (this.getModeExtension() == null) {
                throw new InvalidAudioFrameException("Invalid Mode Extension");
            }
        } else {
            this.modeExtension = modeExtensionMap.get(index);
            if (this.getModeExtension() == null) {
                throw new InvalidAudioFrameException("Invalid Mode Extension");
            }
        }
    }

    private void setSamplingRate() throws InvalidAudioFrameException {
        int index = (this.mpegBytes[2] & 0xC) >>> 2;
        Map<Integer, Integer> samplingRateMapForVersion = samplingRateMap.get(this.version);
        if (samplingRateMapForVersion == null) {
            throw new InvalidAudioFrameException("Invalid version");
        }
        this.samplingRate = samplingRateMapForVersion.get(index);
        if (this.samplingRate == null) {
            throw new InvalidAudioFrameException("Invalid sampling rate");
        }
    }

    public int getNumberOfChannels() {
        switch (this.channelMode) {
            case 2: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 0;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public String getChannelModeAsString() {
        return this.channelModeAsString;
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionAsString() {
        return this.versionAsString;
    }

    public int getPaddingLength() {
        if (this.isPadding()) {
            return 1;
        }
        return 0;
    }

    public Integer getBitRate() {
        return this.bitRate;
    }

    public Integer getSamplingRate() {
        return this.samplingRate;
    }

    public int getFrameLength() {
        switch (this.version) {
            case 0: 
            case 2: {
                switch (this.layer) {
                    case 3: {
                        return (12 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength()) * 4;
                    }
                    case 2: {
                        return 144 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength() * 1;
                    }
                    case 1: {
                        if (this.getChannelMode() == 3) {
                            return 72 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength() * 1;
                        }
                        return 144 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength() * 1;
                    }
                }
                throw new RuntimeException("Mp3 Unknown Layer:" + this.layer);
            }
            case 3: {
                switch (this.layer) {
                    case 3: {
                        return (12 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength()) * 4;
                    }
                    case 2: {
                        return 144 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength() * 1;
                    }
                    case 1: {
                        return 144 * (this.getBitRate() * 1000) / this.getSamplingRate() + this.getPaddingLength() * 1;
                    }
                }
                throw new RuntimeException("Mp3 Unknown Layer:" + this.layer);
            }
        }
        throw new RuntimeException("Mp3 Unknown Version:" + this.version);
    }

    public int getNoOfSamples() {
        Integer noOfSamples = samplesPerFrameMap.get(this.version).get(this.layer);
        return noOfSamples;
    }

    public boolean isPadding() {
        return this.isPadding;
    }

    public boolean isCopyrighted() {
        return this.isCopyrighted;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isVariableBitRate() {
        return false;
    }

    public int getEmphasis() {
        return this.emphasis;
    }

    public String getEmphasisAsString() {
        return this.emphasisAsString;
    }

    public String getModeExtension() {
        return this.modeExtension;
    }

    private MPEGFrameHeader() throws InvalidAudioFrameException {
    }

    private MPEGFrameHeader(byte[] b) throws InvalidAudioFrameException {
        this.mpegBytes = b;
        this.setBitrate();
        this.setVersion();
        this.setLayer();
        this.setProtected();
        this.setSamplingRate();
        this.setPadding();
        this.setPrivate();
        this.setChannelMode();
        this.setModeExtension();
        this.setCopyrighted();
        this.setOriginal();
        this.setEmphasis();
    }

    public static MPEGFrameHeader parseMPEGHeader(ByteBuffer bb) throws InvalidAudioFrameException {
        int position = bb.position();
        bb.get(header, 0, 4);
        bb.position(position);
        MPEGFrameHeader frameHeader = new MPEGFrameHeader(header);
        return frameHeader;
    }

    public static boolean isMPEGFrame(ByteBuffer bb) {
        int position = bb.position();
        return (bb.get(position) & 0xFF) == 255 && (bb.get(position + 1) & 0xE0) == 224 && (bb.get(position + 2) & 0xFC) != 252;
    }

    public String toString() {
        return " mpeg frameheader: frame length:" + this.getFrameLength() + " version:" + this.versionAsString + " layer:" + this.layerAsString + " channelMode:" + this.channelModeAsString + " noOfSamples:" + this.getNoOfSamples() + " samplingRate:" + this.samplingRate + " isPadding:" + this.isPadding + " isProtected:" + this.isProtected + " isPrivate:" + this.isPrivate + " isCopyrighted:" + this.isCopyrighted + " isOriginal:" + this.isCopyrighted + " isVariableBitRate" + this.isVariableBitRate() + " header as binary:" + AbstractTagDisplayFormatter.displayAsBinary(this.mpegBytes[0]) + " " + AbstractTagDisplayFormatter.displayAsBinary(this.mpegBytes[1]) + " " + AbstractTagDisplayFormatter.displayAsBinary(this.mpegBytes[2]) + " " + AbstractTagDisplayFormatter.displayAsBinary(this.mpegBytes[3]);
    }

    static {
        mpegVersionMap.put(0, "MPEG-2.5");
        mpegVersionMap.put(2, "MPEG-2");
        mpegVersionMap.put(3, "MPEG-1");
        mpegLayerMap = new HashMap<Integer, String>();
        mpegLayerMap.put(3, "Layer 1");
        mpegLayerMap.put(2, "Layer 2");
        mpegLayerMap.put(1, "Layer 3");
        bitrateMap = new HashMap<Integer, Integer>();
        bitrateMap.put(30, 32);
        bitrateMap.put(46, 64);
        bitrateMap.put(62, 96);
        bitrateMap.put(78, 128);
        bitrateMap.put(94, 160);
        bitrateMap.put(110, 192);
        bitrateMap.put(126, 224);
        bitrateMap.put(142, 256);
        bitrateMap.put(158, 288);
        bitrateMap.put(174, 320);
        bitrateMap.put(190, 352);
        bitrateMap.put(206, 384);
        bitrateMap.put(222, 416);
        bitrateMap.put(238, 448);
        bitrateMap.put(28, 32);
        bitrateMap.put(44, 48);
        bitrateMap.put(60, 56);
        bitrateMap.put(76, 64);
        bitrateMap.put(92, 80);
        bitrateMap.put(108, 96);
        bitrateMap.put(124, 112);
        bitrateMap.put(140, 128);
        bitrateMap.put(156, 160);
        bitrateMap.put(172, 192);
        bitrateMap.put(188, 224);
        bitrateMap.put(204, 256);
        bitrateMap.put(220, 320);
        bitrateMap.put(236, 384);
        bitrateMap.put(26, 32);
        bitrateMap.put(42, 40);
        bitrateMap.put(58, 48);
        bitrateMap.put(74, 56);
        bitrateMap.put(90, 64);
        bitrateMap.put(106, 80);
        bitrateMap.put(122, 96);
        bitrateMap.put(138, 112);
        bitrateMap.put(154, 128);
        bitrateMap.put(170, 160);
        bitrateMap.put(186, 192);
        bitrateMap.put(202, 224);
        bitrateMap.put(218, 256);
        bitrateMap.put(234, 320);
        bitrateMap.put(22, 32);
        bitrateMap.put(38, 48);
        bitrateMap.put(54, 56);
        bitrateMap.put(70, 64);
        bitrateMap.put(86, 80);
        bitrateMap.put(102, 96);
        bitrateMap.put(118, 112);
        bitrateMap.put(134, 128);
        bitrateMap.put(150, 144);
        bitrateMap.put(166, 160);
        bitrateMap.put(182, 176);
        bitrateMap.put(198, 192);
        bitrateMap.put(214, 224);
        bitrateMap.put(230, 256);
        bitrateMap.put(20, 8);
        bitrateMap.put(36, 16);
        bitrateMap.put(52, 24);
        bitrateMap.put(68, 32);
        bitrateMap.put(84, 40);
        bitrateMap.put(100, 48);
        bitrateMap.put(116, 56);
        bitrateMap.put(132, 64);
        bitrateMap.put(148, 80);
        bitrateMap.put(164, 96);
        bitrateMap.put(180, 112);
        bitrateMap.put(196, 128);
        bitrateMap.put(212, 144);
        bitrateMap.put(228, 160);
        bitrateMap.put(18, 8);
        bitrateMap.put(34, 16);
        bitrateMap.put(50, 24);
        bitrateMap.put(66, 32);
        bitrateMap.put(82, 40);
        bitrateMap.put(98, 48);
        bitrateMap.put(114, 56);
        bitrateMap.put(130, 64);
        bitrateMap.put(146, 80);
        bitrateMap.put(162, 96);
        bitrateMap.put(178, 112);
        bitrateMap.put(194, 128);
        bitrateMap.put(210, 144);
        bitrateMap.put(226, 160);
        modeMap = new HashMap<Integer, String>();
        modeMap.put(0, "Stereo");
        modeMap.put(1, "Joint Stereo");
        modeMap.put(2, "Dual");
        modeMap.put(3, "Mono");
        emphasisMap = new HashMap<Integer, String>();
        emphasisMap.put(0, "None");
        emphasisMap.put(1, "5015MS");
        emphasisMap.put(2, "Reserved");
        emphasisMap.put(3, "CCITT");
        modeExtensionMap = new HashMap<Integer, String>();
        modeExtensionLayerIIIMap = new HashMap<Integer, String>();
        modeExtensionMap.put(0, "4-31");
        modeExtensionMap.put(1, "8-31");
        modeExtensionMap.put(2, "12-31");
        modeExtensionMap.put(3, "16-31");
        modeExtensionLayerIIIMap.put(0, "off-off");
        modeExtensionLayerIIIMap.put(1, "on-off");
        modeExtensionLayerIIIMap.put(2, "off-on");
        modeExtensionLayerIIIMap.put(3, "on-on");
        samplingRateMap = new HashMap<Integer, Map<Integer, Integer>>();
        samplingV1Map = new HashMap<Integer, Integer>();
        samplingV2Map = new HashMap<Integer, Integer>();
        samplingV25Map = new HashMap<Integer, Integer>();
        samplingV1Map.put(0, 44100);
        samplingV1Map.put(1, 48000);
        samplingV1Map.put(2, 32000);
        samplingV2Map.put(0, 22050);
        samplingV2Map.put(1, 24000);
        samplingV2Map.put(2, 16000);
        samplingV25Map.put(0, 11025);
        samplingV25Map.put(1, 12000);
        samplingV25Map.put(2, 8000);
        samplingRateMap.put(3, samplingV1Map);
        samplingRateMap.put(2, samplingV2Map);
        samplingRateMap.put(0, samplingV25Map);
        samplesPerFrameMap = new HashMap<Integer, Map<Integer, Integer>>();
        samplesPerFrameV1Map = new HashMap<Integer, Integer>();
        samplesPerFrameV2Map = new HashMap<Integer, Integer>();
        samplesPerFrameV25Map = new HashMap<Integer, Integer>();
        samplesPerFrameV1Map.put(3, 384);
        samplesPerFrameV1Map.put(2, 1152);
        samplesPerFrameV1Map.put(1, 1152);
        samplesPerFrameV2Map.put(3, 384);
        samplesPerFrameV2Map.put(2, 1152);
        samplesPerFrameV2Map.put(1, 1152);
        samplesPerFrameV25Map.put(3, 384);
        samplesPerFrameV25Map.put(2, 1152);
        samplesPerFrameV25Map.put(1, 1152);
        samplesPerFrameMap.put(3, samplesPerFrameV1Map);
        samplesPerFrameMap.put(2, samplesPerFrameV2Map);
        samplesPerFrameMap.put(0, samplesPerFrameV25Map);
    }
}

