/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioFile;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.UnableToModifyFileException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Permissions;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.MP3AudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.AbstractTagDisplayFormatter;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.PlainTextTagDisplayFormatter;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.XMLTagDisplayFormatter;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagNotFoundException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v11Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v1Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v23Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v24Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.ID3V2Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MP3File
extends AudioFile {
    private static final int MINIMUM_FILESIZE = 150;
    protected static AbstractTagDisplayFormatter tagFormatter;
    private AbstractID3v2Tag id3v2tag = null;
    private ID3v24Tag id3v2Asv24tag = null;
    private AbstractLyrics3 lyrics3tag = null;
    private ID3v1Tag id3v1tag = null;
    public static final int LOAD_IDV1TAG = 2;
    public static final int LOAD_IDV2TAG = 4;
    public static final int LOAD_LYRICS3 = 8;
    public static final int LOAD_ALL = 14;

    public MP3File() {
    }

    public MP3File(String filename) throws IOException, TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException {
        this(new File(filename));
    }

    public MP3File(File file, int loadOptions) throws IOException, TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException {
        this(file, loadOptions, false);
    }

    private void readV1Tag(File file, RandomAccessFile newFile, int loadOptions) throws IOException {
        if ((loadOptions & 2) != 0) {
            logger.finer("Attempting to read id3v1tags");
            try {
                this.id3v1tag = new ID3v11Tag(newFile, file.getName());
            }
            catch (TagNotFoundException ex) {
                logger.config("No ids3v11 tag found");
            }
            try {
                if (this.id3v1tag == null) {
                    this.id3v1tag = new ID3v1Tag(newFile, file.getName());
                }
            }
            catch (TagNotFoundException ex) {
                logger.config("No id3v1 tag found");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readV2Tag(File file, int loadOptions, int startByte) throws IOException, TagException {
        if (startByte >= 10) {
            logger.finer("Attempting to read id3v2tags");
            try (FileInputStream fis = new FileInputStream(file);){
                ByteBuffer bb = ByteBuffer.allocateDirect(startByte);
                fis.getChannel().read(bb, 0L);
                bb.rewind();
                if ((loadOptions & 4) == 0) return;
                logger.config("Attempting to read id3v2tags");
                try {
                    this.setID3v2Tag(new ID3v24Tag(bb, file.getName()));
                }
                catch (TagNotFoundException ex) {
                    logger.config("No id3v24 tag found");
                }
                try {
                    if (this.id3v2tag == null) {
                        this.setID3v2Tag(new ID3v23Tag(bb, file.getName()));
                    }
                }
                catch (TagNotFoundException ex) {
                    logger.config("No id3v23 tag found");
                }
                try {
                    if (this.id3v2tag != null) return;
                    this.setID3v2Tag(new ID3v22Tag(bb, file.getName()));
                    return;
                }
                catch (TagNotFoundException ex) {
                    logger.config("No id3v22 tag found");
                }
                return;
            }
        }
        logger.config("Not enough room for valid id3v2 tag:" + startByte);
    }

    private void readLyrics3Tag(File file, RandomAccessFile newFile, int loadOptions) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFilePortionNull(int startByte, int endByte) throws IOException {
        logger.config("Checking file portion:" + Hex.asHex(startByte) + ":" + Hex.asHex(endByte));
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(this.file);
            fc = fis.getChannel();
            ((FileChannel)fc).position(startByte);
            ByteBuffer bb = ByteBuffer.allocateDirect(endByte - startByte);
            ((FileChannel)fc).read(bb);
            while (bb.hasRemaining()) {
                if (bb.get() == 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return true;
    }

    private MP3AudioHeader checkAudioStart(long startByte, MP3AudioHeader firstHeaderAfterTag) throws IOException, InvalidAudioFrameException {
        logger.warning(ErrorMessage.MP3_ID3TAG_LENGTH_INCORRECT.getMsg(this.file.getPath(), Hex.asHex(startByte), Hex.asHex(firstHeaderAfterTag.getMp3StartByte())));
        MP3AudioHeader headerOne = new MP3AudioHeader(this.file, 0L);
        logger.config("Checking from start:" + headerOne);
        if (firstHeaderAfterTag.getMp3StartByte() == headerOne.getMp3StartByte()) {
            logger.config(ErrorMessage.MP3_START_OF_AUDIO_CONFIRMED.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
            return firstHeaderAfterTag;
        }
        logger.config(ErrorMessage.MP3_RECALCULATED_POSSIBLE_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
        if (firstHeaderAfterTag.getNumberOfFrames() == headerOne.getNumberOfFrames()) {
            logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
            return headerOne;
        }
        if (this.isFilePortionNull((int)startByte, (int)firstHeaderAfterTag.getMp3StartByte())) {
            return firstHeaderAfterTag;
        }
        MP3AudioHeader headerTwo = new MP3AudioHeader(this.file, headerOne.getMp3StartByte() + (long)headerOne.mp3FrameHeader.getFrameLength());
        if (headerTwo.getMp3StartByte() == firstHeaderAfterTag.getMp3StartByte()) {
            logger.warning(ErrorMessage.MP3_START_OF_AUDIO_CONFIRMED.getMsg(this.file.getPath(), Hex.asHex(firstHeaderAfterTag.getMp3StartByte())));
            return firstHeaderAfterTag;
        }
        if (headerTwo.getNumberOfFrames() == headerOne.getNumberOfFrames()) {
            logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
            return headerOne;
        }
        logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(firstHeaderAfterTag.getMp3StartByte())));
        return firstHeaderAfterTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP3File(File file, int loadOptions, boolean readOnly) throws IOException, TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException {
        try (RandomAccessFile newFile = null;){
            this.file = file;
            newFile = this.checkFilePermissions(file, readOnly);
            long tagSizeReportedByHeader = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            logger.config("TagHeaderSize:" + Hex.asHex(tagSizeReportedByHeader));
            this.audioHeader = new MP3AudioHeader(file, tagSizeReportedByHeader);
            if (tagSizeReportedByHeader != ((MP3AudioHeader)this.audioHeader).getMp3StartByte()) {
                logger.config("First header found after tag:" + this.audioHeader);
                this.audioHeader = this.checkAudioStart(tagSizeReportedByHeader, (MP3AudioHeader)this.audioHeader);
            }
            this.readV1Tag(file, newFile, loadOptions);
            this.readV2Tag(file, loadOptions, (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte());
            if (this.getID3v2Tag() != null) {
                this.tag = this.getID3v2Tag();
            } else if (this.id3v1tag != null) {
                this.tag = this.id3v1tag;
            }
        }
    }

    public long getMP3StartByte(File file) throws InvalidAudioFrameException, IOException {
        try {
            long startByte = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            MP3AudioHeader audioHeader = new MP3AudioHeader(file, startByte);
            if (startByte != audioHeader.getMp3StartByte()) {
                logger.config("First header found after tag:" + audioHeader);
                audioHeader = this.checkAudioStart(startByte, audioHeader);
            }
            return audioHeader.getMp3StartByte();
        }
        catch (InvalidAudioFrameException iafe) {
            throw iafe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public File extractID3v2TagDataIntoFile(File outputFile) throws TagNotFoundException, IOException {
        int startByte = (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte();
        if (startByte >= 0) {
            FileInputStream fis = new FileInputStream(this.file);
            FileChannel fc = fis.getChannel();
            ByteBuffer bb = ByteBuffer.allocate(startByte);
            fc.read(bb);
            FileOutputStream out = new FileOutputStream(outputFile);
            out.write(bb.array());
            out.close();
            fc.close();
            fis.close();
            return outputFile;
        }
        throw new TagNotFoundException("There is no ID3v2Tag data in this file");
    }

    public MP3AudioHeader getMP3AudioHeader() {
        return (MP3AudioHeader)this.getAudioHeader();
    }

    public boolean hasID3v1Tag() {
        return this.id3v1tag != null;
    }

    public boolean hasID3v2Tag() {
        return this.id3v2tag != null;
    }

    public MP3File(File file) throws IOException, TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException {
        this(file, 14);
    }

    public void setID3v1Tag(ID3v1Tag id3v1tag) {
        logger.config("setting tagv1:v1 tag");
        this.id3v1tag = id3v1tag;
    }

    public void setID3v1Tag(Tag id3v1tag) {
        logger.config("setting tagv1:v1 tag");
        this.id3v1tag = (ID3v1Tag)id3v1tag;
    }

    public void setID3v1Tag(AbstractTag mp3tag) {
        logger.config("setting tagv1:abstract");
        this.id3v1tag = new ID3v11Tag(mp3tag);
    }

    public ID3v1Tag getID3v1Tag() {
        return this.id3v1tag;
    }

    public byte[] getHash(String algorithm) throws NoSuchAlgorithmException, InvalidAudioFrameException, IOException {
        return this.getHash(algorithm, 32768);
    }

    public byte[] getHash(int buffer) throws NoSuchAlgorithmException, InvalidAudioFrameException, IOException {
        return this.getHash("MD5", buffer);
    }

    public byte[] getHash() throws NoSuchAlgorithmException, InvalidAudioFrameException, IOException {
        return this.getHash("MD5", 32768);
    }

    public byte[] getHash(String algorithm, int bufferSize) throws InvalidAudioFrameException, IOException, NoSuchAlgorithmException {
        int read;
        File mp3File = this.getFile();
        long startByte = this.getMP3StartByte(mp3File);
        int id3v1TagSize = 0;
        if (this.hasID3v1Tag()) {
            ID3v1Tag id1tag = this.getID3v1Tag();
            id3v1TagSize = id1tag.getSize();
        }
        InputStream inStream = Files.newInputStream(Paths.get(mp3File.getAbsolutePath(), new String[0]), new OpenOption[0]);
        byte[] buffer = new byte[bufferSize];
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        inStream.skip(startByte);
        long totalSize = mp3File.length() - startByte - (long)id3v1TagSize;
        int pointer = buffer.length;
        while ((long)pointer <= totalSize) {
            read = inStream.read(buffer);
            digest.update(buffer, 0, read);
            pointer += buffer.length;
        }
        read = inStream.read(buffer, 0, (int)totalSize - pointer + buffer.length);
        digest.update(buffer, 0, read);
        byte[] hash = digest.digest();
        return hash;
    }

    public void setID3v2Tag(AbstractTag mp3tag) {
        this.id3v2tag = new ID3v24Tag(mp3tag);
    }

    public void setID3v2Tag(AbstractID3v2Tag id3v2tag) {
        this.id3v2tag = id3v2tag;
        this.id3v2Asv24tag = id3v2tag instanceof ID3v24Tag ? (ID3v24Tag)this.id3v2tag : new ID3v24Tag((AbstractTag)id3v2tag);
    }

    public void setID3v2TagOnly(AbstractID3v2Tag id3v2tag) {
        this.id3v2tag = id3v2tag;
        this.id3v2Asv24tag = null;
    }

    public AbstractID3v2Tag getID3v2Tag() {
        return this.id3v2tag;
    }

    public ID3v24Tag getID3v2TagAsv24() {
        return this.id3v2Asv24tag;
    }

    public void delete(AbstractTag mp3tag) throws FileNotFoundException, IOException {
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        mp3tag.delete(raf);
        raf.close();
        if (mp3tag instanceof ID3v1Tag) {
            this.id3v1tag = null;
        }
        if (mp3tag instanceof AbstractID3v2Tag) {
            this.id3v2tag = null;
        }
    }

    public void save() throws IOException, TagException {
        this.save(this.file);
    }

    @Override
    public void commit() throws CannotWriteException {
        try {
            this.save();
        }
        catch (UnableToModifyFileException umfe) {
            throw new NoWritePermissionsException(umfe);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(ioe);
        }
        catch (TagException te) {
            throw new CannotWriteException(te);
        }
    }

    public void precheck(File file) throws IOException {
        Path path = file.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
        }
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(path)) {
            logger.severe(Permissions.displayPermissions(path));
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
        }
        if (file.length() <= 150L) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
        }
    }

    public void save(File fileToSave) throws IOException {
        File file = fileToSave.getAbsoluteFile();
        logger.config("Saving  : " + file.getPath());
        this.precheck(file);
        try (RandomAccessFile rfile = null;){
            if (TagOptionSingleton.getInstance().isId3v2Save()) {
                if (this.id3v2tag == null) {
                    rfile = new RandomAccessFile(file, "rw");
                    new ID3v24Tag().delete(rfile);
                    new ID3v23Tag().delete(rfile);
                    new ID3v22Tag().delete(rfile);
                    logger.config("Deleting ID3v2 tag:" + file.getName());
                    rfile.close();
                } else {
                    logger.config("Writing ID3v2 tag:" + file.getName());
                    MP3AudioHeader mp3AudioHeader = (MP3AudioHeader)this.getAudioHeader();
                    long mp3StartByte = mp3AudioHeader.getMp3StartByte();
                    long newMp3StartByte = this.id3v2tag.write(file, mp3StartByte);
                    if (mp3StartByte != newMp3StartByte) {
                        logger.config("New mp3 start byte: " + newMp3StartByte);
                        mp3AudioHeader.setMp3StartByte(newMp3StartByte);
                    }
                }
            }
            rfile = new RandomAccessFile(file, "rw");
            if (TagOptionSingleton.getInstance().isLyrics3Save() && this.lyrics3tag != null) {
                this.lyrics3tag.write(rfile);
            }
            if (TagOptionSingleton.getInstance().isId3v1Save()) {
                logger.config("Processing ID3v1");
                if (this.id3v1tag == null) {
                    logger.config("Deleting ID3v1");
                    new ID3v1Tag().delete(rfile);
                } else {
                    logger.config("Saving ID3v1");
                    this.id3v1tag.write(rfile);
                }
            }
        }
    }

    @Override
    public String displayStructureAsXML() {
        MP3File.createXMLStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    @Override
    public String displayStructureAsPlainText() {
        MP3File.createPlainTextStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    private static void createXMLStructureFormatter() {
        tagFormatter = new XMLTagDisplayFormatter();
    }

    private static void createPlainTextStructureFormatter() {
        tagFormatter = new PlainTextTagDisplayFormatter();
    }

    public static AbstractTagDisplayFormatter getStructureFormatter() {
        return tagFormatter;
    }

    @Override
    public void setTag(Tag tag) {
        this.tag = tag;
        if (tag instanceof ID3v1Tag) {
            this.setID3v1Tag((ID3v1Tag)tag);
        } else {
            this.setID3v2Tag((AbstractID3v2Tag)tag);
        }
    }

    @Override
    public Tag createDefaultTag() {
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V24) {
            return new ID3v24Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V23) {
            return new ID3v23Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V22) {
            return new ID3v22Tag();
        }
        return new ID3v24Tag();
    }

    @Override
    public Tag getTagOrCreateDefault() {
        AbstractID3v2Tag tag = this.getID3v2Tag();
        if (tag == null) {
            return this.createDefaultTag();
        }
        return tag;
    }

    @Override
    public Tag getTagAndConvertOrCreateDefault() {
        Tag tag = this.getTagOrCreateDefault();
        AbstractID3v2Tag convertedTag = this.convertID3Tag((AbstractID3v2Tag)tag, TagOptionSingleton.getInstance().getID3V2Version());
        if (convertedTag != null) {
            return convertedTag;
        }
        return tag;
    }

    @Override
    public Tag getTagAndConvertOrCreateAndSetDefault() {
        Tag tag = this.getTagAndConvertOrCreateDefault();
        this.setTag(tag);
        return this.getTag();
    }
}

