/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class LameFrame {
    public static final int LAME_HEADER_BUFFER_SIZE = 36;
    public static final int ENCODER_SIZE = 9;
    public static final int LAME_ID_SIZE = 4;
    public static final String LAME_ID = "LAME";
    private String encoder;

    private LameFrame(ByteBuffer lameHeader) {
        this.encoder = Utils.getString(lameHeader, 0, 9, StandardCharsets.ISO_8859_1);
    }

    public static LameFrame parseLameFrame(ByteBuffer bb) {
        ByteBuffer lameHeader = bb.slice();
        String id = Utils.getString(lameHeader, 0, 4, StandardCharsets.ISO_8859_1);
        lameHeader.rewind();
        if (id.equals(LAME_ID)) {
            LameFrame lameFrame = new LameFrame(lameHeader);
            return lameFrame;
        }
        return null;
    }

    public String getEncoder() {
        return this.encoder;
    }
}

