/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.MP3AudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.MPEGFrameHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.XingFrame;
import java.nio.ByteBuffer;

public class ByteArrayMP3AudioHeader
extends MP3AudioHeader {
    public ByteArrayMP3AudioHeader(byte[] fileBytes) {
        long filePointerCount = 0L;
        ByteBuffer bb = ByteBuffer.wrap(fileBytes);
        boolean syncFound = false;
        do {
            if (MPEGFrameHeader.isMPEGFrame(bb)) {
                try {
                    this.mp3FrameHeader = MPEGFrameHeader.parseMPEGHeader(bb);
                    syncFound = true;
                    ByteBuffer header = XingFrame.isXingFrame(bb, this.mp3FrameHeader);
                    if (header != null) {
                        try {
                            this.mp3XingFrame = XingFrame.parseXingFrame(header);
                        }
                        catch (InvalidAudioFrameException invalidAudioFrameException) {}
                        break;
                    }
                    syncFound = this.isNextFrameValid(bb);
                    if (syncFound) {
                        break;
                    }
                }
                catch (InvalidAudioFrameException invalidAudioFrameException) {
                    // empty catch block
                }
            }
            bb.position(bb.position() + 1);
            ++filePointerCount;
        } while (!syncFound);
        this.setFileSize(fileBytes.length);
        this.setMp3StartByte(filePointerCount);
        this.setTimePerFrame();
        this.setNumberOfFrames();
        this.setTrackLength();
        this.setBitRate();
        this.setEncoder();
    }

    private boolean isNextFrameValid(ByteBuffer bb) {
        boolean result = false;
        int currentPosition = bb.position();
        bb.position(bb.position() + this.mp3FrameHeader.getFrameLength());
        if (MPEGFrameHeader.isMPEGFrame(bb)) {
            try {
                MPEGFrameHeader.parseMPEGHeader(bb);
                MP3AudioHeader.logger.finer("Check next frame confirms is an audio header ");
                result = true;
            }
            catch (InvalidAudioFrameException ex) {
                MP3AudioHeader.logger.finer("Check next frame has identified this is not an audio header");
                result = false;
            }
        }
        bb.position(currentPosition);
        return result;
    }
}

