/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;

public class IffHeaderChunk {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff");
    public static int SIGNATURE_LENGTH = 4;
    public static int SIZE_LENGTH = 4;
    public static int TYPE_LENGTH = 4;
    public static int HEADER_LENGTH = SIGNATURE_LENGTH + SIZE_LENGTH + TYPE_LENGTH;

    public static void ensureOnEqualBoundary(RandomAccessFile raf, ChunkHeader chunkHeader) throws IOException {
        if (Utils.isOddLength(chunkHeader.getSize()) && raf.getFilePointer() < raf.length()) {
            logger.config("Skipping Byte because on odd boundary");
            raf.skipBytes(1);
        }
    }

    public static void ensureOnEqualBoundary(FileChannel fc, ChunkHeader chunkHeader) throws IOException {
        if (Utils.isOddLength(chunkHeader.getSize()) && fc.position() < fc.size()) {
            logger.config("Skipping Byte because on odd boundary");
            fc.position(fc.position() + 1L);
        }
    }
}

