/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.logging.Logger;

public class Permissions {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic");

    public static String displayPermissions(Path path) {
        StringBuilder sb = new StringBuilder();
        sb.append("File " + path + " permissions\n");
        try {
            FileOwnerAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                sb.append("owner:" + view.getOwner().getName() + "\n");
                for (AclEntry acl : view.getAcl()) {
                    sb.append(acl + "\n");
                }
            }
            if ((view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
                PosixFileAttributes pfa = view.readAttributes();
                sb.append(":owner:" + pfa.owner().getName() + ":group:" + pfa.group().getName() + ":" + PosixFilePermissions.toString(pfa.permissions()) + "\n");
            }
        }
        catch (IOException ioe) {
            logger.severe("Unable to read permissions for:" + path.toString());
        }
        return sb.toString();
    }
}

