/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AbstractTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldDataInvalidException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.KeyNotFoundException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagTextField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.images.Artwork;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public abstract class GenericTag
extends AbstractTag {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected static EnumSet<FieldKey> supportedKeys = EnumSet.of(FieldKey.ALBUM, new FieldKey[]{FieldKey.ARTIST, FieldKey.TITLE, FieldKey.TRACK, FieldKey.GENRE, FieldKey.COMMENT, FieldKey.YEAR});

    public static EnumSet<FieldKey> getSupportedKeys() {
        return supportedKeys;
    }

    @Override
    protected boolean isAllowedEncoding(Charset enc) {
        return true;
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        if (supportedKeys.contains((Object)genericKey)) {
            if (values == null || values[0] == null) {
                throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
            }
            return new GenericTagTextField(genericKey.name(), values[0]);
        }
        throw new UnsupportedOperationException(ErrorMessage.OPERATION_NOT_SUPPORTED_FOR_FIELD.getMsg(new Object[]{genericKey}));
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        return this.getValue(genericKey, 0);
    }

    @Override
    public String getValue(FieldKey genericKey, int index) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)genericKey)) {
            return this.getItem(genericKey.name(), index);
        }
        throw new UnsupportedOperationException(ErrorMessage.OPERATION_NOT_SUPPORTED_FOR_FIELD.getMsg(new Object[]{genericKey}));
    }

    @Override
    public List<TagField> getFields(FieldKey genericKey) throws KeyNotFoundException {
        List list = (List)this.fields.get(genericKey.name());
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        return super.getAll(genericKey.name());
    }

    @Override
    public void deleteField(FieldKey genericKey) throws KeyNotFoundException {
        if (!supportedKeys.contains((Object)genericKey)) {
            throw new UnsupportedOperationException(ErrorMessage.OPERATION_NOT_SUPPORTED_FOR_FIELD.getMsg(new Object[]{genericKey}));
        }
        this.deleteField(genericKey.name());
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)genericKey)) {
            return this.getFirstField(genericKey.name());
        }
        throw new UnsupportedOperationException(ErrorMessage.OPERATION_NOT_SUPPORTED_FOR_FIELD.getMsg(new Object[]{genericKey}));
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    protected class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String fieldId, String initialContent) {
            this.id = fieldId;
            this.content = initialContent;
        }

        @Override
        public void copyContent(TagField field) {
            if (field instanceof TagTextField) {
                this.content = ((TagTextField)field).getContent();
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public Charset getEncoding() {
            return StandardCharsets.ISO_8859_1;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getRawContent() {
            return this.content == null ? EMPTY_BYTE_ARRAY : this.content.getBytes(this.getEncoding());
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public void isBinary(boolean b) {
        }

        @Override
        public boolean isCommon() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return "".equals(this.content);
        }

        @Override
        public void setContent(String s) {
            this.content = s;
        }

        @Override
        public void setEncoding(Charset s) {
        }

        @Override
        public String toString() {
            return this.getContent();
        }
    }
}

