/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioFile;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileWriter;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Permissions;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;

public abstract class AudioFileWriter2
extends AudioFileWriter {
    @Override
    public void delete(AudioFile af) throws CannotReadException, CannotWriteException {
        Path file = af.getFile().toPath();
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(file)) {
            logger.severe(Permissions.displayPermissions(file));
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(file));
        }
        if (af.getFile().length() <= 100L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file));
        }
        this.deleteTag(af.getTag(), file);
    }

    @Override
    public void write(AudioFile af) throws CannotWriteException {
        Path file = af.getFile().toPath();
        if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(file)) {
            logger.severe(Permissions.displayPermissions(file));
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file));
        }
        if (af.getFile().length() <= 100L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file));
        }
        this.writeTag(af.getTag(), file);
    }

    protected abstract void deleteTag(Tag var1, Path var2) throws CannotReadException, CannotWriteException;

    @Override
    public void deleteTag(Tag tag, RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotReadException, CannotWriteException, IOException {
        throw new UnsupportedOperationException("Old method not used in version 2");
    }

    protected abstract void writeTag(Tag var1, Path var2) throws CannotWriteException;

    @Override
    protected void writeTag(AudioFile audioFile, Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotReadException, CannotWriteException, IOException {
        throw new UnsupportedOperationException("Old method not used in version 2");
    }
}

