/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioFile;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.NoReadPermissionsException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Permissions;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;

public abstract class AudioFileReader2
extends AudioFileReader {
    @Override
    public AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        Path path = f.toPath();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(ErrorMessage.GENERAL_READ.getMsg(path));
        }
        if (!Files.isReadable(path)) {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(ErrorMessage.UNABLE_TO_FIND_FILE.getMsg(path));
            }
            logger.warning(Permissions.displayPermissions(path));
            throw new NoReadPermissionsException(ErrorMessage.GENERAL_READ_FAILED_DO_NOT_HAVE_PERMISSION_TO_READ_FILE.getMsg(path));
        }
        if (f.length() <= 100L) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(path));
        }
        GenericAudioHeader info = this.getEncodingInfo(path);
        Tag tag = this.getTag(path);
        return new AudioFile(f, (AudioHeader)info, tag);
    }

    protected abstract GenericAudioHeader getEncodingInfo(Path var1) throws CannotReadException, IOException;

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        throw new UnsupportedOperationException("Old method not used in version 2");
    }

    protected abstract Tag getTag(Path var1) throws CannotReadException, IOException;

    @Override
    protected Tag getTag(RandomAccessFile file) throws CannotReadException, IOException {
        throw new UnsupportedOperationException("Old method not used in version 2");
    }
}

