/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.FlacStreamReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.FlacTagCreator;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlock;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataApplication;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataCueSheet;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataSeekTable;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.flac.FlacTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.utils.DirectByteBufferUtils;
import io.github.maki99999.biomebeats.org.jaudiotagger.utils.PrimitiveUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlacTagWriter {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac");
    private FlacTagCreator tc = new FlacTagCreator();

    public void delete(Tag tag, Path file) throws CannotWriteException {
        FlacTag emptyTag = new FlacTag(null, new ArrayList<MetadataBlockDataPicture>());
        this.write(emptyTag, file);
    }

    public void write(Tag tag, Path file) throws CannotWriteException {
        logger.config(file + " Writing tag");
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            MetadataBlockInfo blockInfo = new MetadataBlockInfo();
            FlacStreamReader flacStream = new FlacStreamReader(fc, file.toString() + " ");
            try {
                flacStream.findStream();
            }
            catch (CannotReadException cre) {
                throw new CannotWriteException(cre.getMessage());
            }
            boolean isLastBlock = false;
            while (!isLastBlock) {
                try {
                    MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(fc);
                    if (mbh.getBlockType() != null) {
                        switch (mbh.getBlockType()) {
                            case STREAMINFO: {
                                blockInfo.streamInfoBlock = new MetadataBlock(mbh, new MetadataBlockDataStreamInfo(mbh, fc));
                                break;
                            }
                            case VORBIS_COMMENT: 
                            case PADDING: 
                            case PICTURE: {
                                fc.position(fc.position() + (long)mbh.getDataLength());
                                MetadataBlockData mbd = new MetadataBlockDataPadding(mbh.getDataLength());
                                blockInfo.metadataBlockPadding.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            case APPLICATION: {
                                MetadataBlockData mbd = new MetadataBlockDataApplication(mbh, fc);
                                blockInfo.metadataBlockApplication.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            case SEEKTABLE: {
                                MetadataBlockData mbd = new MetadataBlockDataSeekTable(mbh, fc);
                                blockInfo.metadataBlockSeekTable.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            case CUESHEET: {
                                MetadataBlockData mbd = new MetadataBlockDataCueSheet(mbh, fc);
                                blockInfo.metadataBlockCueSheet.add(new MetadataBlock(mbh, mbd));
                                break;
                            }
                            default: {
                                fc.position(fc.position() + (long)mbh.getDataLength());
                            }
                        }
                    }
                    isLastBlock = mbh.isLastBlock();
                }
                catch (CannotReadException cre) {
                    throw new CannotWriteException(cre.getMessage());
                }
            }
            int availableRoom = this.computeAvailableRoom(blockInfo);
            int newTagSize = this.tc.convert(tag).limit();
            int otherBlocksRequiredSize = this.computeNeededRoom(blockInfo);
            int neededRoom = newTagSize + otherBlocksRequiredSize;
            fc.position(flacStream.getStartOfFlacInFile());
            logger.config(file + ":Writing tag available bytes:" + availableRoom + ":needed bytes:" + neededRoom);
            if (availableRoom == neededRoom || availableRoom > neededRoom + 4) {
                logger.config(file + ":Room to Rewrite");
                fc.position(flacStream.getStartOfFlacInFile() + 4);
                this.writeOtherMetadataBlocks(fc, blockInfo);
                fc.write(this.tc.convert(tag, availableRoom - neededRoom));
            } else {
                logger.config(file + ":Audio must be shifted NewTagSize:" + newTagSize + ":AvailableRoom:" + availableRoom + ":MinimumAdditionalRoomRequired:" + (neededRoom - availableRoom));
                this.insertUsingChunks(file, tag, fc, blockInfo, flacStream, neededRoom + 4000, availableRoom);
            }
        }
        catch (AccessDeniedException ade) {
            logger.log(Level.SEVERE, ade.getMessage(), ade);
            throw new NoWritePermissionsException(file + ":" + ade.getMessage());
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void insertUsingDirectBuffer(Path file, Tag tag, FileChannel fc, MetadataBlockInfo blockInfo, FlacStreamReader flacStream, int availableRoom) throws IOException {
        fc.position(flacStream.getStartOfFlacInFile() + 4 + 4 + 34 + availableRoom);
        ByteBuffer audioData = ByteBuffer.allocateDirect((int)(fc.size() - fc.position()));
        fc.read(audioData);
        audioData.flip();
        fc.position(flacStream.getStartOfFlacInFile() + 4);
        this.writeOtherMetadataBlocks(fc, blockInfo);
        fc.write(this.tc.convert(tag, 4000));
        fc.write(audioData);
    }

    private void insertUsingChunks(Path file, Tag tag, FileChannel fc, MetadataBlockInfo blockInfo, FlacStreamReader flacStream, int neededRoom, int availableRoom) throws IOException, UnsupportedEncodingException {
        long originalFileSize = fc.size();
        long audioStart = flacStream.getStartOfFlacInFile() + 4 + 4 + 34 + availableRoom;
        int extraSpaceRequired = neededRoom - availableRoom;
        logger.config(file + " Audio needs shifting:" + extraSpaceRequired);
        int chunkSize = (int)TagOptionSingleton.getInstance().getWriteChunkSize();
        if (chunkSize < extraSpaceRequired) {
            chunkSize = extraSpaceRequired;
        }
        LinkedBlockingQueue<ByteBuffer> queue = new LinkedBlockingQueue<ByteBuffer>();
        fc.position(audioStart);
        ByteBuffer audioBuffer = ByteBuffer.allocateDirect(chunkSize);
        fc.read(audioBuffer);
        audioBuffer.flip();
        queue.add(audioBuffer);
        long readPosition = fc.position();
        fc.position(flacStream.getStartOfFlacInFile() + 4);
        this.writeOtherMetadataBlocks(fc, blockInfo);
        fc.write(this.tc.convert(tag, 4000));
        long writePosition = fc.position();
        fc.position(readPosition);
        while (fc.position() < originalFileSize) {
            ByteBuffer audioBuffer2 = ByteBuffer.allocateDirect(chunkSize);
            fc.read(audioBuffer2);
            readPosition = fc.position();
            audioBuffer2.flip();
            queue.add(audioBuffer2);
            fc.position(writePosition);
            fc.write((ByteBuffer)queue.remove());
            writePosition = fc.position();
            fc.position(readPosition);
        }
        fc.position(writePosition);
        fc.write((ByteBuffer)queue.remove());
    }

    private void insertTagAndShift(Path file, Tag tag, FileChannel fc, MetadataBlockInfo blockInfo, FlacStreamReader flacStream, int neededRoom, int availableRoom) throws IOException, UnsupportedEncodingException {
        int headerLength = flacStream.getStartOfFlacInFile() + 4 + 4 + 34;
        long targetSizeBeforeAudioData = headerLength + neededRoom + 4000;
        long remainderTargetSize = fc.size() - (long)(headerLength + availableRoom);
        long totalTargetSize = targetSizeBeforeAudioData + remainderTargetSize;
        MappedByteBuffer mappedFile = null;
        try {
            mappedFile = fc.map(FileChannel.MapMode.READ_WRITE, 0L, totalTargetSize);
            this.insertTagAndShiftViaMappedByteBuffer(tag, mappedFile, fc, targetSizeBeforeAudioData, totalTargetSize, blockInfo, flacStream, neededRoom, availableRoom);
        }
        catch (IOException ioe) {
            if (mappedFile == null) {
                this.insertUsingChunks(file, tag, fc, blockInfo, flacStream, neededRoom + 4000, availableRoom);
            }
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            throw ioe;
        }
    }

    private void insertTagAndShiftViaMappedByteBuffer(Tag tag, MappedByteBuffer mappedFile, FileChannel fc, long targetSizeBeforeAudioData, long totalTargetSize, MetadataBlockInfo blockInfo, FlacStreamReader flacStream, int neededRoom, int availableRoom) throws IOException, UnsupportedEncodingException {
        int currentPos;
        int currentEndOfFilePosition = PrimitiveUtils.safeLongToInt(fc.size());
        int currentEndOfTagsPosition = PrimitiveUtils.safeLongToInt(targetSizeBeforeAudioData - 4000L - (long)neededRoom + (long)availableRoom);
        int lengthDiff = PrimitiveUtils.safeLongToInt(totalTargetSize - (long)currentEndOfFilePosition);
        int BLOCK_SIZE = PrimitiveUtils.safeLongToInt(TagOptionSingleton.getInstance().getWriteChunkSize());
        byte[] buffer = new byte[BLOCK_SIZE];
        for (currentPos = currentEndOfFilePosition - BLOCK_SIZE; currentPos >= currentEndOfTagsPosition; currentPos -= BLOCK_SIZE) {
            mappedFile.position(currentPos);
            mappedFile.get(buffer, 0, BLOCK_SIZE);
            mappedFile.position(currentPos + lengthDiff);
            mappedFile.put(buffer, 0, BLOCK_SIZE);
        }
        int remainder = currentPos + BLOCK_SIZE - currentEndOfTagsPosition;
        if (remainder > 0) {
            mappedFile.position(currentEndOfTagsPosition);
            mappedFile.get(buffer, 0, remainder);
            mappedFile.position(currentEndOfTagsPosition + lengthDiff);
            mappedFile.put(buffer, 0, remainder);
        }
        DirectByteBufferUtils.release(mappedFile);
        this.writeTags(tag, fc, blockInfo, flacStream);
    }

    private void writeTags(Tag tag, FileChannel fc, MetadataBlockInfo blockInfo, FlacStreamReader flacStream) throws IOException, UnsupportedEncodingException {
        fc.position(flacStream.getStartOfFlacInFile() + 4);
        this.writeOtherMetadataBlocks(fc, blockInfo);
        fc.write(this.tc.convert(tag, 4000));
    }

    private void writeOtherMetadataBlocks(FileChannel fc, MetadataBlockInfo blockInfo) throws IOException {
        fc.write(ByteBuffer.wrap(blockInfo.streamInfoBlock.getHeader().getBytesWithoutIsLastBlockFlag()));
        fc.write(blockInfo.streamInfoBlock.getData().getBytes());
        for (MetadataBlock aMetadataBlockApplication : blockInfo.metadataBlockApplication) {
            fc.write(ByteBuffer.wrap(aMetadataBlockApplication.getHeader().getBytesWithoutIsLastBlockFlag()));
            fc.write(aMetadataBlockApplication.getData().getBytes());
        }
        for (MetadataBlock aMetadataBlockSeekTable : blockInfo.metadataBlockSeekTable) {
            fc.write(ByteBuffer.wrap(aMetadataBlockSeekTable.getHeader().getBytesWithoutIsLastBlockFlag()));
            fc.write(aMetadataBlockSeekTable.getData().getBytes());
        }
        for (MetadataBlock aMetadataBlockCueSheet : blockInfo.metadataBlockCueSheet) {
            fc.write(ByteBuffer.wrap(aMetadataBlockCueSheet.getHeader().getBytesWithoutIsLastBlockFlag()));
            fc.write(aMetadataBlockCueSheet.getData().getBytes());
        }
    }

    private int computeAvailableRoom(MetadataBlockInfo blockInfo) {
        int length = 0;
        for (MetadataBlock aMetadataBlockApplication : blockInfo.metadataBlockApplication) {
            length += aMetadataBlockApplication.getLength();
        }
        for (MetadataBlock aMetadataBlockSeekTable : blockInfo.metadataBlockSeekTable) {
            length += aMetadataBlockSeekTable.getLength();
        }
        for (MetadataBlock aMetadataBlockCueSheet : blockInfo.metadataBlockCueSheet) {
            length += aMetadataBlockCueSheet.getLength();
        }
        for (MetadataBlock aMetadataBlockPadding : blockInfo.metadataBlockPadding) {
            length += aMetadataBlockPadding.getLength();
        }
        return length;
    }

    private int computeNeededRoom(MetadataBlockInfo blockInfo) {
        int length = 0;
        for (MetadataBlock aMetadataBlockApplication : blockInfo.metadataBlockApplication) {
            length += aMetadataBlockApplication.getLength();
        }
        for (MetadataBlock aMetadataBlockSeekTable : blockInfo.metadataBlockSeekTable) {
            length += aMetadataBlockSeekTable.getLength();
        }
        for (MetadataBlock aMetadataBlockCueSheet : blockInfo.metadataBlockCueSheet) {
            length += aMetadataBlockCueSheet.getLength();
        }
        return length;
    }

    private static class MetadataBlockInfo {
        private MetadataBlock streamInfoBlock;
        private List<MetadataBlock> metadataBlockPadding = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockApplication = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockSeekTable = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockCueSheet = new ArrayList<MetadataBlock>(1);

        private MetadataBlockInfo() {
        }
    }
}

