/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.BlockType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AbstractTagCreator;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.flac.FlacTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.vorbiscomment.VorbisCommentCreator;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.logging.Logger;

public class FlacTagCreator
extends AbstractTagCreator {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac");
    public static final int DEFAULT_PADDING = 4000;
    private static final VorbisCommentCreator creator = new VorbisCommentCreator();

    @Override
    public ByteBuffer convert(Tag tag, int paddingSize) throws UnsupportedEncodingException {
        logger.config("Convert flac tag:padding:" + paddingSize);
        FlacTag flacTag = (FlacTag)tag;
        int tagLength = 0;
        ByteBuffer vorbiscomment = null;
        if (flacTag.getVorbisCommentTag() != null) {
            vorbiscomment = creator.convert(flacTag.getVorbisCommentTag());
            tagLength = vorbiscomment.capacity() + 4;
        }
        for (MetadataBlockDataPicture image : flacTag.getImages()) {
            tagLength += image.getBytes().limit() + 4;
        }
        logger.config("Convert flac tag:taglength:" + tagLength);
        ByteBuffer buf = ByteBuffer.allocate(tagLength + paddingSize);
        if (flacTag.getVorbisCommentTag() != null) {
            MetadataBlockHeader vorbisHeader = paddingSize > 0 || flacTag.getImages().size() > 0 ? new MetadataBlockHeader(false, BlockType.VORBIS_COMMENT, vorbiscomment.capacity()) : new MetadataBlockHeader(true, BlockType.VORBIS_COMMENT, vorbiscomment.capacity());
            buf.put(vorbisHeader.getBytes());
            buf.put(vorbiscomment);
        }
        ListIterator<MetadataBlockDataPicture> li = flacTag.getImages().listIterator();
        while (li.hasNext()) {
            MetadataBlockDataPicture imageField = li.next();
            MetadataBlockHeader imageHeader = paddingSize > 0 || li.hasNext() ? new MetadataBlockHeader(false, BlockType.PICTURE, imageField.getLength()) : new MetadataBlockHeader(true, BlockType.PICTURE, imageField.getLength());
            buf.put(imageHeader.getBytes());
            buf.put(imageField.getBytes());
        }
        logger.config("Convert flac tag at" + buf.position());
        if (paddingSize > 0) {
            int paddingDataSize = paddingSize - 4;
            MetadataBlockHeader paddingHeader = new MetadataBlockHeader(true, BlockType.PADDING, paddingDataSize);
            MetadataBlockDataPadding padding = new MetadataBlockDataPadding(paddingDataSize);
            buf.put(paddingHeader.getBytes());
            buf.put(padding.getBytes());
        }
        buf.rewind();
        return buf;
    }
}

